/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.io.Serializable;
import java.util.StringJoiner;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;

public class ParseUtil {
    private ParseUtil() {
    }

    public static void warn(IWarningCollector warningCollector, String dataSourceName, long lineNum, int fieldNum, String warnMessage) {
        warningCollector.warn(Warning.of(null, ErrorCode.PARSING_ERROR, new Serializable[]{ParseUtil.asLocationDetailString(dataSourceName, lineNum, fieldNum), warnMessage}));
    }

    public static String asLocationDetailString(String dataSource, long lineNum, Object fieldIdentifier) {
        StringJoiner details = new StringJoiner(" ");
        details.setEmptyValue("N/A");
        if (dataSource != null && !dataSource.isEmpty()) {
            details.add(dataSource);
        }
        if (lineNum >= 0L) {
            details.add("line " + lineNum);
        }
        if (fieldIdentifier instanceof Number) {
            details.add("field " + fieldIdentifier);
        } else if (fieldIdentifier instanceof String && !((String)fieldIdentifier).isEmpty()) {
            details.add("field '" + fieldIdentifier + "'");
        }
        return "at " + details;
    }
}

