/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationDestination
implements IReplicationDestination {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<IPartitionReplica> replicas = new HashSet<IPartitionReplica>();
    private final InetSocketAddress inputLocation;
    private InetSocketAddress resolvedLocation;
    private ISocketChannel logRepChannel;

    private ReplicationDestination(InetSocketAddress location) {
        this.inputLocation = location;
        this.resolvedLocation = NetworkUtil.ensureResolved((InetSocketAddress)location);
    }

    public static ReplicationDestination at(InetSocketAddress location) {
        if (!location.isUnresolved()) {
            throw new IllegalArgumentException("only unresolved addresses are allowed!");
        }
        return new ReplicationDestination(new InetSocketAddress(location.getHostString(), location.getPort()));
    }

    public synchronized void add(IPartitionReplica replica) {
        this.replicas.add(replica);
    }

    public synchronized void remove(IPartitionReplica replica) {
        this.replicas.remove(replica);
    }

    public synchronized void notifyFailure(Exception failure) {
        this.replicas.forEach(replica -> replica.notifyFailure(failure));
        this.closeLogReplicationChannel();
    }

    public Set<IPartitionReplica> getReplicas() {
        return new HashSet<IPartitionReplica>(this.replicas);
    }

    public synchronized Optional<IPartitionReplica> getPartitionReplica(int partition) {
        return this.replicas.stream().filter(replica -> replica.getIdentifier().getPartition() == partition && replica.getStatus() == IPartitionReplica.PartitionReplicaStatus.IN_SYNC).findAny();
    }

    public synchronized ISocketChannel getLogReplicationChannel(INcApplicationContext appCtx) {
        try {
            if (!NetworkingUtil.isHealthy(this.logRepChannel)) {
                this.establishReplicaConnection(appCtx);
            }
            return this.logRepChannel;
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    protected void establishReplicaConnection(INcApplicationContext appCtx) throws IOException {
        this.resolvedLocation = NetworkUtil.refresh((InetSocketAddress)this.resolvedLocation);
        this.logRepChannel = ReplicationProtocol.establishReplicaConnection(appCtx, this.resolvedLocation);
    }

    private synchronized void closeLogReplicationChannel() {
        try {
            if (this.logRepChannel != null && this.logRepChannel.getSocketChannel().isOpen()) {
                ReplicationProtocol.sendGoodbye(this.logRepChannel);
                this.logRepChannel.close();
                this.logRepChannel = null;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Exception while closing socket", (Throwable)e);
        }
    }

    public InetSocketAddress getLocation() {
        return this.resolvedLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationDestination that = (ReplicationDestination)o;
        return Objects.equals(this.inputLocation, that.inputLocation);
    }

    public String toString() {
        return this.resolvedLocation.toString();
    }

    public int hashCode() {
        return Objects.hash(this.inputLocation);
    }
}

