/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.sockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.ipc.sockets.SslHandshake;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.hyracks.util.StorageUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SslSocketChannel
implements ISocketChannel {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_APP_BUFFER_SIZE = StorageUtil.getIntSizeInBytes((int)1, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE);
    private final SocketChannel socketChannel;
    private final SSLEngine engine;
    private ByteBuffer outEncryptedData;
    private ByteBuffer inAppData;
    private ByteBuffer inEncryptedData;
    private boolean partialRecord = false;
    private boolean cachedData = false;
    private boolean pendingWrite = false;

    public SslSocketChannel(SocketChannel socketChannel, SSLEngine engine) {
        this.socketChannel = socketChannel;
        this.engine = engine;
        this.inAppData = ByteBuffer.allocate(DEFAULT_APP_BUFFER_SIZE);
        this.inAppData.limit(0);
        SSLSession sslSession = engine.getSession();
        this.inEncryptedData = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.outEncryptedData = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.outEncryptedData.limit(0);
    }

    public synchronized boolean handshake() {
        try {
            LOGGER.debug("starting SSL handshake {}", (Object)this);
            this.engine.beginHandshake();
            SslHandshake sslHandshake = new SslHandshake(this);
            boolean success = sslHandshake.handshake();
            if (success) {
                LOGGER.debug("SSL handshake successful {}", (Object)this);
            }
            return success;
        }
        catch (Exception e) {
            LOGGER.error("handshake failed {}", (Object)this, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public boolean requiresHandshake() {
        return true;
    }

    public synchronized int read(ByteBuffer buffer) throws IOException {
        int transfereeBytes = 0;
        if (this.cachedData) {
            transfereeBytes += SslSocketChannel.transferTo(this.inAppData, buffer);
        }
        if (buffer.hasRemaining()) {
            int bytesRead;
            if (!this.partialRecord) {
                this.inEncryptedData.clear();
            }
            if ((bytesRead = this.socketChannel.read(this.inEncryptedData)) > 0) {
                this.partialRecord = false;
                this.inEncryptedData.flip();
                this.inAppData.clear();
                if (this.decrypt() > 0) {
                    this.inAppData.flip();
                    transfereeBytes += SslSocketChannel.transferTo(this.inAppData, buffer);
                } else {
                    this.inAppData.limit(0);
                }
            } else if (bytesRead < 0) {
                this.handleEndOfStreamQuietly();
                return -1;
            }
        }
        this.cachedData = this.inAppData.hasRemaining();
        return transfereeBytes;
    }

    private int decrypt() throws IOException {
        int decryptedBytes = 0;
        block6: while (this.inEncryptedData.hasRemaining() && !this.partialRecord) {
            SSLEngineResult result = this.engine.unwrap(this.inEncryptedData, this.inAppData);
            switch (result.getStatus()) {
                case OK: {
                    decryptedBytes += result.bytesProduced();
                    this.partialRecord = false;
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    this.inAppData = NetworkUtil.enlargeSslApplicationBuffer((SSLEngine)this.engine, (ByteBuffer)this.inAppData);
                    continue block6;
                }
                case BUFFER_UNDERFLOW: {
                    this.handleReadUnderflow();
                    continue block6;
                }
                case CLOSED: {
                    this.close();
                    return -1;
                }
            }
            throw new IllegalStateException("Invalid SSL result status: " + result.getStatus());
        }
        return decryptedBytes;
    }

    public synchronized int write(ByteBuffer src) throws IOException {
        if (this.pendingWrite && !this.completeWrite()) {
            return 0;
        }
        int encryptedBytes = 0;
        block5: while (src.hasRemaining()) {
            this.outEncryptedData.clear();
            if (!this.socketChannel.isConnected()) {
                throw new ClosedChannelException();
            }
            SSLEngineResult result = this.engine.wrap(src, this.outEncryptedData);
            switch (result.getStatus()) {
                case OK: {
                    this.outEncryptedData.flip();
                    encryptedBytes += result.bytesConsumed();
                    while (this.outEncryptedData.hasRemaining()) {
                        int written = this.socketChannel.write(this.outEncryptedData);
                        if (written != 0) continue;
                        this.pendingWrite = true;
                        return encryptedBytes;
                    }
                    continue block5;
                }
                case BUFFER_OVERFLOW: {
                    this.outEncryptedData = NetworkUtil.enlargeSslPacketBuffer((SSLEngine)this.engine, (ByteBuffer)this.outEncryptedData);
                    continue block5;
                }
                case CLOSED: {
                    this.close();
                    return -1;
                }
            }
            throw new IllegalStateException("Invalid SSL result status: " + result.getStatus());
        }
        this.pendingWrite = false;
        return encryptedBytes;
    }

    public synchronized boolean completeWrite() throws IOException {
        while (this.outEncryptedData.hasRemaining()) {
            int written = this.socketChannel.write(this.outEncryptedData);
            if (written != 0) continue;
            return false;
        }
        this.pendingWrite = false;
        return true;
    }

    public synchronized void close() throws IOException {
        if (this.socketChannel.isOpen()) {
            this.engine.closeOutbound();
            try {
                new SslHandshake(this).handshake();
            }
            finally {
                this.socketChannel.close();
            }
        }
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public synchronized boolean isPendingRead() {
        return this.cachedData;
    }

    public synchronized boolean isPendingWrite() {
        return this.pendingWrite;
    }

    public SSLEngine getSslEngine() {
        return this.engine;
    }

    public String toString() {
        return this.getConnectionInfo();
    }

    private void handleReadUnderflow() {
        if (this.engine.getSession().getPacketBufferSize() > this.inEncryptedData.capacity()) {
            this.inEncryptedData = NetworkUtil.enlargeSslPacketBuffer((SSLEngine)this.engine, (ByteBuffer)this.inEncryptedData);
        } else {
            this.inEncryptedData.compact();
        }
        this.partialRecord = true;
    }

    private void handleEndOfStreamQuietly() {
        try {
            try {
                this.engine.closeInbound();
            }
            finally {
                this.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to close socket gracefully", (Throwable)e);
        }
    }

    private String getConnectionInfo() {
        try {
            return this.getSocketChannel().getLocalAddress() + " -> " + this.getSocketChannel().getRemoteAddress();
        }
        catch (IOException e) {
            LOGGER.warn("failed to get connection info", (Throwable)e);
            return "";
        }
    }

    private static int transferTo(ByteBuffer src, ByteBuffer dst) {
        int maxTransfer = Math.min(dst.remaining(), src.remaining());
        if (maxTransfer > 0) {
            dst.put(src.array(), src.arrayOffset() + src.position(), maxTransfer);
            src.position(src.position() + maxTransfer);
        }
        return maxTransfer;
    }
}

