/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;

public class MetadataCache {
    protected final Map<DataverseName, Dataverse> dataverses = new HashMap<DataverseName, Dataverse>();
    protected final Map<DataverseName, Map<String, Dataset>> datasets = new HashMap<DataverseName, Map<String, Dataset>>();
    protected final Map<DataverseName, Map<String, Map<String, Index>>> indexes = new HashMap<DataverseName, Map<String, Map<String, Index>>>();
    protected final Map<DataverseName, Map<String, Datatype>> datatypes = new HashMap<DataverseName, Map<String, Datatype>>();
    protected final Map<String, NodeGroup> nodeGroups = new HashMap<String, NodeGroup>();
    protected final Map<FunctionSignature, Function> functions = new HashMap<FunctionSignature, Function>();
    protected final Map<DataverseName, Map<String, DatasourceAdapter>> adapters = new HashMap<DataverseName, Map<String, DatasourceAdapter>>();
    protected final Map<DataverseName, Map<String, FeedPolicyEntity>> feedPolicies = new HashMap<DataverseName, Map<String, FeedPolicyEntity>>();
    protected final Map<DataverseName, Map<String, Library>> libraries = new HashMap<DataverseName, Map<String, Library>>();
    protected final Map<DataverseName, Map<String, Feed>> feeds = new HashMap<DataverseName, Map<String, Feed>>();
    protected final Map<DataverseName, Map<String, CompactionPolicy>> compactionPolicies = new HashMap<DataverseName, Map<String, CompactionPolicy>>();
    protected final Map<DataverseName, Map<String, FeedConnection>> feedConnections = new HashMap<DataverseName, Map<String, FeedConnection>>();
    protected final Map<DataverseName, Map<String, Synonym>> synonyms = new HashMap<DataverseName, Map<String, Synonym>>();
    protected final Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> fullTextFilters = new HashMap<DataverseName, Map<String, FullTextFilterMetadataEntity>>();
    protected final Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> fullTextConfigs = new HashMap<DataverseName, Map<String, FullTextConfigMetadataEntity>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(MetadataTransactionContext ctx) {
        int logIx = 0;
        List<MetadataLogicalOperation> opLog = ctx.getOpLog();
        try {
            for (logIx = 0; logIx < opLog.size(); ++logIx) {
                this.doOperation(opLog.get(logIx));
            }
        }
        catch (Exception e) {
            try {
                for (int i = logIx - 1; i >= 0; --i) {
                    this.undoOperation(opLog.get(i));
                }
            }
            catch (Exception e2) {
                this.clear();
            }
        }
        finally {
            ctx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<DataverseName, Dataverse> map = this.dataverses;
        synchronized (map) {
            Map<String, NodeGroup> map2 = this.nodeGroups;
            synchronized (map2) {
                Map<DataverseName, Map<String, Dataset>> map3 = this.datasets;
                synchronized (map3) {
                    Map<DataverseName, Map<String, Map<String, Index>>> map4 = this.indexes;
                    synchronized (map4) {
                        Map<DataverseName, Map<String, Datatype>> map5 = this.datatypes;
                        synchronized (map5) {
                            Map<FunctionSignature, Function> map6 = this.functions;
                            synchronized (map6) {
                                Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> map7 = this.fullTextConfigs;
                                synchronized (map7) {
                                    Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> map8 = this.fullTextFilters;
                                    synchronized (map8) {
                                        Map<DataverseName, Map<String, DatasourceAdapter>> map9 = this.adapters;
                                        synchronized (map9) {
                                            Map<DataverseName, Map<String, Library>> map10 = this.libraries;
                                            synchronized (map10) {
                                                Map<DataverseName, Map<String, CompactionPolicy>> map11 = this.compactionPolicies;
                                                synchronized (map11) {
                                                    Map<DataverseName, Map<String, Synonym>> map12 = this.synonyms;
                                                    synchronized (map12) {
                                                        this.dataverses.clear();
                                                        this.nodeGroups.clear();
                                                        this.datasets.clear();
                                                        this.indexes.clear();
                                                        this.datatypes.clear();
                                                        this.functions.clear();
                                                        this.fullTextConfigs.clear();
                                                        this.fullTextFilters.clear();
                                                        this.adapters.clear();
                                                        this.libraries.clear();
                                                        this.compactionPolicies.clear();
                                                        this.synonyms.clear();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse addDataverseIfNotExists(Dataverse dataverse) {
        Map<DataverseName, Dataverse> map = this.dataverses;
        synchronized (map) {
            Map<DataverseName, Map<String, Dataset>> map2 = this.datasets;
            synchronized (map2) {
                Map<DataverseName, Map<String, Datatype>> map3 = this.datatypes;
                synchronized (map3) {
                    DataverseName dataverseName = dataverse.getDataverseName();
                    if (!this.dataverses.containsKey(dataverseName)) {
                        this.datasets.put(dataverseName, new HashMap());
                        this.datatypes.put(dataverseName, new HashMap());
                        this.adapters.put(dataverseName, new HashMap());
                        return this.dataverses.put(dataverseName, dataverse);
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset addDatasetIfNotExists(Dataset dataset) {
        Map<DataverseName, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<DataverseName, Map<String, Map<String, Index>>> map2 = this.indexes;
            synchronized (map2) {
                Map<String, Dataset> m;
                if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                    Index index = IndexUtil.getPrimaryIndex(dataset);
                    this.addIndexIfNotExistsInternal(index);
                }
                if ((m = this.datasets.get(dataset.getDataverseName())) == null) {
                    m = new HashMap<String, Dataset>();
                    this.datasets.put(dataset.getDataverseName(), m);
                }
                if (!m.containsKey(dataset.getDatasetName())) {
                    return m.put(dataset.getDatasetName(), dataset);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index addIndexIfNotExists(Index index) {
        Map<DataverseName, Map<String, Map<String, Index>>> map = this.indexes;
        synchronized (map) {
            return this.addIndexIfNotExistsInternal(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype addDatatypeIfNotExists(Datatype datatype) {
        Map<DataverseName, Map<String, Datatype>> map = this.datatypes;
        synchronized (map) {
            Map<String, Datatype> m = this.datatypes.get(datatype.getDataverseName());
            if (m == null) {
                m = new HashMap<String, Datatype>();
                this.datatypes.put(datatype.getDataverseName(), m);
            }
            if (!m.containsKey(datatype.getDatatypeName())) {
                return m.put(datatype.getDatatypeName(), datatype);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup addOrUpdateNodeGroup(NodeGroup nodeGroup) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.put(nodeGroup.getNodeGroupName(), nodeGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionPolicy addCompactionPolicyIfNotExists(CompactionPolicy compactionPolicy) {
        Map<DataverseName, Map<String, CompactionPolicy>> map = this.compactionPolicies;
        synchronized (map) {
            Map<String, CompactionPolicy> p = this.compactionPolicies.get(compactionPolicy.getDataverseName());
            if (p == null) {
                p = new HashMap<String, CompactionPolicy>();
                p.put(compactionPolicy.getPolicyName(), compactionPolicy);
                this.compactionPolicies.put(compactionPolicy.getDataverseName(), p);
            } else if (p.get(compactionPolicy.getPolicyName()) == null) {
                p.put(compactionPolicy.getPolicyName(), compactionPolicy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionPolicy dropCompactionPolicy(CompactionPolicy compactionPolicy) {
        Map<DataverseName, Map<String, CompactionPolicy>> map = this.compactionPolicies;
        synchronized (map) {
            Map<String, CompactionPolicy> p = this.compactionPolicies.get(compactionPolicy.getDataverseName());
            if (p != null && p.get(compactionPolicy.getPolicyName()) != null) {
                return p.remove(compactionPolicy.getPolicyName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse dropDataverse(Dataverse dataverse) {
        Map<DataverseName, Dataverse> map = this.dataverses;
        synchronized (map) {
            Map<DataverseName, Map<String, Dataset>> map2 = this.datasets;
            synchronized (map2) {
                Map<DataverseName, Map<String, Map<String, Index>>> map3 = this.indexes;
                synchronized (map3) {
                    Map<DataverseName, Map<String, Datatype>> map4 = this.datatypes;
                    synchronized (map4) {
                        Map<FunctionSignature, Function> map5 = this.functions;
                        synchronized (map5) {
                            Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> map6 = this.fullTextConfigs;
                            synchronized (map6) {
                                Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> map7 = this.fullTextFilters;
                                synchronized (map7) {
                                    Map<DataverseName, Map<String, DatasourceAdapter>> map8 = this.adapters;
                                    synchronized (map8) {
                                        Map<DataverseName, Map<String, Library>> map9 = this.libraries;
                                        synchronized (map9) {
                                            Map<DataverseName, Map<String, Feed>> map10 = this.feeds;
                                            synchronized (map10) {
                                                Map<DataverseName, Map<String, CompactionPolicy>> map11 = this.compactionPolicies;
                                                synchronized (map11) {
                                                    Map<DataverseName, Map<String, Synonym>> map12 = this.synonyms;
                                                    synchronized (map12) {
                                                        this.datasets.remove(dataverse.getDataverseName());
                                                        this.indexes.remove(dataverse.getDataverseName());
                                                        this.datatypes.remove(dataverse.getDataverseName());
                                                        this.adapters.remove(dataverse.getDataverseName());
                                                        this.compactionPolicies.remove(dataverse.getDataverseName());
                                                        ArrayList<FunctionSignature> markedFunctionsForRemoval = new ArrayList<FunctionSignature>();
                                                        for (FunctionSignature signature : this.functions.keySet()) {
                                                            if (!signature.getDataverseName().equals((Object)dataverse.getDataverseName())) continue;
                                                            markedFunctionsForRemoval.add(signature);
                                                        }
                                                        for (FunctionSignature signature : markedFunctionsForRemoval) {
                                                            this.functions.remove(signature);
                                                        }
                                                        this.fullTextConfigs.remove(dataverse.getDataverseName());
                                                        this.fullTextFilters.remove(dataverse.getDataverseName());
                                                        this.libraries.remove(dataverse.getDataverseName());
                                                        this.feeds.remove(dataverse.getDataverseName());
                                                        this.synonyms.remove(dataverse.getDataverseName());
                                                        return this.dataverses.remove(dataverse.getDataverseName());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset dropDataset(Dataset dataset) {
        Map<DataverseName, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<DataverseName, Map<String, Map<String, Index>>> map2 = this.indexes;
            synchronized (map2) {
                Map<String, Dataset> m;
                Map<String, Map<String, Index>> datasetMap = this.indexes.get(dataset.getDataverseName());
                if (datasetMap != null) {
                    datasetMap.remove(dataset.getDatasetName());
                }
                if ((m = this.datasets.get(dataset.getDataverseName())) == null) {
                    return null;
                }
                return m.remove(dataset.getDatasetName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index dropIndex(Index index) {
        Map<DataverseName, Map<String, Map<String, Index>>> map = this.indexes;
        synchronized (map) {
            Map<String, Map<String, Index>> datasetMap = this.indexes.get(index.getDataverseName());
            if (datasetMap == null) {
                return null;
            }
            Map<String, Index> indexMap = datasetMap.get(index.getDatasetName());
            if (indexMap == null) {
                return null;
            }
            return indexMap.remove(index.getIndexName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype dropDatatype(Datatype datatype) {
        Map<DataverseName, Map<String, Datatype>> map = this.datatypes;
        synchronized (map) {
            Map<String, Datatype> m = this.datatypes.get(datatype.getDataverseName());
            if (m == null) {
                return null;
            }
            return m.remove(datatype.getDatatypeName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup dropNodeGroup(NodeGroup nodeGroup) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.remove(nodeGroup.getNodeGroupName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse getDataverse(DataverseName dataverseName) {
        Map<DataverseName, Dataverse> map = this.dataverses;
        synchronized (map) {
            return this.dataverses.get(dataverseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset getDataset(DataverseName dataverseName, String datasetName) {
        Map<DataverseName, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Dataset> m = this.datasets.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(datasetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getIndex(DataverseName dataverseName, String datasetName, String indexName) {
        Map<DataverseName, Map<String, Map<String, Index>>> map = this.indexes;
        synchronized (map) {
            Map<String, Map<String, Index>> datasetMap = this.indexes.get(dataverseName);
            if (datasetMap == null) {
                return null;
            }
            Map<String, Index> indexMap = datasetMap.get(datasetName);
            if (indexMap == null) {
                return null;
            }
            return indexMap.get(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype getDatatype(DataverseName dataverseName, String datatypeName) {
        Map<DataverseName, Map<String, Datatype>> map = this.datatypes;
        synchronized (map) {
            Map<String, Datatype> m = this.datatypes.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(datatypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup getNodeGroup(String nodeGroupName) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.get(nodeGroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(FunctionSignature functionSignature) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            return this.functions.get(functionSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextConfigMetadataEntity getFullTextConfig(DataverseName dataverseName, String configName) {
        Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> map = this.fullTextConfigs;
        synchronized (map) {
            Map<String, FullTextConfigMetadataEntity> m = this.fullTextConfigs.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextFilterMetadataEntity getFullTextFilter(DataverseName dataverseName, String filterName) {
        Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> map = this.fullTextFilters;
        synchronized (map) {
            Map<String, FullTextFilterMetadataEntity> m = this.fullTextFilters.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> getDataverseDatasets(DataverseName dataverseName) {
        Map<DataverseName, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Dataset> m = this.datasets.get(dataverseName);
            if (m == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Dataset>(m.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> getDatasetIndexes(DataverseName dataverseName, String datasetName) {
        Map<DataverseName, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Index> map2 = this.indexes.get(dataverseName).get(datasetName);
            if (map2 == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Index>(map2.values());
        }
    }

    protected void doOperation(MetadataLogicalOperation op) {
        if (op.isAdd) {
            op.entity.addToCache(this);
        } else {
            op.entity.dropFromCache(this);
        }
    }

    protected void undoOperation(MetadataLogicalOperation op) {
        if (!op.isAdd) {
            op.entity.addToCache(this);
        } else {
            op.entity.dropFromCache(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function addFunctionIfNotExists(Function function) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            FunctionSignature signature = new FunctionSignature(function.getDataverseName(), function.getName(), function.getArity());
            Function fun = this.functions.get(signature);
            if (fun == null) {
                return this.functions.put(signature, function);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function dropFunction(Function function) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            FunctionSignature signature = new FunctionSignature(function.getDataverseName(), function.getName(), function.getArity());
            Function fun = this.functions.get(signature);
            if (fun == null) {
                return null;
            }
            return this.functions.remove(signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextFilterMetadataEntity addFullTextFilterIfNotExists(FullTextFilterMetadataEntity filter) {
        DataverseName dataverseName = filter.getFullTextFilter().getDataverseName();
        String filterName = filter.getFullTextFilter().getName();
        Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> map = this.fullTextFilters;
        synchronized (map) {
            Map<String, FullTextFilterMetadataEntity> m = this.fullTextFilters.get(dataverseName);
            if (m == null) {
                m = new HashMap<String, FullTextFilterMetadataEntity>();
                this.fullTextFilters.put(dataverseName, m);
            }
            if (!m.containsKey(filterName)) {
                return m.put(filterName, filter);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextFilterMetadataEntity dropFullTextFilter(FullTextFilterMetadataEntity filterMetadataEntity) {
        DataverseName dataverseName = filterMetadataEntity.getFullTextFilter().getDataverseName();
        String filterName = filterMetadataEntity.getFullTextFilter().getName();
        Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> map = this.fullTextFilters;
        synchronized (map) {
            Map<String, FullTextFilterMetadataEntity> m = this.fullTextFilters.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.remove(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextConfigMetadataEntity addFullTextConfigIfNotExists(FullTextConfigMetadataEntity configMetadataEntity) {
        FullTextConfigDescriptor config = configMetadataEntity.getFullTextConfig();
        DataverseName dataverseName = config.getDataverseName();
        String configName = config.getName();
        Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> map = this.fullTextConfigs;
        synchronized (map) {
            Map<String, FullTextConfigMetadataEntity> m = this.fullTextConfigs.get(dataverseName);
            if (m == null) {
                m = new HashMap<String, FullTextConfigMetadataEntity>();
                this.fullTextConfigs.put(dataverseName, m);
            }
            if (!m.containsKey(configName)) {
                return m.put(configName, configMetadataEntity);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextConfigMetadataEntity dropFullTextConfig(FullTextConfigMetadataEntity configMetadataEntity) {
        FullTextConfigDescriptor config = configMetadataEntity.getFullTextConfig();
        DataverseName dataverseName = config.getDataverseName();
        String configName = config.getName();
        Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> map = this.fullTextConfigs;
        synchronized (map) {
            Map<String, FullTextConfigMetadataEntity> m = this.fullTextConfigs.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.remove(configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addFeedPolicyIfNotExists(FeedPolicyEntity feedPolicy) {
        Map<DataverseName, Map<String, FeedPolicyEntity>> map = this.feedPolicies;
        synchronized (map) {
            Map<String, FeedPolicyEntity> p = this.feedPolicies.get(feedPolicy.getDataverseName());
            if (p == null) {
                p = new HashMap<String, FeedPolicyEntity>();
                p.put(feedPolicy.getPolicyName(), feedPolicy);
                this.feedPolicies.put(feedPolicy.getDataverseName(), p);
            } else if (p.get(feedPolicy.getPolicyName()) == null) {
                p.put(feedPolicy.getPolicyName(), feedPolicy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropFeedPolicy(FeedPolicyEntity feedPolicy) {
        Map<DataverseName, Map<String, FeedPolicyEntity>> map = this.feedPolicies;
        synchronized (map) {
            Map<String, FeedPolicyEntity> p = this.feedPolicies.get(feedPolicy.getDataverseName());
            if (p != null && p.get(feedPolicy.getPolicyName()) != null) {
                return p.remove(feedPolicy.getPolicyName()).getPolicyName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasourceAdapter addAdapterIfNotExists(DatasourceAdapter adapter) {
        Map<DataverseName, Map<String, DatasourceAdapter>> map = this.adapters;
        synchronized (map) {
            DatasourceAdapter adapterObject;
            Map<String, DatasourceAdapter> adaptersInDataverse = this.adapters.get(adapter.getAdapterIdentifier().getDataverseName());
            if (adaptersInDataverse == null) {
                adaptersInDataverse = new HashMap<String, DatasourceAdapter>();
                this.adapters.put(adapter.getAdapterIdentifier().getDataverseName(), adaptersInDataverse);
            }
            if ((adapterObject = adaptersInDataverse.get(adapter.getAdapterIdentifier().getName())) == null) {
                return adaptersInDataverse.put(adapter.getAdapterIdentifier().getName(), adapter);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasourceAdapter dropAdapterIfExists(DatasourceAdapter adapter) {
        Map<DataverseName, Map<String, DatasourceAdapter>> map = this.adapters;
        synchronized (map) {
            Map<String, DatasourceAdapter> adaptersInDataverse = this.adapters.get(adapter.getAdapterIdentifier().getDataverseName());
            if (adaptersInDataverse != null) {
                return adaptersInDataverse.remove(adapter.getAdapterIdentifier().getName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library addLibraryIfNotExists(Library library) {
        Map<DataverseName, Map<String, Library>> map = this.libraries;
        synchronized (map) {
            boolean needToAdd;
            Map<String, Library> libsInDataverse = this.libraries.get(library.getDataverseName());
            boolean bl = needToAdd = libsInDataverse == null || libsInDataverse.get(library.getName()) != null;
            if (needToAdd) {
                if (libsInDataverse == null) {
                    libsInDataverse = new HashMap<String, Library>();
                    this.libraries.put(library.getDataverseName(), libsInDataverse);
                }
                return libsInDataverse.put(library.getName(), library);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library dropLibrary(Library library) {
        Map<DataverseName, Map<String, Library>> map = this.libraries;
        synchronized (map) {
            Map<String, Library> librariesInDataverse = this.libraries.get(library.getDataverseName());
            if (librariesInDataverse != null) {
                return librariesInDataverse.remove(library.getName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedConnection addFeedConnectionIfNotExists(FeedConnection feedConnection) {
        Map<DataverseName, Map<String, FeedConnection>> map = this.feedConnections;
        synchronized (map) {
            Map<String, FeedConnection> feedConnsInDataverse = this.feedConnections.get(feedConnection.getDataverseName());
            if (feedConnsInDataverse == null) {
                feedConnsInDataverse = new HashMap<String, FeedConnection>();
                this.feedConnections.put(feedConnection.getDataverseName(), feedConnsInDataverse);
            }
            return feedConnsInDataverse.put(feedConnection.getConnectionId(), feedConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedConnection dropFeedConnection(FeedConnection feedConnection) {
        Map<DataverseName, Map<String, FeedConnection>> map = this.feedConnections;
        synchronized (map) {
            Map<String, FeedConnection> feedConnsInDataverse = this.feedConnections.get(feedConnection.getDataverseName());
            if (feedConnsInDataverse != null) {
                return feedConnsInDataverse.remove(feedConnection.getConnectionId());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed addFeedIfNotExists(Feed feed) {
        Map<DataverseName, Map<String, Feed>> map = this.feeds;
        synchronized (map) {
            Map<String, Feed> feedsInDataverse = this.feeds.get(feed.getDataverseName());
            if (feedsInDataverse == null) {
                feedsInDataverse = new HashMap<String, Feed>();
                this.feeds.put(feed.getDataverseName(), feedsInDataverse);
            }
            return feedsInDataverse.put(feed.getFeedName(), feed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed dropFeedIfExists(Feed feed) {
        Map<DataverseName, Map<String, Feed>> map = this.feeds;
        synchronized (map) {
            Map<String, Feed> feedsInDataverse = this.feeds.get(feed.getDataverseName());
            if (feedsInDataverse != null) {
                return feedsInDataverse.remove(feed.getFeedName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synonym addSynonymIfNotExists(Synonym synonym) {
        Map<DataverseName, Map<String, Synonym>> map = this.synonyms;
        synchronized (map) {
            Map<String, Synonym> synonymsInDataverse = this.synonyms.get(synonym.getDataverseName());
            if (synonymsInDataverse == null) {
                synonymsInDataverse = new HashMap<String, Synonym>();
                this.synonyms.put(synonym.getDataverseName(), synonymsInDataverse);
            }
            return synonymsInDataverse.put(synonym.getSynonymName(), synonym);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synonym dropSynonym(Synonym synonym) {
        Map<DataverseName, Map<String, Synonym>> map = this.synonyms;
        synchronized (map) {
            Map<String, Synonym> synonymsInDataverse = this.synonyms.get(synonym.getDataverseName());
            if (synonymsInDataverse != null) {
                return synonymsInDataverse.remove(synonym.getSynonymName());
            }
            return null;
        }
    }

    private Index addIndexIfNotExistsInternal(Index index) {
        Map<String, Index> indexMap;
        Map<String, Map<String, Index>> datasetMap = this.indexes.get(index.getDataverseName());
        if (datasetMap == null) {
            datasetMap = new HashMap<String, Map<String, Index>>();
            this.indexes.put(index.getDataverseName(), datasetMap);
        }
        if ((indexMap = datasetMap.get(index.getDatasetName())) == null) {
            indexMap = new HashMap<String, Index>();
            datasetMap.put(index.getDatasetName(), indexMap);
        }
        if (!indexMap.containsKey(index.getIndexName())) {
            return indexMap.put(index.getIndexName(), index);
        }
        return null;
    }

    protected static class MetadataLogicalOperation {
        public final IMetadataEntity<?> entity;
        public final boolean isAdd;

        public MetadataLogicalOperation(IMetadataEntity<?> entity, boolean isAdd) {
            this.entity = entity;
            this.isAdd = isAdd;
        }
    }
}

