/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.cloud.storage.GrpcToHttpStatusCodeTranslation;
import com.google.cloud.storage.Utils;
import com.google.common.collect.ImmutableSet;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
public final class StorageException
extends BaseHttpServiceException {
    private static final String INTERNAL_ERROR = "internalError";
    private static final String CONNECTION_CLOSED_PREMATURELY = "connectionClosedPrematurely";
    static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(504), null), (Object)new BaseServiceException.Error(Integer.valueOf(503), null), (Object)new BaseServiceException.Error(Integer.valueOf(502), null), (Object)new BaseServiceException.Error(Integer.valueOf(500), null), (Object)new BaseServiceException.Error(Integer.valueOf(429), null), (Object)new BaseServiceException.Error(Integer.valueOf(408), null), (Object[])new BaseServiceException.Error[]{new BaseServiceException.Error(null, "internalError"), new BaseServiceException.Error(null, "connectionClosedPrematurely")});
    private static final long serialVersionUID = 757915549325467990L;
    final ApiException apiExceptionCause;

    public StorageException(int code, String message) {
        this(code, message, null);
    }

    public StorageException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
        this.apiExceptionCause = StorageException.asApiExceptionOrNull(cause);
    }

    public StorageException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, RETRYABLE_ERRORS, cause);
        this.apiExceptionCause = StorageException.asApiExceptionOrNull(cause);
    }

    public StorageException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
        this.apiExceptionCause = null;
    }

    public StorageException(GoogleJsonError error) {
        super(error, true, RETRYABLE_ERRORS);
        this.apiExceptionCause = null;
    }

    public static StorageException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate((RetryHelper.RetryHelperException)ex);
        throw StorageException.getStorageException(ex);
    }

    private static StorageException getStorageException(Throwable t) {
        if (t instanceof RetryHelper.RetryHelperException) {
            return new StorageException(0, t.getMessage(), t.getCause());
        }
        return new StorageException(0, t.getMessage(), t);
    }

    static BaseServiceException coalesce(Throwable t) {
        if (t instanceof BaseServiceException) {
            return (BaseServiceException)t;
        }
        if (t.getCause() instanceof BaseServiceException) {
            return (BaseServiceException)t.getCause();
        }
        if (t instanceof ApiException) {
            return StorageException.asStorageException((ApiException)t);
        }
        return StorageException.getStorageException(t);
    }

    static StorageException asStorageException(ApiException apiEx) {
        int httpStatusCode = 0;
        StatusCode statusCode = apiEx.getStatusCode();
        if (statusCode instanceof GrpcStatusCode) {
            GrpcStatusCode gsc = (GrpcStatusCode)statusCode;
            httpStatusCode = GrpcToHttpStatusCodeTranslation.grpcCodeToHttpStatusCode(gsc.getTransportCode());
        }
        String message = (String)Utils.firstNonNull(() -> StorageException.getStatusExceptionMessage(apiEx), () -> String.format("Error: %s", statusCode.getCode().name()));
        return new StorageException(httpStatusCode, message, apiEx.getReason(), (Throwable)apiEx);
    }

    public static StorageException translate(IOException exception) {
        String message = exception.getMessage();
        if (message != null && (message.contains("Connection closed prematurely") || message.contains("Premature EOF"))) {
            return new StorageException(0, message, CONNECTION_CLOSED_PREMATURELY, exception);
        }
        return new StorageException(exception);
    }

    static <T> T wrapIOException(IOExceptionCallable<T> c) {
        try {
            return c.call();
        }
        catch (IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    static void wrapIOException(IOExceptionRunnable r) {
        try {
            r.run();
        }
        catch (IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    static <T> T wrapFutureGet(ApiFuture<T> f) {
        try {
            return (T)ApiExceptions.callAndTranslateApiException(f);
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    private static @Nullable String getStatusExceptionMessage(ApiException apiEx) {
        Throwable cause = apiEx.getCause();
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            return cause.getMessage();
        }
        return null;
    }

    private static @Nullable ApiException asApiExceptionOrNull(Throwable cause) {
        if (cause instanceof ApiException) {
            return (ApiException)cause;
        }
        return null;
    }

    @FunctionalInterface
    static interface IOExceptionCallable<T> {
        public T call() throws IOException;
    }

    @FunctionalInterface
    static interface IOExceptionRunnable {
        public void run() throws IOException;
    }
}

