/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.azure.blob;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.input.record.reader.azure.blob.AzureBlobInputStreamFactory;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReaderFactory;
import org.apache.asterix.external.provider.StreamRecordReaderProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class AzureBlobReaderFactory
extends StreamRecordReaderFactory {
    private static final long serialVersionUID = 1L;
    private static final List<String> recordReaderNames = Collections.singletonList("AZUREBLOB");

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public Class<?> getRecordClass() {
        return char[].class;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        return this.streamFactory.getPartitionConstraint();
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException, HyracksDataException {
        this.configuration = configuration;
        this.streamFactory = new AzureBlobInputStreamFactory();
        this.streamFactory.configure(ctx, configuration, warningCollector);
        this.recordReaderClazz = StreamRecordReaderProvider.getRecordReaderClazz(configuration);
    }
}

