/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.IVisitorExtension;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.CopyToStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateWithConditionClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class FreeVariableVisitor
extends AbstractSqlppQueryExpressionVisitor<Void, Collection<VariableExpr>> {
    @Override
    public Void visit(FromClause fromClause, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> bindingVars = new HashSet<VariableExpr>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            HashSet fromTermFreeVars = new HashSet();
            fromTerm.accept(this, fromTermFreeVars);
            fromTermFreeVars.removeAll(bindingVars);
            bindingVars.addAll(SqlppVariableUtil.getBindingVariables((ILangExpression)fromTerm));
            freeVars.addAll(fromTermFreeVars);
        }
        return null;
    }

    @Override
    public Void visit(FromTerm fromTerm, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> bindingVariables = new HashSet<VariableExpr>();
        fromTerm.getLeftExpression().accept((ILangVisitor)this, freeVars);
        bindingVariables.add(fromTerm.getLeftVariable());
        if (fromTerm.hasPositionalVariable()) {
            bindingVariables.add(fromTerm.getPositionalVariable());
        }
        HashSet clauseFreeVars = null;
        HashSet conditionFreeVars = null;
        for (AbstractBinaryCorrelateClause clause : fromTerm.getCorrelateClauses()) {
            if (clauseFreeVars == null) {
                clauseFreeVars = new HashSet();
            } else {
                clauseFreeVars.clear();
            }
            clause.getRightExpression().accept((ILangVisitor)this, clauseFreeVars);
            switch (clause.getClauseType()) {
                case UNNEST_CLAUSE: {
                    clauseFreeVars.removeAll(bindingVariables);
                    break;
                }
                case JOIN_CLAUSE: 
                case NEST_CLAUSE: {
                    if (conditionFreeVars == null) {
                        conditionFreeVars = new HashSet();
                    } else {
                        conditionFreeVars.clear();
                    }
                    AbstractBinaryCorrelateWithConditionClause clauseWithCondition = (AbstractBinaryCorrelateWithConditionClause)clause;
                    clauseWithCondition.getConditionExpression().accept((ILangVisitor)this, conditionFreeVars);
                    conditionFreeVars.removeAll(bindingVariables);
                    conditionFreeVars.remove(clause.getRightVariable());
                    if (clause.hasPositionalVariable()) {
                        conditionFreeVars.remove(clause.getPositionalVariable());
                    }
                    clauseFreeVars.addAll(conditionFreeVars);
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, clause.getSourceLocation(), new Serializable[]{clause.getClauseType().toString()});
                }
            }
            bindingVariables.add(clause.getRightVariable());
            if (clause.hasPositionalVariable()) {
                bindingVariables.add(clause.getPositionalVariable());
            }
            freeVars.addAll(clauseFreeVars);
        }
        return null;
    }

    @Override
    public Void visit(JoinClause joinClause, Collection<VariableExpr> arg) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, joinClause.getSourceLocation(), new Serializable[]{joinClause.getClauseType().toString()});
    }

    @Override
    public Void visit(NestClause nestClause, Collection<VariableExpr> arg) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, nestClause.getSourceLocation(), new Serializable[]{nestClause.getClauseType().toString()});
    }

    @Override
    public Void visit(UnnestClause unnestClause, Collection<VariableExpr> arg) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnestClause.getSourceLocation(), new Serializable[]{unnestClause.getClauseType().toString()});
    }

    @Override
    public Void visit(Projection projection, Collection<VariableExpr> freeVars) throws CompilationException {
        return projection.hasExpression() ? (Void)projection.getExpression().accept((ILangVisitor)this, freeVars) : null;
    }

    @Override
    public Void visit(SelectBlock selectBlock, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> selectFreeVars = new HashSet<VariableExpr>();
        HashSet fromFreeVars = new HashSet();
        HashSet<VariableExpr> letWheresFreeVars = new HashSet<VariableExpr>();
        HashSet gbyFreeVars = new HashSet();
        HashSet<VariableExpr> gbyLetHavingsFreeVars = new HashSet<VariableExpr>();
        List<VariableExpr> fromBindingVars = SqlppVariableUtil.getBindingVariables((ILangExpression)selectBlock.getFromClause());
        List<VariableExpr> letsBindingVars = SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetWhereList());
        List<VariableExpr> gbyBindingVars = SqlppVariableUtil.getBindingVariables((ILangExpression)selectBlock.getGroupbyClause());
        List<VariableExpr> gbyLetsBindingVars = SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetHavingListAfterGroupby());
        selectBlock.getSelectClause().accept(this, selectFreeVars);
        this.removeAllBindingVarsInSelectBlock(selectFreeVars, fromBindingVars, letsBindingVars, gbyBindingVars, gbyLetsBindingVars);
        if (selectBlock.hasFromClause()) {
            selectBlock.getFromClause().accept(this, fromFreeVars);
        }
        if (selectBlock.hasLetWhereClauses()) {
            this.visitLetWhereClauses(selectBlock.getLetWhereList(), letWheresFreeVars);
            letWheresFreeVars.removeAll(fromBindingVars);
        }
        if (selectBlock.hasGroupbyClause()) {
            selectBlock.getGroupbyClause().accept((ILangVisitor)this, gbyFreeVars);
            gbyFreeVars.removeAll(fromBindingVars);
            gbyFreeVars.removeAll(letsBindingVars);
            if (selectBlock.hasLetHavingClausesAfterGroupby()) {
                this.visitLetWhereClauses(selectBlock.getLetHavingListAfterGroupby(), gbyLetHavingsFreeVars);
                gbyLetHavingsFreeVars.removeAll(fromBindingVars);
                gbyLetHavingsFreeVars.removeAll(letsBindingVars);
                gbyLetHavingsFreeVars.removeAll(gbyBindingVars);
            }
        }
        this.removeAllBindingVarsInSelectBlock(freeVars, fromBindingVars, letsBindingVars, gbyBindingVars, gbyLetsBindingVars);
        freeVars.addAll(selectFreeVars);
        freeVars.addAll(fromFreeVars);
        freeVars.addAll(letWheresFreeVars);
        freeVars.addAll(gbyFreeVars);
        freeVars.addAll(gbyLetHavingsFreeVars);
        return null;
    }

    @Override
    public Void visit(SelectClause selectClause, Collection<VariableExpr> freeVars) throws CompilationException {
        if (selectClause.selectElement()) {
            selectClause.getSelectElement().accept(this, freeVars);
        }
        if (selectClause.selectRegular()) {
            selectClause.getSelectRegular().accept(this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(SelectElement selectElement, Collection<VariableExpr> freeVars) throws CompilationException {
        selectElement.getExpression().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(SelectRegular selectRegular, Collection<VariableExpr> freeVars) throws CompilationException {
        for (Projection projection : selectRegular.getProjections()) {
            projection.accept(this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(SelectSetOperation selectSetOperation, Collection<VariableExpr> freeVars) throws CompilationException {
        selectSetOperation.getLeftInput().accept(this, freeVars);
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            right.getSetOperationRightInput().accept(this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(HavingClause havingClause, Collection<VariableExpr> freeVars) throws CompilationException {
        havingClause.getFilterExpression().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(Query q, Collection<VariableExpr> freeVars) throws CompilationException {
        q.getBody().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(FunctionDecl fd, Collection<VariableExpr> freeVars) throws CompilationException {
        fd.getFuncBody().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(WhereClause whereClause, Collection<VariableExpr> freeVars) throws CompilationException {
        whereClause.getWhereExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(OrderbyClause oc, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visit(oc.getOrderbyList(), freeVars);
        return null;
    }

    public Void visit(GroupbyClause gc, Collection<VariableExpr> freeVars) throws CompilationException {
        for (List gbyPairList : gc.getGbyPairList()) {
            for (GbyVariableExpressionPair gbyVarExpr : gbyPairList) {
                gbyVarExpr.getExpr().accept((ILangVisitor)this, freeVars);
            }
        }
        if (gc.hasDecorList()) {
            for (GbyVariableExpressionPair decorVarExpr : gc.getDecorPairList()) {
                decorVarExpr.getExpr().accept((ILangVisitor)this, freeVars);
            }
        }
        if (gc.hasGroupFieldList()) {
            for (Pair groupField : gc.getGroupFieldList()) {
                ((Expression)groupField.first).accept((ILangVisitor)this, freeVars);
            }
        }
        if (gc.hasWithMap()) {
            for (Expression expr : gc.getWithVarMap().keySet()) {
                expr.accept((ILangVisitor)this, freeVars);
            }
        }
        return null;
    }

    public Void visit(LimitClause limitClause, Collection<VariableExpr> freeVars) throws CompilationException {
        if (limitClause.hasLimitExpr()) {
            limitClause.getLimitExpr().accept((ILangVisitor)this, freeVars);
        }
        if (limitClause.hasOffset()) {
            limitClause.getOffset().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(LetClause letClause, Collection<VariableExpr> freeVars) throws CompilationException {
        letClause.getBindingExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(SelectExpression selectExpression, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> letsFreeVars = new HashSet<VariableExpr>();
        HashSet selectFreeVars = new HashSet();
        this.visitLetWhereClauses(selectExpression.getLetList(), letsFreeVars);
        if (selectExpression.hasOrderby()) {
            for (Expression orderExpr : selectExpression.getOrderbyClause().getOrderbyList()) {
                orderExpr.accept((ILangVisitor)this, selectFreeVars);
            }
        }
        if (selectExpression.hasLimit()) {
            selectExpression.getLimitClause().accept((ILangVisitor)this, selectFreeVars);
        }
        selectExpression.getSelectSetOperation().accept(this, selectFreeVars);
        selectFreeVars.removeAll(SqlppVariableUtil.getLetBindingVariables(selectExpression.getLetList()));
        freeVars.addAll(letsFreeVars);
        freeVars.addAll(selectFreeVars);
        return null;
    }

    public Void visit(LiteralExpr l, Collection<VariableExpr> freeVars) throws CompilationException {
        return null;
    }

    public Void visit(ListConstructor lc, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visit(lc.getExprList(), freeVars);
        return null;
    }

    public Void visit(RecordConstructor rc, Collection<VariableExpr> freeVars) throws CompilationException {
        for (FieldBinding binding : rc.getFbList()) {
            binding.getLeftExpr().accept((ILangVisitor)this, freeVars);
            binding.getRightExpr().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(OperatorExpr operatorExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visit(operatorExpr.getExprList(), freeVars);
        return null;
    }

    public Void visit(IfExpr ifExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        ifExpr.getCondExpr().accept((ILangVisitor)this, freeVars);
        ifExpr.getThenExpr().accept((ILangVisitor)this, freeVars);
        ifExpr.getElseExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(QuantifiedExpression qe, Collection<VariableExpr> freeVars) throws CompilationException {
        List<VariableExpr> qeBindingVars = SqlppVariableUtil.getBindingVariables((ILangExpression)qe);
        HashSet qeFreeVars = new HashSet();
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            pair.getExpr().accept((ILangVisitor)this, qeFreeVars);
        }
        qe.getSatisfiesExpr().accept((ILangVisitor)this, qeFreeVars);
        qeFreeVars.removeAll(qeBindingVars);
        freeVars.addAll(qeFreeVars);
        return null;
    }

    public Void visit(CallExpr callExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        for (Expression expr : callExpr.getExprList()) {
            expr.accept((ILangVisitor)this, freeVars);
        }
        if (callExpr.hasAggregateFilterExpr()) {
            callExpr.getAggregateFilterExpr().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(VariableExpr varExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        freeVars.add(varExpr);
        return null;
    }

    public Void visit(UnaryExpr u, Collection<VariableExpr> freeVars) throws CompilationException {
        u.getExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(FieldAccessor fa, Collection<VariableExpr> freeVars) throws CompilationException {
        fa.getExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(IndexAccessor ia, Collection<VariableExpr> freeVars) throws CompilationException {
        ia.getExpr().accept((ILangVisitor)this, freeVars);
        if (ia.getIndexExpr() != null) {
            ia.getIndexExpr().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(ListSliceExpression expression, Collection<VariableExpr> freeVars) throws CompilationException {
        expression.getExpr().accept((ILangVisitor)this, freeVars);
        expression.getStartIndexExpression().accept((ILangVisitor)this, freeVars);
        if (expression.hasEndExpression()) {
            expression.getEndIndexExpression().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(IVisitorExtension ve, Collection<VariableExpr> arg) throws CompilationException {
        ve.freeVariableDispatch((ILangVisitor)this, arg);
        return null;
    }

    @Override
    public Void visit(CaseExpression caseExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        caseExpr.getConditionExpr().accept((ILangVisitor)this, freeVars);
        this.visit(caseExpr.getWhenExprs(), freeVars);
        this.visit(caseExpr.getThenExprs(), freeVars);
        caseExpr.getElseExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(WindowExpression winExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        if (winExpr.hasPartitionList()) {
            this.visit(winExpr.getPartitionList(), freeVars);
        }
        if (winExpr.hasOrderByList()) {
            this.visit(winExpr.getOrderbyList(), freeVars);
        }
        if (winExpr.hasFrameStartExpr()) {
            winExpr.getFrameStartExpr().accept((ILangVisitor)this, freeVars);
        }
        if (winExpr.hasFrameEndExpr()) {
            winExpr.getFrameEndExpr().accept((ILangVisitor)this, freeVars);
        }
        if (winExpr.hasWindowFieldList()) {
            for (Pair<Expression, Identifier> field : winExpr.getWindowFieldList()) {
                ((Expression)field.first).accept((ILangVisitor)this, freeVars);
            }
        }
        this.visit(winExpr.getExprList(), freeVars);
        if (winExpr.hasAggregateFilterExpr()) {
            winExpr.getAggregateFilterExpr().accept((ILangVisitor)this, freeVars);
        }
        if (winExpr.hasWindowVar()) {
            freeVars.remove(winExpr.getWindowVar());
        }
        return null;
    }

    public Void visit(CopyToStatement stmtCopy, Collection<VariableExpr> freeVars) throws CompilationException {
        stmtCopy.getBody().accept((ILangVisitor)this, freeVars);
        this.visit(stmtCopy.getPathExpressions(), freeVars);
        this.visit(stmtCopy.getPartitionExpressions(), freeVars);
        this.visit(stmtCopy.getOrderByList(), freeVars);
        return null;
    }

    private void visitLetWhereClauses(List<? extends AbstractClause> clauseList, Collection<VariableExpr> freeVars) throws CompilationException {
        if (clauseList == null || clauseList.isEmpty()) {
            return;
        }
        HashSet<VariableExpr> bindingVars = new HashSet<VariableExpr>();
        for (AbstractClause abstractClause : clauseList) {
            HashSet clauseFreeVars = new HashSet();
            abstractClause.accept((ILangVisitor)this, clauseFreeVars);
            clauseFreeVars.removeAll(bindingVars);
            freeVars.addAll(clauseFreeVars);
            if (abstractClause.getClauseType() != Clause.ClauseType.LET_CLAUSE) continue;
            bindingVars.add(((LetClause)abstractClause).getVarExpr());
        }
    }

    private void visit(List<Expression> exprs, Collection<VariableExpr> arg) throws CompilationException {
        for (Expression expr : exprs) {
            expr.accept((ILangVisitor)this, arg);
        }
    }

    private void removeAllBindingVarsInSelectBlock(Collection<VariableExpr> selectFreeVars, Collection<VariableExpr> fromBindingVars, Collection<VariableExpr> letsBindingVars, Collection<VariableExpr> gbyBindingVars, Collection<VariableExpr> gbyLetsBindingVars) {
        selectFreeVars.removeAll(fromBindingVars);
        selectFreeVars.removeAll(letsBindingVars);
        selectFreeVars.removeAll(gbyBindingVars);
        selectFreeVars.removeAll(gbyLetsBindingVars);
    }
}

