/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.stream.factory.LocalFSInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketServerInputStreamFactory;
import org.apache.asterix.external.provider.ParserFactoryProvider;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DatasourceFactoryProvider {
    private static final String RESOURCE = "META-INF/services/org.apache.asterix.external.api.IRecordReaderFactory";
    private static final String DEFAULT_FORMAT = "DEFAULT_FORMAT";
    private static Map<String, Map<String, Class<?>>> factories = null;

    private DatasourceFactoryProvider() {
    }

    public static IExternalDataSourceFactory getExternalDataSourceFactory(Map<String, String> configuration) throws HyracksDataException, AsterixException {
        if (ExternalDataUtils.getDataSourceType(configuration).equals((Object)IExternalDataSourceFactory.DataSourceType.RECORDS)) {
            String reader = configuration.get("reader");
            return DatasourceFactoryProvider.getRecordReaderFactory(reader, configuration);
        }
        String streamSource = configuration.get("stream-source");
        return DatasourceFactoryProvider.getInputStreamFactory(streamSource, configuration);
    }

    public static IInputStreamFactory getInputStreamFactory(String streamSource, Map<String, String> configuration) throws HyracksDataException {
        IInputStreamFactory streamSourceFactory;
        if (ExternalDataUtils.isExternal(streamSource)) {
            throw new NotImplementedException();
        }
        switch (streamSource) {
            case "localfs": {
                streamSourceFactory = new LocalFSInputStreamFactory();
                break;
            }
            case "socket": 
            case "socket_adapter": {
                streamSourceFactory = new SocketServerInputStreamFactory();
                break;
            }
            case "socket-client": {
                streamSourceFactory = new SocketServerInputStreamFactory();
                break;
            }
            default: {
                try {
                    streamSourceFactory = (IInputStreamFactory)Class.forName(streamSource).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeDataException(ErrorCode.PROVIDER_DATASOURCE_FACTORY_UNKNOWN_INPUT_STREAM_FACTORY, (Throwable)e, new Serializable[]{streamSource});
                }
            }
        }
        return streamSourceFactory;
    }

    protected static IRecordReaderFactory<?> getInstance(Class<?> clazz) throws AsterixException {
        try {
            return (IRecordReaderFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AsterixException("Cannot create: " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    public static IRecordReaderFactory<?> getRecordReaderFactory(String adaptorName, Map<String, String> configuration) throws HyracksDataException, AsterixException {
        if (adaptorName.equals("external")) {
            throw new NotImplementedException();
        }
        if (factories == null) {
            DatasourceFactoryProvider.initFactories();
        }
        if (factories.containsKey(adaptorName)) {
            Map<String, Class<?>> formatClassMap = factories.get(adaptorName);
            String format = configuration.get("format");
            return DatasourceFactoryProvider.getInstance(formatClassMap.getOrDefault(format, formatClassMap.get(DEFAULT_FORMAT)));
        }
        try {
            return (IRecordReaderFactory)Class.forName(adaptorName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeDataException(ErrorCode.UNKNOWN_RECORD_READER_FACTORY, (Throwable)e, new Serializable[]{adaptorName});
        }
    }

    protected static void initFactories() throws AsterixException {
        factories = new HashMap();
        ClassLoader cl = ParserFactoryProvider.class.getClassLoader();
        Charset encoding = StandardCharsets.UTF_8;
        try {
            Enumeration<URL> urls = cl.getResources(RESOURCE);
            for (URL url : Collections.list(urls)) {
                String[] classNames;
                InputStream is = url.openStream();
                String config = IOUtils.toString((InputStream)is, (Charset)encoding);
                is.close();
                for (String className : classNames = config.split("\n")) {
                    if (className.startsWith("#")) continue;
                    Class<?> clazz = Class.forName(className);
                    IRecordReaderFactory readerFactory = (IRecordReaderFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    List<String> readerNames = readerFactory.getRecordReaderNames();
                    Set<String> supportedFormats = readerFactory.getReaderSupportedFormats();
                    DatasourceFactoryProvider.putFactory(readerNames, supportedFormats, clazz);
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AsterixException((Throwable)e);
        }
    }

    private static void putFactory(List<String> readerNames, Set<String> supportedFormats, Class<?> clazz) throws AsterixException {
        for (String reader : readerNames) {
            Map formatClassMap = factories.computeIfAbsent(reader, k -> new HashMap());
            if (DatasourceFactoryProvider.isDefaultFormat(supportedFormats)) {
                DatasourceFactoryProvider.checkDuplicates(formatClassMap, DEFAULT_FORMAT);
                formatClassMap.put(DEFAULT_FORMAT, clazz);
                continue;
            }
            for (String format : supportedFormats) {
                DatasourceFactoryProvider.checkDuplicates(formatClassMap, format);
                formatClassMap.put(format, clazz);
            }
        }
    }

    private static boolean isDefaultFormat(Set<String> supportedFormats) {
        return supportedFormats.equals(ExternalDataConstants.ALL_FORMATS);
    }

    private static void checkDuplicates(Map<String, Class<?>> factories, String key) throws AsterixException {
        if (factories.containsKey(key)) {
            throw new AsterixException(ErrorCode.PROVIDER_DATASOURCE_FACTORY_DUPLICATE_FORMAT_MAPPING, new Serializable[]{key});
        }
    }
}

