/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import java.io.IOException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartUtils.class);

    private MultipartUtils() {
    }

    static UploadIterator listMultipartUploads(StoreContext storeContext, AmazonS3 s3, @Nullable String prefix, int maxKeys) throws IOException {
        return new UploadIterator(storeContext, s3, maxKeys, prefix);
    }

    public static class UploadIterator
    implements RemoteIterator<MultipartUpload> {
        private ListingIterator lister;
        private MultipartUploadListing listing;
        private ListIterator<MultipartUpload> batchIterator;

        public UploadIterator(StoreContext storeContext, AmazonS3 s3, int maxKeys, @Nullable String prefix) throws IOException {
            this.lister = new ListingIterator(storeContext, s3, prefix, maxKeys);
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.batchIterator.hasNext() || this.requestNextBatch();
        }

        public MultipartUpload next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.batchIterator.next();
        }

        private boolean requestNextBatch() throws IOException {
            if (this.lister.hasNext()) {
                this.listing = this.lister.next();
                this.batchIterator = this.listing.getMultipartUploads().listIterator();
                return this.batchIterator.hasNext();
            }
            return false;
        }
    }

    static class ListingIterator
    implements RemoteIterator<MultipartUploadListing> {
        private final String prefix;
        private final RequestFactory requestFactory;
        private final int maxKeys;
        private final AmazonS3 s3;
        private final Invoker invoker;
        private final AuditSpan auditSpan;
        private final StoreContext storeContext;
        private MultipartUploadListing listing;
        private boolean firstListing = true;
        private int listCount = 0;

        ListingIterator(StoreContext storeContext, AmazonS3 s3, @Nullable String prefix, int maxKeys) throws IOException {
            this.storeContext = storeContext;
            this.s3 = s3;
            this.requestFactory = storeContext.getRequestFactory();
            this.maxKeys = maxKeys;
            this.prefix = prefix;
            this.invoker = storeContext.getInvoker();
            this.auditSpan = storeContext.getActiveAuditSpan();
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            if (this.listing == null) {
                return false;
            }
            return this.firstListing || this.listing.isTruncated();
        }

        public MultipartUploadListing next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                if (this.listing == null || !this.listing.isTruncated()) {
                    throw new NoSuchElementException("No more uploads under " + this.prefix);
                }
                this.requestNextBatch();
            }
            return this.listing;
        }

        public String toString() {
            return "Upload iterator: prefix " + this.prefix + "; list count " + this.listCount + "; upload count " + this.listing.getMultipartUploads().size() + "; isTruncated=" + this.listing.isTruncated();
        }

        private void requestNextBatch() throws IOException {
            try (AuditSpan span = this.auditSpan.activate();){
                ListMultipartUploadsRequest req = this.requestFactory.newListMultipartUploadsRequest(this.prefix);
                if (!this.firstListing) {
                    req.setKeyMarker(this.listing.getNextKeyMarker());
                    req.setUploadIdMarker(this.listing.getNextUploadIdMarker());
                }
                req.setMaxUploads(Integer.valueOf(this.maxKeys));
                LOG.debug("[{}], Requesting next {} uploads prefix {}, next key {}, next upload id {}", new Object[]{this.listCount, this.maxKeys, this.prefix, req.getKeyMarker(), req.getUploadIdMarker()});
                ++this.listCount;
                this.listing = (MultipartUploadListing)this.invoker.retry("listMultipartUploads", this.prefix, true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.storeContext.getInstrumentation(), (String)Statistic.MULTIPART_UPLOAD_LIST.getSymbol(), () -> this.s3.listMultipartUploads(req)));
                LOG.debug("Listing found {} upload(s)", (Object)this.listing.getMultipartUploads().size());
                LOG.debug("New listing state: {}", (Object)this);
            }
        }
    }
}

