/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am.array;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.array.AbstractOperatorFromSubplanRewrite;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;

public class SelectFromSubplanRewrite
extends AbstractOperatorFromSubplanRewrite<SelectOperator> {
    private static final Set<FunctionIdentifier> optimizableFunctions = new HashSet<FunctionIdentifier>();
    private final Deque<SelectOperator> selectRootStack = new ArrayDeque<SelectOperator>();

    public static void addOptimizableFunction(FunctionIdentifier functionIdentifier) {
        optimizableFunctions.add(functionIdentifier);
    }

    @Override
    public SelectOperator createOperator(SelectOperator originalOperator, IOptimizationContext context) throws AlgebricksException {
        SelectOperator mergedSelectOperator;
        this.selectRootStack.push(originalOperator);
        this.reset(originalOperator.getSourceLocation(), context, optimizableFunctions);
        ArrayList<VariableReferenceExpression> booleanVariables = new ArrayList<VariableReferenceExpression>();
        ArrayList<ILogicalExpression> miscExpressions = new ArrayList<ILogicalExpression>();
        ArrayList<SubplanOperator> subplanOperators = new ArrayList<SubplanOperator>();
        this.gatherBooleanVariables((ILogicalExpression)originalOperator.getCondition().getValue(), booleanVariables, miscExpressions);
        this.gatherSubplanOperators((ILogicalOperator)originalOperator, subplanOperators);
        ListIterator subplanIterator = subplanOperators.listIterator();
        if (booleanVariables.isEmpty() || subplanOperators.isEmpty()) {
            return null;
        }
        SubplanOperator bottommostSubplanOperator = (SubplanOperator)subplanOperators.get(subplanOperators.size() - 1);
        while (subplanIterator.hasNext()) {
            SubplanOperator workingSubplanOperator = (SubplanOperator)subplanIterator.next();
            AggregateOperator aggregateFromSubplan = this.getAggregateFromSubplan(workingSubplanOperator);
            if (aggregateFromSubplan == null) continue;
            boolean isMatchingAggregateVariableFound = false;
            for (LogicalVariable aggregateVariable : aggregateFromSubplan.getVariables()) {
                Optional<VariableReferenceExpression> optional = booleanVariables.stream().filter(v -> v.getVariableReference().equals((Object)aggregateVariable)).findFirst();
                if (!optional.isPresent()) continue;
                isMatchingAggregateVariableFound = true;
                booleanVariables.remove(optional.get());
            }
            if (isMatchingAggregateVariableFound) continue;
            subplanIterator.remove();
        }
        if (subplanOperators.isEmpty()) {
            return null;
        }
        miscExpressions.addAll(booleanVariables);
        ArrayList<Pair<SelectOperator, UnnestOperator>> traversalOutputs = new ArrayList<Pair<SelectOperator, UnnestOperator>>();
        for (SubplanOperator subplanBranch : subplanOperators) {
            Pair<SelectOperator, UnnestOperator> traversalOutput = this.traverseSubplanBranch(subplanBranch, null, false);
            if (traversalOutput == null) continue;
            traversalOutputs.add(traversalOutput);
        }
        if (traversalOutputs.size() == 0) {
            return null;
        }
        if (traversalOutputs.size() == 1) {
            Pair traversalOutput = (Pair)traversalOutputs.get(0);
            ILogicalOperator bottommostOperator = (ILogicalOperator)traversalOutput.second;
            SelectOperator selectRewriteOperator = (SelectOperator)traversalOutput.first;
            bottommostOperator.getInputs().addAll(bottommostSubplanOperator.getInputs());
            return this.finalizeSelectOperator(selectRewriteOperator, miscExpressions, context);
        }
        ScalarFunctionCallExpression workingSelectCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND));
        SelectOperator workingLeafOperator = mergedSelectOperator = new SelectOperator((Mutable)new MutableObject((Object)workingSelectCondition));
        for (Pair pair : traversalOutputs) {
            ArrayList selectRewriteExprConjuncts;
            SelectOperator selectRewriteOperator = (SelectOperator)pair.first;
            ILogicalExpression selectRewriteExpr = (ILogicalExpression)selectRewriteOperator.getCondition().getValue();
            if (selectRewriteExpr.splitIntoConjuncts(selectRewriteExprConjuncts = new ArrayList())) {
                for (Mutable conjunct : selectRewriteExprConjuncts) {
                    workingSelectCondition.getArguments().add(new MutableObject((Object)((ILogicalExpression)conjunct.getValue())));
                }
            } else {
                workingSelectCondition.getArguments().add(new MutableObject((Object)selectRewriteExpr));
            }
            workingLeafOperator.getInputs().add(new MutableObject((Object)((ILogicalOperator)pair.second)));
            workingLeafOperator = (ILogicalOperator)pair.second;
        }
        workingLeafOperator.getInputs().addAll(bottommostSubplanOperator.getInputs());
        return this.finalizeSelectOperator(mergedSelectOperator, miscExpressions, context);
    }

    @Override
    public SelectOperator restoreBeforeRewrite(List<Mutable<ILogicalOperator>> afterOperatorRefs, IOptimizationContext context) {
        return this.selectRootStack.pop();
    }

    private SelectOperator finalizeSelectOperator(SelectOperator selectOp, List<ILogicalExpression> auxiliaryExprs, IOptimizationContext context) throws AlgebricksException {
        if (auxiliaryExprs.isEmpty()) {
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)selectOp, (ITypingContext)context);
            return selectOp;
        }
        ScalarFunctionCallExpression workingSelectCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND));
        if (!((ILogicalExpression)selectOp.getCondition().getValue()).splitIntoConjuncts(workingSelectCondition.getArguments())) {
            workingSelectCondition.getArguments().add(selectOp.getCondition());
        }
        for (ILogicalExpression auxiliaryExpr : auxiliaryExprs) {
            workingSelectCondition.getArguments().add(new MutableObject((Object)auxiliaryExpr));
        }
        SelectOperator mergedSelectOperator = new SelectOperator((Mutable)new MutableObject((Object)workingSelectCondition));
        mergedSelectOperator.getInputs().addAll(selectOp.getInputs());
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)mergedSelectOperator, (ITypingContext)context);
        return mergedSelectOperator;
    }
}

