/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.model.java;

import com.sun.tools.ws.processor.model.ModelException;
import com.sun.tools.ws.processor.model.java.JavaStructureMember;
import com.sun.tools.ws.processor.model.java.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaStructureType
extends JavaType {
    private List<JavaStructureMember> members = new ArrayList<JavaStructureMember>();
    private Map<String, JavaStructureMember> membersByName = new HashMap<String, JavaStructureMember>();
    private Set<JavaStructureType> subclasses = new HashSet<JavaStructureType>();
    private JavaStructureType superclass;
    private Object owner;
    private boolean isAbstract = false;

    public JavaStructureType() {
    }

    public JavaStructureType(String name, boolean present, Object owner) {
        super(name, present, "null");
        this.owner = owner;
    }

    public void add(JavaStructureMember m) {
        if (this.membersByName.containsKey(m.getName())) {
            throw new ModelException("model.uniqueness.javastructuretype", m.getName(), this.getRealName());
        }
        this.members.add(m);
        this.membersByName.put(m.getName(), m);
    }

    public JavaStructureMember getMemberByName(String name) {
        if (this.membersByName.size() != this.members.size()) {
            this.initializeMembersByName();
        }
        return this.membersByName.get(name);
    }

    public Iterator<JavaStructureMember> getMembers() {
        return this.members.iterator();
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public List<JavaStructureMember> getMembersList() {
        return this.members;
    }

    public void setMembersList(List<JavaStructureMember> l) {
        this.members = l;
    }

    private void initializeMembersByName() {
        this.membersByName = new HashMap<String, JavaStructureMember>();
        if (this.members != null) {
            for (JavaStructureMember m : this.members) {
                if (m.getName() != null && this.membersByName.containsKey(m.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.membersByName.put(m.getName(), m);
            }
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public JavaStructureType getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(JavaStructureType superclassType) {
        this.superclass = superclassType;
    }

    public void addSubclass(JavaStructureType subclassType) {
        this.subclasses.add(subclassType);
        subclassType.setSuperclass(this);
    }

    public Iterator<JavaStructureType> getSubclasses() {
        if (this.subclasses == null || this.subclasses.isEmpty()) {
            return null;
        }
        return this.subclasses.iterator();
    }

    public Set<JavaStructureType> getSubclassesSet() {
        return this.subclasses;
    }

    public void setSubclassesSet(Set<JavaStructureType> s) {
        this.subclasses = s;
        for (JavaStructureType javaStructureType : s) {
            javaStructureType.setSuperclass(this);
        }
    }

    public Iterator<JavaStructureType> getAllSubclasses() {
        Set<JavaStructureType> subs = this.getAllSubclassesSet();
        if (subs.isEmpty()) {
            return null;
        }
        return subs.iterator();
    }

    public Set<JavaStructureType> getAllSubclassesSet() {
        HashSet<JavaStructureType> transitiveSet = new HashSet<JavaStructureType>();
        for (JavaStructureType subclass : this.subclasses) {
            transitiveSet.addAll(subclass.getAllSubclassesSet());
        }
        transitiveSet.addAll(this.subclasses);
        return transitiveSet;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }
}

