/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.twitter.util.Duration;
import com.twitter.util.Function0;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import com.twitter.util.Promise;
import com.twitter.util.Timer;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.stats.BroadCastStatsLogger;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.AlreadyClosedException;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.exceptions.StreamNotReadyException;
import org.apache.distributedlog.exceptions.StreamUnavailableException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.io.Abortables;
import org.apache.distributedlog.io.AsyncAbortable;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.protocol.util.TwitterFutureUtils;
import org.apache.distributedlog.service.FatalErrorHandler;
import org.apache.distributedlog.service.ServerFeatureKeys;
import org.apache.distributedlog.service.config.ServerConfiguration;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.apache.distributedlog.service.stream.HeartbeatOp;
import org.apache.distributedlog.service.stream.Stream;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.StreamOp;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.service.stream.limiter.StreamRequestLimiter;
import org.apache.distributedlog.service.streamset.Partition;
import org.apache.distributedlog.util.OrderedScheduler;
import org.apache.distributedlog.util.TimeSequencer;
import org.apache.distributedlog.util.Utils;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

public class StreamImpl
implements Stream {
    private static final Logger logger = LoggerFactory.getLogger(StreamImpl.class);
    private final String name;
    private final Partition partition;
    private DistributedLogManager manager;
    private volatile AsyncLogWriter writer;
    private volatile StreamStatus status;
    private volatile String owner;
    private volatile Throwable lastException;
    private volatile Queue<StreamOp> pendingOps = new ArrayDeque<StreamOp>();
    private final Promise<Void> closePromise = new Promise();
    private final Object txnLock = new Object();
    private final TimeSequencer sequencer = new TimeSequencer();
    private final StreamRequestLimiter limiter;
    private final DynamicDistributedLogConfiguration dynConf;
    private final DistributedLogConfiguration dlConfig;
    private final Namespace dlNamespace;
    private final String clientId;
    private final OrderedScheduler scheduler;
    private final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final Feature featureRateLimitDisabled;
    private final StreamManager streamManager;
    private final StreamConfigProvider streamConfigProvider;
    private final FatalErrorHandler fatalErrorHandler;
    private final long streamProbationTimeoutMs;
    private final long serviceTimeoutMs;
    private final long writerCloseTimeoutMs;
    private final boolean failFastOnStreamNotReady;
    private final HashedWheelTimer requestTimer;
    private final Timer futureTimer;
    private final StatsLogger streamLogger;
    private final StatsLogger streamExceptionStatLogger;
    private final StatsLogger limiterStatLogger;
    private final Counter serviceTimeout;
    private final OpStatsLogger streamAcquireStat;
    private final OpStatsLogger writerCloseStatLogger;
    private final Counter pendingOpsCounter;
    private final Counter unexpectedExceptions;
    private final Counter writerCloseTimeoutCounter;
    private final StatsLogger exceptionStatLogger;
    private final ConcurrentHashMap<String, Counter> exceptionCounters = new ConcurrentHashMap();
    private final Gauge<Number> streamStatusGauge;

    StreamImpl(String name, Partition partition, String clientId, StreamManager streamManager, StreamOpStats streamOpStats, ServerConfiguration serverConfig, DistributedLogConfiguration dlConfig, DynamicDistributedLogConfiguration streamConf, FeatureProvider featureProvider, StreamConfigProvider streamConfigProvider, Namespace dlNamespace, OrderedScheduler scheduler, FatalErrorHandler fatalErrorHandler, HashedWheelTimer requestTimer, Timer futureTimer) {
        this.clientId = clientId;
        this.dlConfig = dlConfig;
        this.streamManager = streamManager;
        this.name = name;
        this.partition = partition;
        this.status = StreamStatus.UNINITIALIZED;
        this.lastException = new IOException("Fail to write record to stream " + name);
        this.streamConfigProvider = streamConfigProvider;
        this.dlNamespace = dlNamespace;
        this.featureRateLimitDisabled = featureProvider.getFeature(ServerFeatureKeys.SERVICE_RATE_LIMIT_DISABLED.name().toLowerCase());
        this.scheduler = scheduler;
        this.serviceTimeoutMs = serverConfig.getServiceTimeoutMs();
        this.streamProbationTimeoutMs = serverConfig.getStreamProbationTimeoutMs();
        this.writerCloseTimeoutMs = serverConfig.getWriterCloseTimeoutMs();
        this.failFastOnStreamNotReady = dlConfig.getFailFastOnStreamNotReady();
        this.fatalErrorHandler = fatalErrorHandler;
        this.dynConf = streamConf;
        StatsLogger limiterStatsLogger = BroadCastStatsLogger.two((StatsLogger)streamOpStats.baseScope("stream_limiter"), (StatsLogger)streamOpStats.streamRequestScope(partition, "limiter"));
        this.limiter = new StreamRequestLimiter(name, this.dynConf, limiterStatsLogger, this.featureRateLimitDisabled);
        this.requestTimer = requestTimer;
        this.futureTimer = futureTimer;
        this.streamLogger = streamOpStats.streamRequestStatsLogger(partition);
        this.limiterStatLogger = streamOpStats.baseScope("request_limiter");
        this.streamExceptionStatLogger = this.streamLogger.scope("exceptions");
        this.serviceTimeout = streamOpStats.baseCounter("serviceTimeout");
        StatsLogger streamsStatsLogger = streamOpStats.baseScope("streams");
        this.streamAcquireStat = streamsStatsLogger.getOpStatsLogger("acquire");
        this.pendingOpsCounter = streamOpStats.baseCounter("pending_ops");
        this.unexpectedExceptions = streamOpStats.baseCounter("unexpected_exceptions");
        this.exceptionStatLogger = streamOpStats.requestScope("exceptions");
        this.writerCloseStatLogger = streamsStatsLogger.getOpStatsLogger("writer_close");
        this.writerCloseTimeoutCounter = streamsStatsLogger.getCounter("writer_close_timeouts");
        this.streamStatusGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return StreamStatus.UNINITIALIZED.getCode();
            }

            public Number getSample() {
                return StreamImpl.this.status.getCode();
            }
        };
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getStreamName() {
        return this.name;
    }

    @Override
    public DynamicDistributedLogConfiguration getStreamConfiguration() {
        return this.dynConf;
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    private DistributedLogManager openLog(String name) throws IOException {
        Optional dlConf = Optional.empty();
        Optional<DynamicDistributedLogConfiguration> dynDlConf = Optional.of(this.dynConf);
        Optional<StatsLogger> perStreamStatsLogger = Optional.of(this.streamLogger);
        return this.dlNamespace.openLog(name, dlConf, dynDlConf, perStreamStatsLogger);
    }

    @Override
    public void initialize() throws IOException {
        this.manager = this.openLog(this.name);
        this.streamLogger.registerGauge("stream_status", this.streamStatusGauge);
        this.status = StreamStatus.INITIALIZING;
    }

    public String toString() {
        return String.format("Stream:%s, %s, %s Status:%s", new Object[]{this.name, this.manager, this.writer, this.status});
    }

    @Override
    public void start() {
        this.acquireStream().addEventListener((FutureEventListener)new FutureEventListener<Boolean>(){

            public void onSuccess(Boolean success) {
                if (!success.booleanValue()) {
                    StreamImpl.this.setStreamInErrorStatus();
                    StreamImpl.this.requestClose("Failed to acquire the ownership");
                }
            }

            public void onFailure(Throwable cause) {
                logger.error("Stream {} threw unhandled exception : ", (Object)StreamImpl.this.name, (Object)cause);
                StreamImpl.this.setStreamInErrorStatus();
                StreamImpl.this.requestClose("Unhandled exception");
            }
        });
    }

    void countException(Throwable t, StatsLogger streamExceptionLogger) {
        Counter oldCounter;
        String exceptionName = null == t ? "null" : t.getClass().getName();
        Counter counter = this.exceptionCounters.get(exceptionName);
        if (null == counter && null != (oldCounter = this.exceptionCounters.putIfAbsent(exceptionName, counter = this.exceptionStatLogger.getCounter(exceptionName)))) {
            counter = oldCounter;
        }
        counter.inc();
        streamExceptionLogger.getCounter(exceptionName).inc();
    }

    boolean isCriticalException(Throwable cause) {
        return !(cause instanceof OwnershipAcquireFailedException);
    }

    void scheduleTimeout(final StreamOp op) {
        final Timeout timeout = this.requestTimer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (!timeout.isCancelled()) {
                    StreamImpl.this.serviceTimeout.inc();
                    StreamImpl.this.handleServiceTimeout("Operation " + op.getClass().getName() + " timeout");
                }
            }
        }, this.serviceTimeoutMs, TimeUnit.MILLISECONDS);
        op.responseHeader().ensure((scala.Function0)new Function0<BoxedUnit>(){

            public BoxedUnit apply() {
                timeout.cancel();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceTimeout(String reason) {
        StreamImpl streamImpl = this;
        synchronized (streamImpl) {
            if (StreamStatus.isUnavailable(this.status)) {
                return;
            }
            this.setStreamInErrorStatus();
        }
        Future<Void> closeFuture = this.requestClose(reason, false);
        closeFuture.onSuccess((Function1)new AbstractFunction1<Void, BoxedUnit>(){

            public BoxedUnit apply(Void result) {
                StreamImpl.this.streamManager.scheduleRemoval(StreamImpl.this, StreamImpl.this.streamProbationTimeoutMs);
                return BoxedUnit.UNIT;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(StreamOp op) {
        try {
            this.limiter.apply(op);
        }
        catch (OverCapacityException ex) {
            op.fail(ex);
            return;
        }
        if (this.serviceTimeoutMs > 0L) {
            this.scheduleTimeout(op);
        }
        boolean completeOpNow = false;
        boolean success = true;
        if (StreamStatus.isUnavailable(this.status)) {
            op.fail((Throwable)new StreamUnavailableException("Stream " + this.name + " is closed."));
            return;
        }
        if (StreamStatus.INITIALIZED == this.status && this.writer != null) {
            completeOpNow = true;
            success = true;
        } else {
            StreamImpl streamImpl = this;
            synchronized (streamImpl) {
                if (StreamStatus.isUnavailable(this.status)) {
                    op.fail((Throwable)new StreamUnavailableException("Stream " + this.name + " is closed."));
                    return;
                }
                if (StreamStatus.INITIALIZED == this.status) {
                    completeOpNow = true;
                    success = true;
                } else {
                    if (this.failFastOnStreamNotReady) {
                        op.fail((Throwable)new StreamNotReadyException("Stream " + this.name + " is not ready; status = " + (Object)((Object)this.status)));
                        return;
                    }
                    this.pendingOps.add(op);
                    this.pendingOpsCounter.inc();
                    if (1 == this.pendingOps.size() && op instanceof HeartbeatOp) {
                        ((HeartbeatOp)op).setWriteControlRecord(true);
                    }
                }
            }
        }
        if (completeOpNow) {
            this.executeOp(op, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeOp(final StreamOp op, boolean success) {
        Throwable lastException;
        AsyncLogWriter writer;
        StreamImpl streamImpl = this;
        synchronized (streamImpl) {
            writer = this.writer;
            lastException = this.lastException;
        }
        if (null != writer && success) {
            op.execute(writer, (Sequencer)this.sequencer, this.txnLock).addEventListener((FutureEventListener)new FutureEventListener<Void>(){

                public void onSuccess(Void value) {
                }

                public void onFailure(Throwable cause) {
                    boolean countAsException = true;
                    if (cause instanceof DLException) {
                        DLException dle = (DLException)cause;
                        switch (dle.getCode()) {
                            case 302: {
                                assert (cause instanceof OwnershipAcquireFailedException);
                                countAsException = false;
                                StreamImpl.this.handleExceptionOnStreamOp(op, cause);
                                break;
                            }
                            case 502: {
                                assert (cause instanceof AlreadyClosedException);
                                op.fail(cause);
                                StreamImpl.this.handleAlreadyClosedException((AlreadyClosedException)cause);
                                break;
                            }
                            case 413: 
                            case 501: 
                            case 506: 
                            case 509: 
                            case 510: 
                            case 511: 
                            case 512: 
                            case 513: 
                            case 517: 
                            case 518: 
                            case 602: {
                                op.fail(cause);
                                break;
                            }
                            default: {
                                StreamImpl.this.handleExceptionOnStreamOp(op, cause);
                                break;
                            }
                        }
                    } else {
                        StreamImpl.this.handleExceptionOnStreamOp(op, cause);
                    }
                    if (countAsException) {
                        StreamImpl.this.countException(cause, StreamImpl.this.streamExceptionStatLogger);
                    }
                }
            });
        } else if (null != lastException) {
            op.fail(lastException);
        } else {
            op.fail((Throwable)new StreamUnavailableException("Stream " + this.name + " is closed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptionOnStreamOp(StreamOp op, Throwable cause) {
        AsyncLogWriter oldWriter = null;
        boolean statusChanged = false;
        StreamImpl streamImpl = this;
        synchronized (streamImpl) {
            if (StreamStatus.INITIALIZED == this.status) {
                oldWriter = this.setStreamStatus(StreamStatus.ERROR, StreamStatus.INITIALIZED, null, cause);
                statusChanged = true;
            }
        }
        if (statusChanged) {
            Abortables.asyncAbort((AsyncAbortable)oldWriter, (boolean)false);
            if (this.isCriticalException(cause)) {
                logger.error("Failed to write data into stream {} : ", (Object)this.name, (Object)cause);
            } else {
                logger.warn("Failed to write data into stream {} : {}", (Object)this.name, (Object)cause.getMessage());
            }
            this.requestClose("Failed to write data into stream " + this.name + " : " + cause.getMessage());
        }
        op.fail(cause);
    }

    private void handleAlreadyClosedException(AlreadyClosedException ace) {
        this.unexpectedExceptions.inc();
        logger.error("Encountered unexpected exception when writing data into stream {} : ", (Object)this.name, (Object)ace);
        this.fatalErrorHandler.notifyFatalError();
    }

    Future<Boolean> acquireStream() {
        final Stopwatch stopwatch = Stopwatch.createStarted();
        final Promise acquirePromise = new Promise();
        this.manager.openAsyncLogWriter().whenCompleteAsync((BiConsumer)new org.apache.distributedlog.common.concurrent.FutureEventListener<AsyncLogWriter>(){

            public void onSuccess(AsyncLogWriter w) {
                StreamImpl.this.onAcquireStreamSuccess(w, stopwatch, (Promise<Boolean>)acquirePromise);
            }

            public void onFailure(Throwable cause) {
                StreamImpl.this.onAcquireStreamFailure(cause, stopwatch, (Promise<Boolean>)acquirePromise);
            }
        }, (Executor)this.scheduler.chooseExecutor((Object)this.getStreamName()));
        return acquirePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAcquireStreamSuccess(AsyncLogWriter w, Stopwatch stopwatch, Promise<Boolean> acquirePromise) {
        boolean success;
        Queue<StreamOp> oldPendingOps;
        AsyncLogWriter oldWriter;
        Object object = this.txnLock;
        synchronized (object) {
            this.sequencer.setLastId(w.getLastTxId());
        }
        StreamImpl streamImpl = this;
        synchronized (streamImpl) {
            oldWriter = this.setStreamStatus(StreamStatus.INITIALIZED, StreamStatus.INITIALIZING, w, null);
            oldPendingOps = this.pendingOps;
            this.pendingOps = new ArrayDeque<StreamOp>();
            success = true;
        }
        if (!this.streamManager.allowAcquire(this)) {
            if (null != oldWriter) {
                Abortables.asyncAbort((AsyncAbortable)oldWriter, (boolean)true);
            }
            int maxAcquiredPartitions = this.dynConf.getMaxAcquiredPartitionsPerProxy();
            StreamUnavailableException sue = new StreamUnavailableException("Stream " + this.partition.getStream() + " is not allowed to acquire more than " + maxAcquiredPartitions + " partitions");
            this.countException((Throwable)sue, this.exceptionStatLogger);
            logger.error("Failed to acquire stream {} because it is unavailable : {}", (Object)this.name, (Object)sue.getMessage());
            StreamImpl streamImpl2 = this;
            synchronized (streamImpl2) {
                oldWriter = this.setStreamStatus(StreamStatus.ERROR, StreamStatus.INITIALIZED, null, (Throwable)sue);
                success = false;
            }
        }
        this.processPendingRequestsAfterAcquire(success, oldWriter, oldPendingOps, stopwatch, acquirePromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAcquireStreamFailure(Throwable cause, Stopwatch stopwatch, Promise<Boolean> acquirePromise) {
        boolean success;
        Queue<StreamOp> oldPendingOps;
        AsyncLogWriter oldWriter;
        if (cause instanceof AlreadyClosedException) {
            this.countException(cause, this.streamExceptionStatLogger);
            this.handleAlreadyClosedException((AlreadyClosedException)cause);
            return;
        }
        if (this.isCriticalException(cause)) {
            this.countException(cause, this.streamExceptionStatLogger);
            logger.error("Failed to acquire stream {} : ", (Object)this.name, (Object)cause);
        } else {
            logger.warn("Failed to acquire stream {} : {}", (Object)this.name, (Object)cause.getMessage());
        }
        StreamImpl streamImpl = this;
        synchronized (streamImpl) {
            oldWriter = this.setStreamStatus(StreamStatus.ERROR, StreamStatus.INITIALIZING, null, cause);
            oldPendingOps = this.pendingOps;
            this.pendingOps = new ArrayDeque<StreamOp>();
            success = false;
        }
        this.processPendingRequestsAfterAcquire(success, oldWriter, oldPendingOps, stopwatch, acquirePromise);
    }

    void processPendingRequestsAfterAcquire(boolean success, AsyncLogWriter oldWriter, Queue<StreamOp> oldPendingOps, Stopwatch stopwatch, Promise<Boolean> acquirePromise) {
        if (success) {
            this.streamAcquireStat.registerSuccessfulEvent(stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        } else {
            this.streamAcquireStat.registerFailedEvent(stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
        for (StreamOp op : oldPendingOps) {
            this.executeOp(op, success);
            this.pendingOpsCounter.dec();
        }
        Abortables.asyncAbort((AsyncAbortable)oldWriter, (boolean)true);
        TwitterFutureUtils.setValue(acquirePromise, (Object)success);
    }

    synchronized void setStreamInErrorStatus() {
        if (StreamStatus.CLOSING == this.status || StreamStatus.CLOSED == this.status) {
            return;
        }
        this.status = StreamStatus.ERROR;
    }

    synchronized AsyncLogWriter setStreamStatus(StreamStatus newStatus, StreamStatus oldStatus, AsyncLogWriter writer, Throwable t) {
        if (oldStatus != this.status) {
            logger.info("Stream {} status already changed from {} -> {} when trying to change it to {}", new Object[]{this.name, oldStatus, this.status, newStatus});
            return null;
        }
        String owner = null;
        if (t instanceof OwnershipAcquireFailedException) {
            owner = ((OwnershipAcquireFailedException)t).getCurrentOwner();
        }
        AsyncLogWriter oldWriter = this.writer;
        this.writer = writer;
        if (null != owner && owner.equals(this.clientId)) {
            this.unexpectedExceptions.inc();
            logger.error("I am waiting myself {} to release lock on stream {}, so have to shut myself down :", new Object[]{owner, this.name, t});
            this.fatalErrorHandler.notifyFatalError();
            this.owner = null;
        } else {
            this.owner = owner;
        }
        this.lastException = t;
        this.status = newStatus;
        if (StreamStatus.INITIALIZED == newStatus) {
            this.streamManager.notifyAcquired(this);
            logger.info("Inserted acquired stream {} -> writer {}", (Object)this.name, (Object)this);
        } else {
            this.streamManager.notifyReleased(this);
            logger.info("Removed acquired stream {} -> writer {}", (Object)this.name, (Object)this);
        }
        return oldWriter;
    }

    void close(DistributedLogManager dlm) {
        if (null != dlm) {
            try {
                dlm.close();
            }
            catch (IOException ioe) {
                logger.warn("Failed to close dlm for {} : ", (Object)this.name, (Object)ioe);
            }
        }
    }

    @Override
    public Future<Void> requestClose(String reason) {
        return this.requestClose(reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Void> requestClose(String reason, boolean uncache) {
        boolean abort;
        this.closeLock.writeLock().lock();
        try {
            if (StreamStatus.CLOSING == this.status || StreamStatus.CLOSED == this.status) {
                Promise<Void> promise = this.closePromise;
                return promise;
            }
            logger.info("Request to close stream {} : {}", (Object)this.getStreamName(), (Object)reason);
            abort = StreamStatus.INITIALIZED != this.status;
            this.status = StreamStatus.CLOSING;
            this.streamManager.notifyReleased(this);
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.close(abort, uncache);
        return this.closePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        if (null != this.writer) {
            Utils.close((AsyncCloseable)this.writer);
            StreamImpl streamImpl = this;
            synchronized (streamImpl) {
                this.writer = null;
                this.lastException = new StreamUnavailableException("Stream was deleted");
            }
        }
        if (null == this.manager) {
            throw new UnexpectedException("No stream " + this.name + " to delete");
        }
        this.manager.delete();
    }

    private void postClose(boolean uncache) {
        this.closeManagerAndErrorOutPendingRequests();
        this.unregisterGauge();
        if (uncache) {
            if (null != this.owner) {
                long probationTimeoutMs = 2 * this.dlConfig.getZKSessionTimeoutMilliseconds() / 3;
                this.streamManager.scheduleRemoval(this, probationTimeoutMs);
            } else {
                this.streamManager.notifyRemoved(this);
                logger.info("Removed cached stream {}.", (Object)this.getStreamName());
            }
        }
        TwitterFutureUtils.setValue(this.closePromise, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> close(boolean shouldAbort, final boolean uncache) {
        boolean abort;
        this.closeLock.writeLock().lock();
        try {
            if (StreamStatus.CLOSED == this.status) {
                Promise<Void> promise = this.closePromise;
                return promise;
            }
            abort = shouldAbort || StreamStatus.INITIALIZED != this.status && StreamStatus.CLOSING != this.status;
            this.status = StreamStatus.CLOSED;
            this.streamManager.notifyReleased(this);
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        logger.info("Closing stream {} ...", (Object)this.name);
        CompletableFuture closeWriterFuture = abort ? Abortables.asyncAbort((AsyncAbortable)this.writer, (boolean)true) : Utils.asyncClose((AsyncCloseable)this.writer, (boolean)true);
        Duration closeWaitDuration = this.writerCloseTimeoutMs <= 0L ? Duration.Top() : Duration.fromMilliseconds((long)this.writerCloseTimeoutMs);
        CompletableFuture maskedFuture = FutureUtils.createFuture();
        FutureUtils.proxyTo((CompletableFuture)FutureUtils.stats((CompletableFuture)closeWriterFuture, (OpStatsLogger)this.writerCloseStatLogger, (Stopwatch)Stopwatch.createStarted()), (CompletableFuture)maskedFuture);
        FutureUtils.within((CompletableFuture)maskedFuture, (long)closeWaitDuration.inMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (Throwable)new TimeoutException("Timeout on closing"), (OrderedScheduler)this.scheduler, (Object)this.name).whenCompleteAsync((BiConsumer)new org.apache.distributedlog.common.concurrent.FutureEventListener<Void>(){

            public void onSuccess(Void value) {
                StreamImpl.this.postClose(uncache);
            }

            public void onFailure(Throwable cause) {
                if (cause instanceof TimeoutException) {
                    StreamImpl.this.writerCloseTimeoutCounter.inc();
                }
            }
        }, (Executor)this.scheduler.chooseExecutor((Object)this.name));
        return this.closePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeManagerAndErrorOutPendingRequests() {
        Queue<StreamOp> oldPendingOps;
        this.close(this.manager);
        StreamImpl streamImpl = this;
        synchronized (streamImpl) {
            oldPendingOps = this.pendingOps;
            this.pendingOps = new ArrayDeque<StreamOp>();
        }
        StreamUnavailableException closingException = new StreamUnavailableException("Stream " + this.name + " is closed.");
        for (StreamOp op : oldPendingOps) {
            op.fail((Throwable)closingException);
            this.pendingOpsCounter.dec();
        }
        this.limiter.close();
        logger.info("Closed stream {}.", (Object)this.name);
    }

    private void unregisterGauge() {
        this.streamLogger.unregisterGauge("stream_status", this.streamStatusGauge);
    }

    @VisibleForTesting
    public int numPendingOps() {
        Queue<StreamOp> queue = this.pendingOps;
        return null == queue ? 0 : queue.size();
    }

    @VisibleForTesting
    public StreamStatus getStatus() {
        return this.status;
    }

    @VisibleForTesting
    public void setStatus(StreamStatus status) {
        this.status = status;
    }

    @VisibleForTesting
    public AsyncLogWriter getWriter() {
        return this.writer;
    }

    @VisibleForTesting
    public DistributedLogManager getManager() {
        return this.manager;
    }

    @VisibleForTesting
    public Throwable getLastException() {
        return this.lastException;
    }

    @VisibleForTesting
    public Future<Void> getCloseFuture() {
        return this.closePromise;
    }

    public static enum StreamStatus {
        UNINITIALIZED(-1),
        INITIALIZING(0),
        INITIALIZED(1),
        CLOSING(-4),
        CLOSED(-5),
        ERROR(-6);

        final int code;

        private StreamStatus(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }

        public static boolean isUnavailable(StreamStatus status) {
            return ERROR == status || CLOSING == status || CLOSED == status;
        }
    }
}

