/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.api;

import java.util.Arrays;
import java.util.Collection;
import org.openjdk.source.util.TaskEvent;
import org.openjdk.source.util.TaskListener;
import org.openjdk.tools.javac.api.ClientCodeWrapper;
import org.openjdk.tools.javac.util.Context;

public class MultiTaskListener
implements TaskListener {
    public static final Context.Key<MultiTaskListener> taskListenerKey = new Context.Key();
    private static final TaskListener[] EMPTY_LISTENERS = new TaskListener[0];
    TaskListener[] listeners = EMPTY_LISTENERS;
    ClientCodeWrapper ccw;

    public static MultiTaskListener instance(Context context) {
        MultiTaskListener instance = context.get(taskListenerKey);
        if (instance == null) {
            instance = new MultiTaskListener(context);
        }
        return instance;
    }

    protected MultiTaskListener(Context context) {
        context.put(taskListenerKey, this);
        this.ccw = ClientCodeWrapper.instance(context);
    }

    public Collection<TaskListener> getTaskListeners() {
        return Arrays.asList(this.listeners);
    }

    public boolean isEmpty() {
        return this.listeners == EMPTY_LISTENERS;
    }

    public void add(TaskListener listener) {
        for (TaskListener l : this.listeners) {
            if (this.ccw.unwrap(l) != listener) continue;
            throw new IllegalStateException();
        }
        this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
        this.listeners[this.listeners.length - 1] = this.ccw.wrap(listener);
    }

    public void remove(TaskListener listener) {
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.ccw.unwrap(this.listeners[i]) != listener) continue;
            if (this.listeners.length == 1) {
                this.listeners = EMPTY_LISTENERS;
                break;
            }
            TaskListener[] newListeners = new TaskListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, i);
            System.arraycopy(this.listeners, i + 1, newListeners, i, newListeners.length - i);
            this.listeners = newListeners;
            break;
        }
    }

    @Override
    public void started(TaskEvent e) {
        TaskListener[] ll;
        for (TaskListener l : ll = this.listeners) {
            l.started(e);
        }
    }

    @Override
    public void finished(TaskEvent e) {
        TaskListener[] ll;
        for (TaskListener l : ll = this.listeners) {
            l.finished(e);
        }
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }

    public void clear() {
        this.listeners = EMPTY_LISTENERS;
    }
}

