/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.file.JRTIndex;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.jvm.ClassReader;
import org.openjdk.tools.javac.jvm.Profile;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.platform.PlatformDescription;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Convert;
import org.openjdk.tools.javac.util.Dependencies;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;

public class ClassFinder {
    protected static final Context.Key<ClassFinder> classFinderKey = new Context.Key();
    ClassReader reader;
    private final Annotate annotate;
    boolean verbose;
    private boolean cacheCompletionFailure;
    protected boolean preferSource;
    protected boolean userPathsFirst;
    private boolean allowSigFiles;
    final Log log;
    Symtab syms;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    private final Dependencies dependencies;
    JCDiagnostic.Factory diagFactory;
    public Symbol.Completer sourceCompleter = Symbol.Completer.NULL_COMPLETER;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    private final Profile profile;
    private final JRTIndex jrtIndex;
    private final Symbol.Completer thisCompleter = new Symbol.Completer(){

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            ClassFinder.this.complete(sym);
        }
    };
    private Map<Symbol.PackageSymbol, Long> supplementaryFlags;
    private final Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, (JCDiagnostic)null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;
    private boolean preferCurrent;

    public Symbol.Completer getCompleter() {
        return this.thisCompleter;
    }

    public static ClassFinder instance(Context context) {
        ClassFinder instance = context.get(classFinderKey);
        if (instance == null) {
            instance = new ClassFinder(context);
        }
        return instance;
    }

    protected ClassFinder(Context context) {
        JavacFileManager jfm;
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        context.put(classFinderKey, this);
        this.reader = ClassReader.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dependencies = Dependencies.instance(context);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.annotate = Annotate.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.userPathsFirst = options.isSet(Option.XXUSERPATHSFIRST);
        this.allowSigFiles = context.get(PlatformDescription.class) != null;
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
        JavaFileManager fm = context.get(JavaFileManager.class);
        boolean useCtProps = fm instanceof JavacFileManager ? (jfm = (JavacFileManager)fm).isDefaultBootClassPath() && jfm.isSymbolFileEnabled() : (fm.getClass().getName().equals("org.openjdk.tools.sjavac.comp.SmartFileManager") ? !options.isSet("ignore.symbol.file") : false);
        this.jrtIndex = useCtProps && JRTIndex.isAvailable() ? JRTIndex.getSharedInstance() : null;
        this.profile = Profile.instance(context);
    }

    long getSupplementaryFlags(Symbol.ClassSymbol c) {
        Long flags;
        if (this.jrtIndex == null || !this.jrtIndex.isInJRT(c.classfile)) {
            return 0L;
        }
        if (this.supplementaryFlags == null) {
            this.supplementaryFlags = new HashMap<Symbol.PackageSymbol, Long>();
        }
        if ((flags = this.supplementaryFlags.get(c.packge())) == null) {
            long newFlags = 0L;
            try {
                JRTIndex.CtSym ctSym = this.jrtIndex.getCtSym(c.packge().flatName());
                Profile minProfile = Profile.DEFAULT;
                if (ctSym.proprietary) {
                    newFlags |= 0x4000000000L;
                }
                if (ctSym.minProfile != null) {
                    minProfile = Profile.lookup(ctSym.minProfile);
                }
                if (this.profile != Profile.DEFAULT && minProfile.value > this.profile.value) {
                    newFlags |= 0x200000000000L;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            flags = newFlags;
            this.supplementaryFlags.put(c.packge(), flags);
        }
        return flags;
    }

    private void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == Kinds.Kind.TYP) {
            try {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                this.dependencies.push(c, Dependencies.CompletionCause.CLASS_READER);
                this.annotate.blockAnnotations();
                c.members_field = new Scope.ErrorScope(c);
                this.completeOwners(c.owner);
                this.completeEnclosing(c);
                this.fillIn(c);
            }
            finally {
                this.annotate.unblockAnnotationsNoFlush();
                this.dependencies.pop();
            }
        }
        if (sym.kind == Kinds.Kind.PCK) {
            Symbol.PackageSymbol p = (Symbol.PackageSymbol)sym;
            try {
                this.fillIn(p);
            }
            catch (IOException ex) {
                throw new Symbol.CompletionFailure(sym, ex.getLocalizedMessage()).initCause(ex);
            }
        }
        if (!this.reader.filling) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol o) {
        if (o.kind != Kinds.Kind.PCK) {
            this.completeOwners(o.owner);
        }
        o.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol c) {
        if (c.owner.kind == Kinds.Kind.PCK) {
            Symbol owner = c.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(c.name))) {
                Symbol encl = owner.members().findFirst(name);
                if (encl == null) {
                    encl = this.syms.classes.get(Symbol.TypeSymbol.formFlatName(name, owner));
                }
                if (encl == null) continue;
                encl.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIn(Symbol.ClassSymbol c) {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure((Symbol)c, "user-selected completion failure by class name");
        }
        this.currentOwner = c;
        JavaFileObject classfile = c.classfile;
        if (classfile != null) {
            JavaFileObject previousClassFile = this.currentClassFile;
            try {
                if (this.reader.filling) {
                    Assert.error("Filling " + classfile.toUri() + " during " + previousClassFile);
                }
                this.currentClassFile = classfile;
                if (this.verbose) {
                    this.log.printVerbose("loading", this.currentClassFile.getName());
                }
                if (classfile.getKind() == JavaFileObject.Kind.CLASS || classfile.getKind() == JavaFileObject.Kind.OTHER) {
                    this.reader.readClassFile(c);
                    c.flags_field |= this.getSupplementaryFlags(c);
                }
                if (!this.sourceCompleter.isTerminal()) {
                    this.sourceCompleter.complete(c);
                }
                throw new IllegalStateException("Source completer required to read " + classfile.toUri());
            }
            finally {
                this.currentClassFile = previousClassFile;
            }
        } else {
            throw this.classFileNotFound(c);
        }
    }

    private Symbol.CompletionFailure classFileNotFound(Symbol.ClassSymbol c) {
        JCDiagnostic diag = this.diagFactory.fragment("class.file.not.found", c.flatname);
        return this.newCompletionFailure(c, diag);
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol c, JCDiagnostic diag) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure((Symbol)c, diag);
        }
        Symbol.CompletionFailure result = this.cachedCompletionFailure;
        result.sym = c;
        result.diag = diag;
        return result;
    }

    public Symbol.ClassSymbol loadClass(Name flatname) throws Symbol.CompletionFailure {
        boolean absent = this.syms.classes.get(flatname) == null;
        Symbol.ClassSymbol c = this.syms.enterClass(flatname);
        if (c.members_field == null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure ex) {
                if (absent) {
                    this.syms.classes.remove(flatname);
                }
                throw ex;
            }
        }
        return c;
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file) {
        Symbol.ClassSymbol c;
        JavaFileObject.Kind kind;
        if ((p.flags_field & 0x800000L) == 0L) {
            Symbol q = p;
            while (q != null && q.kind == Kinds.Kind.PCK) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
        }
        int seen = (kind = file.getKind()) == JavaFileObject.Kind.CLASS || kind == JavaFileObject.Kind.OTHER ? 0x2000000 : 0x4000000;
        String binaryName = this.fileManager.inferBinaryName(this.currentLoc, file);
        int lastDot = binaryName.lastIndexOf(".");
        Name classname = this.names.fromString(binaryName.substring(lastDot + 1));
        boolean isPkgInfo = classname == this.names.package_info;
        Symbol.ClassSymbol classSymbol = c = isPkgInfo ? p.package_info : (Symbol.ClassSymbol)p.members_field.findFirst(classname);
        if (c == null) {
            c = this.syms.enterClass(classname, p);
            if (c.classfile == null) {
                c.classfile = file;
            }
            if (isPkgInfo) {
                p.package_info = c;
            } else if (c.owner == p) {
                p.members_field.enter(c);
            }
        } else if (!this.preferCurrent && c.classfile != null && (c.flags_field & (long)seen) == 0L && (c.flags_field & 0x6000000L) != 0L) {
            c.classfile = this.preferredFileObject(file, c.classfile);
        }
        c.flags_field |= (long)seen;
    }

    protected JavaFileObject preferredFileObject(JavaFileObject a, JavaFileObject b) {
        long bdate;
        if (this.preferSource) {
            return a.getKind() == JavaFileObject.Kind.SOURCE ? a : b;
        }
        long adate = a.getLastModified();
        return adate > (bdate = b.getLastModified()) ? a : b;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol pack, JavaFileObject fe) {
    }

    private void fillIn(Symbol.PackageSymbol p) throws IOException {
        if (p.members_field == null) {
            p.members_field = Scope.WriteableScope.create(p);
        }
        this.preferCurrent = false;
        if (this.userPathsFirst) {
            this.scanUserPaths(p);
            this.preferCurrent = true;
            this.scanPlatformPath(p);
        } else {
            this.scanPlatformPath(p);
            this.scanUserPaths(p);
        }
        this.verbosePath = false;
    }

    private void scanUserPaths(Symbol.PackageSymbol p) throws IOException {
        EnumSet<JavaFileObject.Kind> kinds = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> classKinds = EnumSet.copyOf(kinds);
        classKinds.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean wantClassFiles = !classKinds.isEmpty();
        EnumSet<JavaFileObject.Kind> sourceKinds = EnumSet.copyOf(kinds);
        sourceKinds.remove((Object)JavaFileObject.Kind.CLASS);
        boolean wantSourceFiles = !sourceKinds.isEmpty();
        boolean haveSourcePath = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> path;
            StandardJavaFileManager fm = (StandardJavaFileManager)this.fileManager;
            if (haveSourcePath && wantSourceFiles) {
                path = List.nil();
                for (Path path2 : fm.getLocationAsPaths(StandardLocation.SOURCE_PATH)) {
                    path = path.prepend(path2);
                }
                this.log.printVerbose("sourcepath", path.reverse().toString());
            } else if (wantSourceFiles) {
                path = List.nil();
                for (Path path3 : fm.getLocationAsPaths(StandardLocation.CLASS_PATH)) {
                    path = path.prepend(path3);
                }
                this.log.printVerbose("sourcepath", path.reverse().toString());
            }
            if (wantClassFiles) {
                path = List.nil();
                for (Path path4 : fm.getLocationAsPaths(StandardLocation.PLATFORM_CLASS_PATH)) {
                    path = path.prepend(path4);
                }
                for (Path path5 : fm.getLocationAsPaths(StandardLocation.CLASS_PATH)) {
                    path = path.prepend(path5);
                }
                this.log.printVerbose("classpath", path.reverse().toString());
            }
        }
        String packageName = p.fullname.toString();
        if (wantSourceFiles && !haveSourcePath) {
            this.fillIn(p, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, packageName, kinds, false));
        } else {
            if (wantClassFiles) {
                this.fillIn(p, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, packageName, classKinds, false));
            }
            if (wantSourceFiles) {
                this.fillIn(p, StandardLocation.SOURCE_PATH, this.fileManager.list(StandardLocation.SOURCE_PATH, packageName, sourceKinds, false));
            }
        }
    }

    private void scanPlatformPath(Symbol.PackageSymbol p) throws IOException {
        this.fillIn(p, StandardLocation.PLATFORM_CLASS_PATH, this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, p.fullname.toString(), this.allowSigFiles ? EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.OTHER) : EnumSet.of(JavaFileObject.Kind.CLASS), false));
    }

    private void fillIn(Symbol.PackageSymbol p, JavaFileManager.Location location, Iterable<JavaFileObject> files) {
        this.currentLoc = location;
        block4: for (JavaFileObject fo : files) {
            switch (fo.getKind()) {
                case OTHER: {
                    boolean sigFile;
                    boolean bl = sigFile = location == StandardLocation.PLATFORM_CLASS_PATH && this.allowSigFiles && fo.getName().endsWith(".sig");
                    if (!sigFile) {
                        this.extraFileActions(p, fo);
                        continue block4;
                    }
                }
                case CLASS: 
                case SOURCE: {
                    String binaryName = this.fileManager.inferBinaryName(this.currentLoc, fo);
                    String simpleName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(simpleName) && !simpleName.equals("package-info")) continue block4;
                    this.includeClassFile(p, fo);
                    continue block4;
                }
            }
            this.extraFileActions(p, fo);
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol sym, JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory) {
            super((Symbol)sym, BadClassFile.createBadClassFileDiagnostic(file, diag, diagFactory));
        }

        private static JCDiagnostic createBadClassFileDiagnostic(JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory) {
            String key = file.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
            return diagFactory.fragment(key, file, diag);
        }
    }
}

