/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.tools.JavaFileManager;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFileFactory;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletConstants;

public abstract class DocFile {
    private final Configuration configuration;
    protected final JavaFileManager.Location location;
    protected final DocPath path;

    public static DocFile createFileForDirectory(Configuration configuration, String file) {
        return DocFileFactory.getFactory(configuration).createFileForDirectory(file);
    }

    public static DocFile createFileForInput(Configuration configuration, String file) {
        return DocFileFactory.getFactory(configuration).createFileForInput(file);
    }

    public static DocFile createFileForOutput(Configuration configuration, DocPath path) {
        return DocFileFactory.getFactory(configuration).createFileForOutput(path);
    }

    public static Iterable<DocFile> list(Configuration configuration, JavaFileManager.Location location, DocPath path) {
        return DocFileFactory.getFactory(configuration).list(location, path);
    }

    protected DocFile(Configuration configuration) {
        this.configuration = configuration;
        this.location = null;
        this.path = null;
    }

    protected DocFile(Configuration configuration, JavaFileManager.Location location, DocPath path) {
        this.configuration = configuration;
        this.location = location;
        this.path = path;
    }

    public abstract InputStream openInputStream() throws IOException;

    public abstract OutputStream openOutputStream() throws IOException, UnsupportedEncodingException;

    public abstract Writer openWriter() throws IOException, UnsupportedEncodingException;

    public void copyFile(DocFile fromFile) throws IOException {
        try (OutputStream output = this.openOutputStream();
             InputStream input = fromFile.openInputStream();){
            int len;
            byte[] bytearr = new byte[1024];
            while ((len = input.read(bytearr)) != -1) {
                output.write(bytearr, 0, len);
            }
        }
        catch (FileNotFoundException | SecurityException exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(DocPath resource, boolean overwrite, boolean replaceNewLine) {
        block46: {
            if (this.exists() && !overwrite) {
                return;
            }
            try {
                InputStream in = Configuration.class.getResourceAsStream(resource.getPath());
                if (in == null) {
                    return;
                }
                try (OutputStream out = this.openOutputStream();){
                    if (!replaceNewLine) {
                        int n;
                        byte[] buf = new byte[2048];
                        while ((n = in.read(buf)) > 0) {
                            out.write(buf, 0, n);
                        }
                        break block46;
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                         BufferedWriter writer = new BufferedWriter(this.configuration.docencoding == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, this.configuration.docencoding));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            writer.write(line);
                            writer.write(DocletConstants.NL);
                        }
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                throw new DocletAbortException(e);
            }
        }
    }

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean exists();

    public abstract String getName();

    public abstract String getPath();

    public abstract boolean isAbsolute();

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isSameFile(DocFile var1);

    public abstract Iterable<DocFile> list() throws IOException;

    public abstract boolean mkdirs();

    public abstract DocFile resolve(DocPath var1);

    public abstract DocFile resolve(String var1);

    public abstract DocFile resolveAgainst(JavaFileManager.Location var1);
}

