/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.transport;

import com.twitter.finagle.Dentry;
import com.twitter.finagle.Dtab;
import com.twitter.finagle.Dtab$;
import com.twitter.finagle.NameTree$;
import com.twitter.finagle.Path;
import com.twitter.finagle.Path$;
import com.twitter.finagle.mux.transport.BadMessageException;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$Init$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.mux.transport.Message$Treq$Keys$;
import com.twitter.finagle.mux.transport.Message$Types$;
import com.twitter.finagle.tracing.Flags;
import com.twitter.finagle.tracing.SpanId;
import com.twitter.finagle.tracing.SpanId$;
import com.twitter.finagle.tracing.TraceId;
import com.twitter.io.Charsets$;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.ReadOnlyChannelBuffer;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Message$ {
    public static final Message$ MODULE$;
    private final ChannelBuffer[] com$twitter$finagle$mux$transport$Message$$bufOfChar;
    public final byte[] com$twitter$finagle$mux$transport$Message$$noBytes;

    static {
        new Message$();
    }

    private ChannelBuffer mkByte(byte b) {
        return ChannelBuffers.unmodifiableBuffer((ChannelBuffer)ChannelBuffers.wrappedBuffer((byte[])new byte[]{b}));
    }

    public ChannelBuffer[] com$twitter$finagle$mux$transport$Message$$bufOfChar() {
        return this.com$twitter$finagle$mux$transport$Message$$bufOfChar;
    }

    public String decodeUtf8(ChannelBuffer buf) {
        return this.decodeUtf8(buf, buf.readableBytes());
    }

    public String decodeUtf8(ChannelBuffer buf, int n) {
        byte[] arr = new byte[n];
        buf.readBytes(arr);
        return new String(arr, Charsets$.MODULE$.Utf8());
    }

    public ChannelBuffer encodeString(String str) {
        return ChannelBuffers.wrappedBuffer((byte[])str.getBytes(Charsets$.MODULE$.Utf8()));
    }

    private Message.Treq decodeTreq(int tag, ChannelBuffer buf) {
        None$ none$;
        block19: {
            None$ none$2;
            block18: {
                block17: {
                    Some some;
                    Tuple3 tuple3;
                    if (buf.readableBytes() < 1) {
                        throw new BadMessageException("short Treq");
                    }
                    int nkeys = buf.readByte();
                    if (nkeys < 0) {
                        throw new BadMessageException("Treq: too many keys");
                    }
                    None$ trace3 = None$.MODULE$;
                    long traceFlags = 0L;
                    while (nkeys > 0) {
                        ChannelBuffer channelBuffer;
                        int vsize;
                        if (buf.readableBytes() < 2) {
                            throw new BadMessageException("short Treq (header)");
                        }
                        byte key = buf.readByte();
                        int n = buf.readByte();
                        switch (n) {
                            default: 
                        }
                        int n2 = vsize = n < 0 ? n + 256 : n;
                        if (buf.readableBytes() < vsize) {
                            throw new BadMessageException("short Treq (vsize)");
                        }
                        byte by = key;
                        if (Message$Treq$Keys$.MODULE$.TraceId() == by) {
                            if (vsize != 24) {
                                throw new BadMessageException(new StringOps(Predef$.MODULE$.augmentString("bad traceid size %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vsize)})));
                            }
                            trace3 = new Some((Object)new Tuple3((Object)SpanId$.MODULE$.apply(buf.readLong()), (Object)SpanId$.MODULE$.apply(buf.readLong()), (Object)SpanId$.MODULE$.apply(buf.readLong())));
                            channelBuffer = BoxedUnit.UNIT;
                        } else if (Message$Treq$Keys$.MODULE$.TraceFlag() == by) {
                            BoxedUnit boxedUnit;
                            Object object = vsize > 1 ? buf.readBytes(vsize - 1) : BoxedUnit.UNIT;
                            if (vsize > 0) {
                                traceFlags = buf.readByte();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            channelBuffer = boxedUnit;
                        } else {
                            channelBuffer = buf.readBytes(vsize);
                        }
                        --nkeys;
                    }
                    none$ = trace3;
                    if (!(none$ instanceof Some) || (tuple3 = (Tuple3)(some = (Some)none$).x()) == null) break block17;
                    SpanId spanId = (SpanId)tuple3._1();
                    SpanId parentId = (SpanId)tuple3._2();
                    SpanId traceId = (SpanId)tuple3._3();
                    none$2 = new Some((Object)new TraceId((Option)new Some((Object)traceId), (Option)new Some((Object)parentId), spanId, (Option)None$.MODULE$, new Flags(traceFlags)));
                    break block18;
                }
                if (!None$.MODULE$.equals(none$)) break block19;
                none$2 = None$.MODULE$;
            }
            None$ id = none$2;
            return new Message.Treq(tag, (Option<TraceId>)id, buf.slice());
        }
        throw new MatchError((Object)none$);
    }

    private Seq<Tuple2<ChannelBuffer, ChannelBuffer>> decodeContexts(ChannelBuffer buf) {
        int n = buf.readUnsignedShort();
        if (n == 0) {
            return Nil$.MODULE$;
        }
        Tuple2[] contexts = new Tuple2[n];
        for (int i = 0; i < n; ++i) {
            int nk = buf.readUnsignedShort();
            ChannelBuffer k = buf.readSlice(nk);
            int nv = buf.readUnsignedShort();
            ChannelBuffer v = buf.readSlice(nv);
            contexts[i] = new Tuple2((Object)k, (Object)v);
        }
        return Predef$.MODULE$.wrapRefArray((Object[])contexts);
    }

    private Message.Tdispatch decodeTdispatch(int tag, ChannelBuffer buf) {
        Dtab dtab;
        Seq<Tuple2<ChannelBuffer, ChannelBuffer>> contexts = this.decodeContexts(buf);
        int ndst = buf.readUnsignedShort();
        Path dst = ndst == 0 ? Path$.MODULE$.empty() : Path$.MODULE$.read(this.decodeUtf8(buf.readSlice(ndst)));
        int nd = buf.readUnsignedShort();
        if (nd == 0) {
            dtab = Dtab$.MODULE$.empty();
        } else {
            Dentry[] delegations = new Dentry[nd];
            for (int i = 0; i < nd; ++i) {
                String src = this.decodeUtf8(buf, buf.readUnsignedShort());
                String dst2 = this.decodeUtf8(buf, buf.readUnsignedShort());
                delegations[i] = new Dentry(Path$.MODULE$.read(src), NameTree$.MODULE$.read(dst2));
            }
            dtab = new Dtab((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])delegations));
        }
        Dtab dtab2 = dtab;
        return new Message.Tdispatch(tag, contexts, dst, dtab2, buf.slice());
    }

    private Message.Rdispatch decodeRdispatch(int tag, ChannelBuffer buf) {
        Message.Rdispatch rdispatch;
        byte status = buf.readByte();
        Seq<Tuple2<ChannelBuffer, ChannelBuffer>> contexts = this.decodeContexts(buf);
        byte by = status;
        switch (by) {
            default: {
                throw new BadMessageException("invalid Rdispatch status");
            }
            case 2: {
                rdispatch = new Message.RdispatchNack(tag, contexts);
                break;
            }
            case 1: {
                rdispatch = new Message.RdispatchError(tag, contexts, this.decodeUtf8(buf));
                break;
            }
            case 0: {
                rdispatch = new Message.RdispatchOk(tag, contexts, buf.slice());
            }
        }
        return rdispatch;
    }

    private Message.Rreq decodeRreq(int tag, ChannelBuffer buf) {
        Message.Rreq rreq;
        if (buf.readableBytes() < 1) {
            throw new BadMessageException("short Rreq");
        }
        byte by = buf.readByte();
        switch (by) {
            default: {
                throw new BadMessageException("invalid Rreq status");
            }
            case 2: {
                rreq = new Message.RreqNack(tag);
                break;
            }
            case 1: {
                rreq = new Message.RreqError(tag, this.decodeUtf8(buf));
                break;
            }
            case 0: {
                rreq = new Message.RreqOk(tag, buf.slice());
            }
        }
        return rreq;
    }

    private Message.Tdiscarded decodeTdiscarded(ChannelBuffer buf) {
        if (buf.readableBytes() < 3) {
            throw new BadMessageException("short Tdiscarded message");
        }
        int which = (buf.readByte() & 0xFF) << 16 | (buf.readByte() & 0xFF) << 8 | buf.readByte() & 0xFF;
        return new Message.Tdiscarded(which, this.decodeUtf8(buf));
    }

    private Message.Tlease decodeTlease(ChannelBuffer buf) {
        if (buf.readableBytes() < 9) {
            throw new BadMessageException("short Tlease message");
        }
        byte unit = buf.readByte();
        long howMuch = buf.readLong();
        return new Message.Tlease(unit, howMuch);
    }

    /*
     * WARNING - void declaration
     */
    public Message decode(ChannelBuffer buf) {
        void var4_4;
        byte by;
        block19: {
            Message message;
            block6: {
                block18: {
                    block17: {
                        int tag;
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block9: {
                                                        block7: {
                                                            Tuple2<Object, Seq<Tuple2<ChannelBuffer, ChannelBuffer>>> tuple2;
                                                            block8: {
                                                                Tuple2 tuple22;
                                                                block4: {
                                                                    Tuple2<Object, Seq<Tuple2<ChannelBuffer, ChannelBuffer>>> tuple23;
                                                                    block5: {
                                                                        Tuple2 tuple24;
                                                                        if (buf.readableBytes() < 4) {
                                                                            throw new BadMessageException("short message");
                                                                        }
                                                                        int head = buf.readInt();
                                                                        byte typ = Message$Tags$.MODULE$.extractType(head);
                                                                        tag = Message$Tags$.MODULE$.extractTag(head);
                                                                        by = typ;
                                                                        if (Message$Types$.MODULE$.Tinit() != by) break block4;
                                                                        tuple23 = Message$Init$.MODULE$.decode(buf);
                                                                        if (tuple23 == null) break block5;
                                                                        short version = BoxesRunTime.unboxToShort((Object)tuple23._1());
                                                                        Seq ctx = (Seq)tuple23._2();
                                                                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)ctx);
                                                                        short version2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                                                                        Seq ctx2 = (Seq)tuple25._2();
                                                                        message = new Message.Tinit(tag, version2, (Seq<Tuple2<ChannelBuffer, ChannelBuffer>>)ctx2);
                                                                        break block6;
                                                                    }
                                                                    throw new MatchError(tuple23);
                                                                }
                                                                if (Message$Types$.MODULE$.Rinit() != by) break block7;
                                                                tuple2 = Message$Init$.MODULE$.decode(buf);
                                                                if (tuple2 == null) break block8;
                                                                short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                                                Seq ctx = (Seq)tuple2._2();
                                                                Tuple2 tuple26 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)ctx);
                                                                short version3 = BoxesRunTime.unboxToShort((Object)tuple26._1());
                                                                Seq ctx3 = (Seq)tuple26._2();
                                                                message = new Message.Rinit(tag, version3, (Seq<Tuple2<ChannelBuffer, ChannelBuffer>>)ctx3);
                                                                break block6;
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        if (Message$Types$.MODULE$.Treq() != by) break block9;
                                                        message = this.decodeTreq(tag, buf);
                                                        break block6;
                                                    }
                                                    if (Message$Types$.MODULE$.Rreq() != by) break block10;
                                                    message = this.decodeRreq(tag, buf);
                                                    break block6;
                                                }
                                                if (Message$Types$.MODULE$.Tdispatch() != by) break block11;
                                                message = this.decodeTdispatch(tag, buf);
                                                break block6;
                                            }
                                            if (Message$Types$.MODULE$.Rdispatch() != by) break block12;
                                            message = this.decodeRdispatch(tag, buf);
                                            break block6;
                                        }
                                        if (Message$Types$.MODULE$.Tdrain() != by) break block13;
                                        message = new Message.Tdrain(tag);
                                        break block6;
                                    }
                                    if (Message$Types$.MODULE$.Rdrain() != by) break block14;
                                    message = new Message.Rdrain(tag);
                                    break block6;
                                }
                                if (Message$Types$.MODULE$.Tping() != by) break block15;
                                message = new Message.Tping(tag);
                                break block6;
                            }
                            if (Message$Types$.MODULE$.Rping() != by) break block16;
                            message = new Message.Rping(tag);
                            break block6;
                        }
                        boolean bl = Message$Types$.MODULE$.Rerr() == by ? true : Message$Types$.MODULE$.BAD_Rerr() == by;
                        if (!bl) break block17;
                        message = new Message.Rerr(tag, this.decodeUtf8(buf));
                        break block6;
                    }
                    boolean bl = Message$Types$.MODULE$.Tdiscarded() == by ? true : Message$Types$.MODULE$.BAD_Tdiscarded() == by;
                    if (!bl) break block18;
                    message = this.decodeTdiscarded(buf);
                    break block6;
                }
                if (Message$Types$.MODULE$.Tlease() != by) break block19;
                message = this.decodeTlease(buf);
            }
            return message;
        }
        throw new BadMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unknown message type: ", " [tag=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by), BoxesRunTime.boxToInteger((int)var4_4)})));
    }

    public ChannelBuffer encode(Message msg) {
        Message message;
        block6: {
            ReadOnlyChannelBuffer readOnlyChannelBuffer;
            block5: {
                block4: {
                    message = msg;
                    if (!(message instanceof Message.PreEncodedTping)) break block4;
                    Message.PreEncodedTping preEncodedTping = (Message.PreEncodedTping)message;
                    readOnlyChannelBuffer = preEncodedTping.buf();
                    break block5;
                }
                if (message == null) break block6;
                Message message2 = message;
                if (message2.tag() < Message$Tags$.MODULE$.MarkerTag() || (message2.tag() & ~Message$Tags$.MODULE$.TagMSB()) > Message$Tags$.MODULE$.MaxTag()) {
                    throw new BadMessageException(new StringOps(Predef$.MODULE$.augmentString("invalid tag number %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)message2.tag())})));
                }
                byte[] head = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{message2.typ(), (byte)(message2.tag() >> 16 & 0xFF), (byte)(message2.tag() >> 8 & 0xFF), (byte)(message2.tag() & 0xFF)}), ClassTag$.MODULE$.Byte());
                readOnlyChannelBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{ChannelBuffers.wrappedBuffer((byte[])head), message2.buf()});
            }
            return readOnlyChannelBuffer;
        }
        throw new MatchError((Object)message);
    }

    private Message$() {
        MODULE$ = this;
        this.com$twitter$finagle$mux$transport$Message$$bufOfChar = (ChannelBuffer[])((Object[])new ChannelBuffer[]{this.mkByte((byte)0), this.mkByte((byte)1), this.mkByte((byte)2)});
        this.com$twitter$finagle$mux$transport$Message$$noBytes = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

