/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.stats.NullStatsReceiver;
import com.twitter.finagle.stats.NullStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.routing.RoutingUtils;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.service.DistributedLogServer;
import org.apache.distributedlog.util.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLogServerApp {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLogServerApp.class);
    private static final String USAGE = "DistributedLogServerApp [-u <uri>] [-c <conf>]";
    private final String[] args;
    private final Options options = new Options();

    private DistributedLogServerApp(String[] args) {
        this.args = args;
        this.options.addOption("u", "uri", true, "DistributedLog URI");
        this.options.addOption("c", "conf", true, "DistributedLog Configuration File");
        this.options.addOption("sc", "stream-conf", true, "Per Stream Configuration Directory");
        this.options.addOption("p", "port", true, "DistributedLog Server Port");
        this.options.addOption("sp", "stats-port", true, "DistributedLog Stats Port");
        this.options.addOption("pd", "stats-provider", true, "DistributedLog Stats Provider");
        this.options.addOption("si", "shard-id", true, "DistributedLog Shard ID");
        this.options.addOption("a", "announce", false, "ServerSet Path to Announce");
        this.options.addOption("la", "load-appraiser", true, "LoadAppraiser Implementation to Use");
        this.options.addOption("mx", "thriftmux", false, "Is thriftmux enabled");
    }

    private void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(USAGE, this.options);
    }

    private void run() {
        try {
            logger.info("Running distributedlog server : args = {}", (Object)Arrays.toString(this.args));
            BasicParser parser = new BasicParser();
            CommandLine cmdline = parser.parse(this.options, this.args);
            this.runCmd(cmdline);
        }
        catch (ParseException pe) {
            logger.error("Argument error : {}", (Object)pe.getMessage());
            this.printUsage();
            Runtime.getRuntime().exit(-1);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Argument error : {}", (Object)iae.getMessage());
            this.printUsage();
            Runtime.getRuntime().exit(-1);
        }
        catch (ConfigurationException ce) {
            logger.error("Configuration error : {}", (Object)ce.getMessage());
            this.printUsage();
            Runtime.getRuntime().exit(-1);
        }
        catch (IOException ie) {
            logger.error("Failed to start distributedlog server : ", (Throwable)ie);
            Runtime.getRuntime().exit(-1);
        }
        catch (ClassNotFoundException cnf) {
            logger.error("Failed to start distributedlog server : ", (Throwable)cnf);
            Runtime.getRuntime().exit(-1);
        }
    }

    private void runCmd(CommandLine cmdline) throws IllegalArgumentException, IOException, ConfigurationException, ClassNotFoundException {
        NullStatsReceiver$ statsReceiver = NullStatsReceiver.get();
        Optional confOptional = CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"c");
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        if (confOptional.isPresent()) {
            String configFile = (String)confOptional.get();
            try {
                dlConf.loadConf(new File(configFile).toURI().toURL());
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException("Failed to load distributedlog configuration from " + configFile + ".");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to load distributedlog configuration from malformed " + configFile + ".");
            }
        }
        final StatsProvider statsProvider = (StatsProvider)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"pd").transform((Function)new Function<String, StatsProvider>(){

            @Nullable
            public StatsProvider apply(@Nullable String name) {
                return (StatsProvider)ReflectionUtils.newInstance((String)name, StatsProvider.class);
            }
        }).or((Object)new NullStatsProvider());
        Optional uriOption = CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"u");
        Preconditions.checkArgument((boolean)uriOption.isPresent(), (Object)"No distributedlog uri provided.");
        URI dlUri = URI.create((String)uriOption.get());
        DLZkServerSet serverSet = DLZkServerSet.of((URI)dlUri, (int)((int)TimeUnit.SECONDS.toMillis(60L)));
        RoutingService routingService = RoutingUtils.buildRoutingService((ServerSet)serverSet.getServerSet()).statsReceiver(statsReceiver.scope("routing")).build();
        final DistributedLogServer server = DistributedLogServer.runServer((Optional<String>)uriOption, (Optional<String>)confOptional, (Optional<String>)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"sc"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"p"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"sp"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"si"), (Optional<Boolean>)CommandLineUtils.getOptionalBooleanArg((CommandLine)cmdline, (String)"a"), (Optional<String>)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"la"), (Optional<Boolean>)CommandLineUtils.getOptionalBooleanArg((CommandLine)cmdline, (String)"mx"), routingService, (StatsReceiver)statsReceiver, statsProvider);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Closing DistributedLog Server.");
                server.close();
                logger.info("Closed DistributedLog Server.");
                statsProvider.stop();
            }
        });
        try {
            server.join();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted when waiting distributedlog server to be finished : ", (Throwable)e);
        }
        logger.info("DistributedLog Service Interrupted.");
        server.close();
        logger.info("Closed DistributedLog Server.");
        statsProvider.stop();
    }

    public static void main(String[] args) {
        DistributedLogServerApp launcher = new DistributedLogServerApp(args);
        launcher.run();
    }
}

