/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieLedgerIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(BookieLedgerIndexer.class);
    private final LedgerManager ledgerManager;

    public BookieLedgerIndexer(LedgerManager ledgerManager) {
        this.ledgerManager = ledgerManager;
    }

    public Map<String, Set<Long>> getBookieToLedgerIndex() throws ReplicationException.BKAuditException {
        final ConcurrentHashMap<String, Set<Long>> bookie2ledgersMap = new ConcurrentHashMap<String, Set<Long>>();
        final CountDownLatch ledgerCollectorLatch = new CountDownLatch(1);
        BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(final Long ledgerId, final AsyncCallback.VoidCallback iterCallback) {
                BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> genericCallback = new BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata>(){

                    @Override
                    public void operationComplete(int rc, LedgerMetadata ledgerMetadata) {
                        if (rc == 0) {
                            for (Map.Entry<Long, ArrayList<BookieSocketAddress>> ensemble : ledgerMetadata.getEnsembles().entrySet()) {
                                for (BookieSocketAddress bookie : ensemble.getValue()) {
                                    BookieLedgerIndexer.this.putLedger(bookie2ledgersMap, bookie.toString(), ledgerId);
                                }
                            }
                        } else if (rc == -7) {
                            LOG.info("Ignoring replication of already deleted ledger {}", (Object)ledgerId);
                            rc = 0;
                        } else {
                            LOG.warn("Unable to read the ledger:" + ledgerId + " information");
                        }
                        iterCallback.processResult(rc, null, null);
                    }
                };
                BookieLedgerIndexer.this.ledgerManager.readLedgerMetadata(ledgerId, genericCallback);
            }
        };
        final ArrayList resultCode = new ArrayList(1);
        this.ledgerManager.asyncProcessLedgers(ledgerProcessor, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String s, Object obj) {
                resultCode.add(rc);
                ledgerCollectorLatch.countDown();
            }
        }, null, 0, -1);
        try {
            ledgerCollectorLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReplicationException.BKAuditException("Exception while getting the bookie-ledgers", e);
        }
        if (!resultCode.contains(0)) {
            throw new ReplicationException.BKAuditException("Exception while getting the bookie-ledgers", BKException.create((Integer)resultCode.get(0)));
        }
        return bookie2ledgersMap;
    }

    private void putLedger(ConcurrentHashMap<String, Set<Long>> bookie2ledgersMap, String bookie, long ledgerId) {
        Set<Long> oldLedgers;
        Set<Long> ledgers = bookie2ledgersMap.get(bookie);
        if (ledgers == null && (oldLedgers = bookie2ledgersMap.putIfAbsent(bookie, ledgers = Collections.synchronizedSet(new HashSet()))) != null) {
            ledgers = oldLedgers;
        }
        ledgers.add(ledgerId);
    }
}

