/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.AclParser;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.CliException;
import org.apache.zookeeper.cli.CliParseException;
import org.apache.zookeeper.cli.CliWrapperException;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class SetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetAclCommand() {
        super("setAcl", "[-s] [-v version] path acl");
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        String aclStr = this.args[2];
        List<ACL> acl = AclParser.parse(aclStr);
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            Stat stat = this.zk.setACL(path, acl, version);
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

