/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractHierarchicalLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyHierarchicalLedgerManager
extends AbstractHierarchicalLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(LegacyHierarchicalLedgerManager.class);
    static final String IDGEN_ZNODE = "idgen";
    private static final String MAX_ID_SUFFIX = "9999";
    private static final String MIN_ID_SUFFIX = "0000";
    private static final ThreadLocal<StringBuilder> threadLocalNodeBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public LegacyHierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        return this.ledgerRootPath + StringUtils.getShortHierarchicalLedgerPath(ledgerId);
    }

    @Override
    public long getLedgerId(String pathName) throws IOException {
        if (!pathName.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + pathName);
        }
        String hierarchicalPath = pathName.substring(this.ledgerRootPath.length() + 1);
        return StringUtils.stringToHierarchicalLedgerId(hierarchicalPath);
    }

    private long getStartLedgerIdByLevel(String level1, String level2) throws IOException {
        return this.getLedgerId(level1, level2, MIN_ID_SUFFIX);
    }

    private long getEndLedgerIdByLevel(String level1, String level2) throws IOException {
        return this.getLedgerId(level1, level2, MAX_ID_SUFFIX);
    }

    @Override
    public void asyncProcessLedgers(final BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, new BookkeeperInternalCallbacks.Processor<String>(){

            @Override
            public void process(final String l1Node, AsyncCallback.VoidCallback cb1) {
                if (LegacyHierarchicalLedgerManager.isSpecialZnode(l1Node)) {
                    cb1.processResult(successRc, null, context);
                    return;
                }
                String l1NodePath = LegacyHierarchicalLedgerManager.this.ledgerRootPath + "/" + l1Node;
                LegacyHierarchicalLedgerManager.this.asyncProcessLevelNodes(l1NodePath, new BookkeeperInternalCallbacks.Processor<String>(){

                    @Override
                    public void process(String l2Node, AsyncCallback.VoidCallback cb2) {
                        String l2NodePath = LegacyHierarchicalLedgerManager.this.ledgerRootPath + "/" + l1Node + "/" + l2Node;
                        LegacyHierarchicalLedgerManager.this.asyncProcessLedgersInSingleNode(l2NodePath, processor, cb2, context, successRc, failureRc);
                    }
                }, cb1, context, successRc, failureRc);
            }
        }, finalCb, context, successRc, failureRc);
    }

    protected static boolean isSpecialZnode(String znode) {
        return IDGEN_ZNODE.equals(znode) || "idgen-long".equals(znode) || AbstractHierarchicalLedgerManager.isSpecialZnode(znode);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges() {
        return new HierarchicalLedgerRangeIterator();
    }

    private class HierarchicalLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        private Iterator<String> l1NodesIter = null;
        private Iterator<String> l2NodesIter = null;
        private String curL1Nodes = "";
        private boolean iteratorDone = false;
        private LedgerManager.LedgerRange nextRange = null;

        private HierarchicalLedgerRangeIterator() {
        }

        private boolean nextL1Node() throws KeeperException, InterruptedException {
            this.l2NodesIter = null;
            while (this.l2NodesIter == null) {
                if (!this.l1NodesIter.hasNext()) {
                    return false;
                }
                this.curL1Nodes = this.l1NodesIter.next();
                if (LegacyHierarchicalLedgerManager.isSpecialZnode(this.curL1Nodes) || this.curL1Nodes.length() > 2) continue;
                List l2Nodes = LegacyHierarchicalLedgerManager.this.zk.getChildren(LegacyHierarchicalLedgerManager.this.ledgerRootPath + "/" + this.curL1Nodes, null);
                Collections.sort(l2Nodes);
                this.l2NodesIter = l2Nodes.iterator();
                if (this.l2NodesIter.hasNext()) continue;
                this.l2NodesIter = null;
            }
            return true;
        }

        private synchronized void preload() throws IOException {
            while (this.nextRange == null && !this.iteratorDone) {
                boolean hasMoreElements = false;
                try {
                    if (this.l1NodesIter == null) {
                        List l1Nodes = LegacyHierarchicalLedgerManager.this.zk.getChildren(LegacyHierarchicalLedgerManager.this.ledgerRootPath, null);
                        Collections.sort(l1Nodes);
                        this.l1NodesIter = l1Nodes.iterator();
                        hasMoreElements = this.nextL1Node();
                    } else {
                        hasMoreElements = this.l2NodesIter == null || !this.l2NodesIter.hasNext() ? this.nextL1Node() : true;
                    }
                }
                catch (KeeperException ke) {
                    throw new IOException("Error preloading next range", ke);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while preloading", ie);
                }
                if (hasMoreElements) {
                    this.nextRange = this.getLedgerRangeByLevel(this.curL1Nodes, this.l2NodesIter.next());
                    if (this.nextRange.size() != 0) continue;
                    this.nextRange = null;
                    continue;
                }
                this.iteratorDone = true;
            }
        }

        @Override
        public synchronized boolean hasNext() throws IOException {
            this.preload();
            return this.nextRange != null && !this.iteratorDone;
        }

        @Override
        public synchronized LedgerManager.LedgerRange next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LedgerManager.LedgerRange r = this.nextRange;
            this.nextRange = null;
            return r;
        }

        LedgerManager.LedgerRange getLedgerRangeByLevel(String level1, String level2) throws IOException {
            StringBuilder nodeBuilder = (StringBuilder)threadLocalNodeBuilder.get();
            nodeBuilder.setLength(0);
            nodeBuilder.append(LegacyHierarchicalLedgerManager.this.ledgerRootPath).append("/").append(level1).append("/").append(level2);
            String nodePath = nodeBuilder.toString();
            List<String> ledgerNodes = null;
            try {
                ledgerNodes = ZkUtils.getChildrenInSingleNode(LegacyHierarchicalLedgerManager.this.zk, nodePath);
            }
            catch (InterruptedException e) {
                throw new IOException("Error when get child nodes from zk", e);
            }
            NavigableSet<Long> zkActiveLedgers = LegacyHierarchicalLedgerManager.this.ledgerListToSet(ledgerNodes, nodePath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("All active ledgers from ZK for hash node " + level1 + "/" + level2 + " : " + zkActiveLedgers);
            }
            return new LedgerManager.LedgerRange(zkActiveLedgers.subSet(LegacyHierarchicalLedgerManager.this.getStartLedgerIdByLevel(level1, level2), true, LegacyHierarchicalLedgerManager.this.getEndLedgerIdByLevel(level1, level2), true));
        }
    }
}

