/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import bk-shade.com.google.common.base.Preconditions;
import bk-shade.com.google.common.util.concurrent.ListenableFuture;
import bk-shade.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import bk-shade.com.google.common.util.concurrent.MoreExecutors;
import bk-shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedSafeExecutor {
    static final long WARN_TIME_MICRO_SEC_DEFAULT = TimeUnit.SECONDS.toMicros(1L);
    final String name;
    final ListeningScheduledExecutorService[] threads;
    final long[] threadIds;
    final Random rand = new Random();
    final OpStatsLogger taskExecutionStats;
    final OpStatsLogger taskPendingStats;
    final boolean traceTaskExecution;
    final long warnTimeMicroSec;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public OrderedSafeExecutor(int numThreads, String threadName) {
        this(threadName, numThreads, Executors.defaultThreadFactory(), (StatsLogger)NullStatsLogger.INSTANCE, false, WARN_TIME_MICRO_SEC_DEFAULT);
    }

    private OrderedSafeExecutor(String baseName, int numThreads, ThreadFactory threadFactory, StatsLogger statsLogger, boolean traceTaskExecution, long warnTimeMicroSec) {
        Preconditions.checkArgument(numThreads > 0);
        Preconditions.checkArgument(!StringUtils.isBlank((String)baseName));
        this.warnTimeMicroSec = warnTimeMicroSec;
        this.name = baseName;
        this.threads = new ListeningScheduledExecutorService[numThreads];
        this.threadIds = new long[numThreads];
        int i = 0;
        while (i < numThreads) {
            final ScheduledThreadPoolExecutor thread = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat(this.name + "-orderedsafeexecutor-" + i + "-%d").setThreadFactory(threadFactory).build());
            this.threads[i] = MoreExecutors.listeningDecorator(thread);
            final int idx = i++;
            try {
                this.threads[idx].submit(new SafeRunnable(){

                    @Override
                    public void safeRun() {
                        OrderedSafeExecutor.this.threadIds[idx] = Thread.currentThread().getId();
                    }
                }).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Couldn't start thread " + i, e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Couldn't start thread " + i, e);
            }
            statsLogger.registerGauge(String.format("%s-queue-%d", this.name, idx), (Gauge)new Gauge<Number>(){

                public Number getDefaultValue() {
                    return 0;
                }

                public Number getSample() {
                    return thread.getQueue().size();
                }
            });
            statsLogger.registerGauge(String.format("%s-completed-tasks-%d", this.name, idx), (Gauge)new Gauge<Number>(){

                public Number getDefaultValue() {
                    return 0;
                }

                public Number getSample() {
                    return thread.getCompletedTaskCount();
                }
            });
            statsLogger.registerGauge(String.format("%s-total-tasks-%d", this.name, idx), (Gauge)new Gauge<Number>(){

                public Number getDefaultValue() {
                    return 0;
                }

                public Number getSample() {
                    return thread.getTaskCount();
                }
            });
        }
        this.taskExecutionStats = statsLogger.scope(this.name).getOpStatsLogger("task_execution");
        this.taskPendingStats = statsLogger.scope(this.name).getOpStatsLogger("task_queued");
        this.traceTaskExecution = traceTaskExecution;
    }

    public ListeningScheduledExecutorService chooseThread() {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[this.rand.nextInt(this.threads.length)];
    }

    public ListeningScheduledExecutorService chooseThread(Object orderingKey) {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[MathUtils.signSafeMod(orderingKey.hashCode(), this.threads.length)];
    }

    public ListeningScheduledExecutorService chooseThread(long orderingKey) {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[MathUtils.signSafeMod(orderingKey, this.threads.length)];
    }

    private SafeRunnable timedRunnable(SafeRunnable r) {
        if (this.traceTaskExecution) {
            return new TimedRunnable(r);
        }
        return r;
    }

    public void submit(SafeRunnable r) {
        this.chooseThread().submit(this.timedRunnable(r));
    }

    public ListenableFuture<?> submitOrdered(Object orderingKey, SafeRunnable r) {
        return this.chooseThread(orderingKey).submit(this.timedRunnable(r));
    }

    public void submitOrdered(long orderingKey, SafeRunnable r) {
        this.chooseThread(orderingKey).execute(r);
    }

    public void submitOrdered(int orderingKey, SafeRunnable r) {
        this.chooseThread(orderingKey).execute(r);
    }

    public <T> ListenableFuture<T> submitOrdered(Object orderingKey, Callable<T> callable) {
        return this.chooseThread(orderingKey).submit(callable);
    }

    public ScheduledFuture<?> schedule(SafeRunnable command, long delay, TimeUnit unit) {
        return this.chooseThread().schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleOrdered(Object orderingKey, SafeRunnable command, long delay, TimeUnit unit) {
        return this.chooseThread(orderingKey).schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(SafeRunnable command, long initialDelay, long period, TimeUnit unit) {
        return this.chooseThread().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRateOrdered(Object orderingKey, SafeRunnable command, long initialDelay, long period, TimeUnit unit) {
        return this.chooseThread(orderingKey).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(SafeRunnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.chooseThread().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelayOrdered(Object orderingKey, SafeRunnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.chooseThread(orderingKey).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private long getThreadID(long orderingKey) {
        if (this.threadIds.length == 1) {
            return this.threadIds[0];
        }
        return this.threadIds[MathUtils.signSafeMod(orderingKey, this.threadIds.length)];
    }

    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].shutdown();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = true;
        for (int i = 0; i < this.threads.length; ++i) {
            ret = ret && this.threads[i].awaitTermination(timeout, unit);
        }
        return ret;
    }

    public void forceShutdown(long timeout, TimeUnit unit) {
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                if (this.threads[i].awaitTermination(timeout, unit)) continue;
                this.threads[i].shutdownNow();
                continue;
            }
            catch (InterruptedException exception) {
                this.threads[i].shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static abstract class OrderedSafeGenericCallback<T>
    implements BookkeeperInternalCallbacks.GenericCallback<T> {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedSafeGenericCallback.class);
        private final OrderedSafeExecutor executor;
        private final long orderingKey;

        public OrderedSafeGenericCallback(OrderedSafeExecutor executor, long orderingKey) {
            this.executor = executor;
            this.orderingKey = orderingKey;
        }

        @Override
        public final void operationComplete(final int rc, final T result) {
            if (Thread.currentThread().getId() == this.executor.getThreadID(this.orderingKey)) {
                this.safeOperationComplete(rc, result);
            } else {
                try {
                    this.executor.submitOrdered(this.orderingKey, new SafeRunnable(){

                        @Override
                        public void safeRun() {
                            this.safeOperationComplete(rc, result);
                        }

                        public String toString() {
                            return String.format("Callback(key=%s, name=%s)", orderingKey, this);
                        }
                    });
                }
                catch (RejectedExecutionException re) {
                    LOG.warn("Failed to submit callback for {} : ", (Object)this.orderingKey, (Object)re);
                }
            }
        }

        public abstract void safeOperationComplete(int var1, T var2);
    }

    private class TimedRunnable
    extends SafeRunnable {
        final SafeRunnable runnable;
        final long initNanos;

        TimedRunnable(SafeRunnable runnable) {
            this.runnable = runnable;
            this.initNanos = MathUtils.nowInNano();
        }

        @Override
        public void safeRun() {
            OrderedSafeExecutor.this.taskPendingStats.registerSuccessfulEvent(this.initNanos, TimeUnit.NANOSECONDS);
            long startNanos = MathUtils.nowInNano();
            this.runnable.safeRun();
            long elapsedMicroSec = MathUtils.elapsedMicroSec(startNanos);
            OrderedSafeExecutor.this.taskExecutionStats.registerSuccessfulEvent(elapsedMicroSec, TimeUnit.MICROSECONDS);
            if (elapsedMicroSec >= OrderedSafeExecutor.this.warnTimeMicroSec) {
                logger.warn("Runnable {}:{} took too long {} micros to execute.", new Object[]{this.runnable, this.runnable.getClass(), elapsedMicroSec});
            }
        }
    }

    public static class Builder {
        private String name = "OrderedSafeExecutor";
        private int numThreads = Runtime.getRuntime().availableProcessors();
        private ThreadFactory threadFactory = null;
        private StatsLogger statsLogger = NullStatsLogger.INSTANCE;
        private boolean traceTaskExecution = false;
        private long warnTimeMicroSec = WARN_TIME_MICRO_SEC_DEFAULT;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder numThreads(int num) {
            this.numThreads = num;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder statsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public Builder traceTaskExecution(boolean enabled) {
            this.traceTaskExecution = enabled;
            return this;
        }

        public Builder traceTaskWarnTimeMicroSec(long warnTimeMicroSec) {
            this.warnTimeMicroSec = warnTimeMicroSec;
            return this;
        }

        public OrderedSafeExecutor build() {
            if (null == this.threadFactory) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            return new OrderedSafeExecutor(this.name, this.numThreads, this.threadFactory, this.statsLogger, this.traceTaskExecution, this.warnTimeMicroSec);
        }
    }
}

