/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tls;

import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityProviderFactoryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityProviderFactoryFactory.class);

    public static SecurityHandlerFactory getSecurityProviderFactory(String securityHandler) throws SecurityException {
        if (securityHandler == null || securityHandler.equals("")) {
            return null;
        }
        ClassLoader classLoader = SecurityProviderFactoryFactory.class.getClassLoader();
        SecurityHandlerFactory shFactory = null;
        try {
            Class<?> shFactoryClass = classLoader.loadClass(securityHandler);
            shFactory = (SecurityHandlerFactory)shFactoryClass.newInstance();
            LOG.info("Loaded security handler for {}", (Object)securityHandler);
        }
        catch (Exception e) {
            LOG.error("Unable to load security handler for {}: ", (Object)securityHandler, (Object)e);
            throw new SecurityException(e);
        }
        return shFactory;
    }
}

