/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream.admin;

import com.google.common.base.Stopwatch;
import com.twitter.util.Future;
import com.twitter.util.FutureTransformer;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.distributedlog.exceptions.ChecksumFailedException;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.protocol.util.ProtocolUtils;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.admin.AdminOp;
import org.apache.distributedlog.thrift.service.WriteResponse;

public abstract class StreamAdminOp
implements AdminOp<WriteResponse> {
    protected final String stream;
    protected final StreamManager streamManager;
    protected final OpStatsLogger opStatsLogger;
    protected final Stopwatch stopwatch = Stopwatch.createUnstarted();
    protected final Long checksum;
    protected final Feature checksumDisabledFeature;

    protected StreamAdminOp(String stream, StreamManager streamManager, OpStatsLogger statsLogger, Long checksum, Feature checksumDisabledFeature) {
        this.stream = stream;
        this.streamManager = streamManager;
        this.opStatsLogger = statsLogger;
        this.stopwatch.reset().start();
        this.checksum = checksum;
        this.checksumDisabledFeature = checksumDisabledFeature;
    }

    protected Long computeChecksum() {
        return ProtocolUtils.streamOpCRC32((String)this.stream);
    }

    @Override
    public void preExecute() throws DLException {
        Long serverChecksum;
        if (!this.checksumDisabledFeature.isAvailable() && null != this.checksum && null != (serverChecksum = this.computeChecksum()) && !this.checksum.equals(serverChecksum)) {
            throw new ChecksumFailedException();
        }
    }

    protected abstract Future<WriteResponse> executeOp();

    @Override
    public Future<WriteResponse> execute() {
        return this.executeOp().transformedBy((FutureTransformer)new FutureTransformer<WriteResponse, WriteResponse>(){

            public WriteResponse map(WriteResponse response) {
                StreamAdminOp.this.opStatsLogger.registerSuccessfulEvent(StreamAdminOp.this.stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                return response;
            }

            public WriteResponse handle(Throwable cause) {
                StreamAdminOp.this.opStatsLogger.registerFailedEvent(StreamAdminOp.this.stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                return ResponseUtils.write(ResponseUtils.exceptionToHeader(cause));
            }
        });
    }
}

