/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509AuthenticationProvider
implements AuthenticationProvider {
    static final String ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER = "zookeeper.X509AuthenticationProvider.superUser";
    private static final Logger LOG = LoggerFactory.getLogger(X509AuthenticationProvider.class);
    private final X509TrustManager trustManager;
    private final X509KeyManager keyManager;

    public X509AuthenticationProvider() {
        String keyStoreLocationProp = System.getProperty("zookeeper.ssl.keyStore.location");
        String keyStorePasswordProp = System.getProperty("zookeeper.ssl.keyStore.password");
        X509KeyManager km = null;
        X509TrustManager tm = null;
        try {
            km = X509Util.createKeyManager(keyStoreLocationProp, keyStorePasswordProp);
        }
        catch (X509Exception.KeyManagerException e) {
            LOG.error("Failed to create key manager", (Throwable)e);
        }
        String trustStoreLocationProp = System.getProperty("zookeeper.ssl.trustStore.location");
        String trustStorePasswordProp = System.getProperty("zookeeper.ssl.trustStore.password");
        try {
            tm = X509Util.createTrustManager(trustStoreLocationProp, trustStorePasswordProp);
        }
        catch (X509Exception.TrustManagerException e) {
            LOG.error("Failed to create trust manager", (Throwable)e);
        }
        this.keyManager = km;
        this.trustManager = tm;
    }

    public X509AuthenticationProvider(X509TrustManager trustManager, X509KeyManager keyManager) {
        this.trustManager = trustManager;
        this.keyManager = keyManager;
    }

    @Override
    public String getScheme() {
        return "x509";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        X509Certificate[] certChain = (X509Certificate[])cnxn.getClientCertificateChain();
        if (certChain == null || certChain.length == 0) {
            return KeeperException.Code.AUTHFAILED;
        }
        if (this.trustManager == null) {
            LOG.error("No trust manager available to authenticate session 0x{}", (Object)Long.toHexString(cnxn.getSessionId()));
            return KeeperException.Code.AUTHFAILED;
        }
        X509Certificate clientCert = certChain[0];
        try {
            this.trustManager.checkClientTrusted(certChain, clientCert.getPublicKey().getAlgorithm());
        }
        catch (CertificateException ce) {
            LOG.error("Failed to trust certificate for session 0x" + Long.toHexString(cnxn.getSessionId()), (Throwable)ce);
            return KeeperException.Code.AUTHFAILED;
        }
        String clientId = this.getClientId(clientCert);
        if (clientId.equals(System.getProperty(ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER))) {
            cnxn.addAuthInfo(new Id("super", clientId));
            LOG.info("Authenticated Id '{}' as super user", (Object)clientId);
        }
        Id authInfo = new Id(this.getScheme(), clientId);
        cnxn.addAuthInfo(authInfo);
        LOG.info("Authenticated Id '{}' for Scheme '{}'", (Object)authInfo.getId(), (Object)authInfo.getScheme());
        return KeeperException.Code.OK;
    }

    protected String getClientId(X509Certificate clientCert) {
        return clientCert.getSubjectX500Principal().getName();
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        if (System.getProperty(ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER) != null) {
            return id.equals(System.getProperty(ZOOKEEPER_X509AUTHENTICATIONPROVIDER_SUPERUSER)) || id.equals(aclExpr);
        }
        return id.equals(aclExpr);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        try {
            new X500Principal(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public X509TrustManager getTrustManager() throws X509Exception.TrustManagerException {
        if (this.trustManager == null) {
            throw new X509Exception.TrustManagerException("No trust manager available");
        }
        return this.trustManager;
    }

    public X509KeyManager getKeyManager() throws X509Exception.KeyManagerException {
        if (this.keyManager == null) {
            throw new X509Exception.KeyManagerException("No key manager available");
        }
        return this.keyManager;
    }
}

