/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.twitter.finagle.NoBrokersAvailableException;
import com.twitter.finagle.stats.StatsReceiver;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.distributedlog.client.routing.RoutingService;

public class SingleHostRoutingService
implements RoutingService {
    private SocketAddress address;
    private final CopyOnWriteArraySet<RoutingService.RoutingListener> listeners = new CopyOnWriteArraySet();

    public static SingleHostRoutingService of(SocketAddress address) {
        return new SingleHostRoutingService(address);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    SingleHostRoutingService(SocketAddress address) {
        this.address = address;
    }

    public void setAddress(SocketAddress address) {
        this.address = address;
    }

    @Override
    public Set<SocketAddress> getHosts() {
        return Sets.newHashSet((Object[])new SocketAddress[]{this.address});
    }

    @Override
    public void startService() {
        for (RoutingService.RoutingListener listener : this.listeners) {
            listener.onServerJoin(this.address);
        }
    }

    @Override
    public void stopService() {
    }

    @Override
    public RoutingService registerListener(RoutingService.RoutingListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public RoutingService unregisterListener(RoutingService.RoutingListener listener) {
        this.listeners.remove(listener);
        return null;
    }

    @Override
    public SocketAddress getHost(String key, RoutingService.RoutingContext rContext) throws NoBrokersAvailableException {
        if (rContext.isTriedHost(this.address)) {
            throw new NoBrokersAvailableException("No hosts is available : routing context = " + rContext);
        }
        return this.address;
    }

    @Override
    public void removeHost(SocketAddress address, Throwable reason) {
    }

    public static class Builder
    implements RoutingService.Builder {
        private SocketAddress address;

        private Builder() {
        }

        public Builder address(SocketAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public RoutingService.Builder statsReceiver(StatsReceiver statsReceiver) {
            return this;
        }

        @Override
        public RoutingService build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"Host is null");
            return new SingleHostRoutingService(this.address);
        }
    }
}

