/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.application;

import com.google.inject.Inject;
import com.twitter.common.application.ShutdownStage;
import com.twitter.common.base.Command;
import java.util.logging.Logger;

public class Lifecycle {
    private static final Logger LOG = Logger.getLogger(Lifecycle.class.getName());
    private final Object waitMonitor = new Object();
    private boolean destroyed = false;
    private final Command shutdownRegistry;

    @Inject
    public Lifecycle(@ShutdownStage Command shutdownRegistry, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.shutdownRegistry = shutdownRegistry;
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.waitMonitor;
        synchronized (object) {
            return !this.destroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitShutdown() {
        LOG.info("Awaiting shutdown");
        Object object = this.waitMonitor;
        synchronized (object) {
            while (!this.destroyed) {
                try {
                    this.waitMonitor.wait();
                }
                catch (InterruptedException e) {
                    LOG.info("Exiting on interrupt");
                    this.shutdown();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Object object = this.waitMonitor;
        synchronized (object) {
            if (!this.destroyed) {
                this.destroyed = true;
                LOG.info("Shutting down application");
                this.shutdownRegistry.execute();
                this.waitMonitor.notifyAll();
            }
        }
    }
}

