/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream.limiter;

import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.common.rate.MovingAverageRate;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.ChainedRequestLimiter;
import org.apache.distributedlog.limiter.ComposableRequestLimiter;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.StreamOp;
import org.apache.distributedlog.service.stream.limiter.DynamicRequestLimiter;
import org.apache.distributedlog.service.stream.limiter.RequestLimiterBuilder;
import org.apache.distributedlog.service.stream.limiter.StreamAcquireLimiter;

public class ServiceRequestLimiter
extends DynamicRequestLimiter<StreamOp> {
    private final StatsLogger limiterStatLogger;
    private final MovingAverageRate serviceRps;
    private final MovingAverageRate serviceBps;
    private final StreamManager streamManager;

    public ServiceRequestLimiter(DynamicDistributedLogConfiguration dynConf, StatsLogger statsLogger, MovingAverageRate serviceRps, MovingAverageRate serviceBps, StreamManager streamManager, Feature disabledFeature) {
        super(dynConf, statsLogger, disabledFeature);
        this.limiterStatLogger = statsLogger;
        this.streamManager = streamManager;
        this.serviceRps = serviceRps;
        this.serviceBps = serviceBps;
        this.limiter = this.build();
    }

    @Override
    public RequestLimiter<StreamOp> build() {
        int rpsStreamAcquireLimit = this.dynConf.getRpsStreamAcquireServiceLimit();
        int rpsSoftServiceLimit = this.dynConf.getRpsSoftServiceLimit();
        int rpsHardServiceLimit = this.dynConf.getRpsHardServiceLimit();
        int bpsStreamAcquireLimit = this.dynConf.getBpsStreamAcquireServiceLimit();
        int bpsSoftServiceLimit = this.dynConf.getBpsSoftServiceLimit();
        int bpsHardServiceLimit = this.dynConf.getBpsHardServiceLimit();
        RequestLimiterBuilder rpsHardLimiterBuilder = RequestLimiterBuilder.newRpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("rps_hard_limit")).limit(rpsHardServiceLimit).overlimit(new ComposableRequestLimiter.OverlimitFunction<StreamOp>(){

            public void apply(StreamOp request) throws OverCapacityException {
                throw new OverCapacityException("Being rate limited: RPS limit exceeded for the service instance");
            }
        });
        RequestLimiterBuilder rpsSoftLimiterBuilder = RequestLimiterBuilder.newRpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("rps_soft_limit")).limit(rpsSoftServiceLimit);
        RequestLimiterBuilder bpsHardLimiterBuilder = RequestLimiterBuilder.newBpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("bps_hard_limit")).limit(bpsHardServiceLimit).overlimit(new ComposableRequestLimiter.OverlimitFunction<StreamOp>(){

            public void apply(StreamOp request) throws OverCapacityException {
                throw new OverCapacityException("Being rate limited: BPS limit exceeded for the service instance");
            }
        });
        RequestLimiterBuilder bpsSoftLimiterBuilder = RequestLimiterBuilder.newBpsLimiterBuilder().statsLogger(this.limiterStatLogger.scope("bps_soft_limit")).limit(bpsSoftServiceLimit);
        ChainedRequestLimiter.Builder builder = new ChainedRequestLimiter.Builder();
        builder.addLimiter((RequestLimiter)new StreamAcquireLimiter(this.streamManager, this.serviceRps, rpsStreamAcquireLimit, this.limiterStatLogger.scope("rps_acquire")));
        builder.addLimiter((RequestLimiter)new StreamAcquireLimiter(this.streamManager, this.serviceBps, bpsStreamAcquireLimit, this.limiterStatLogger.scope("bps_acquire")));
        builder.addLimiter(bpsHardLimiterBuilder.build());
        builder.addLimiter(bpsSoftLimiterBuilder.build());
        builder.addLimiter(rpsHardLimiterBuilder.build());
        builder.addLimiter(rpsSoftLimiterBuilder.build());
        builder.statsLogger(this.limiterStatLogger);
        return builder.build();
    }
}

