/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import com.google.common.base.Optional;
import org.apache.commons.cli.CommandLine;

public class CommandLineUtils {
    public static Optional<String> getOptionalStringArg(CommandLine cmdline, String arg) {
        if (cmdline.hasOption(arg)) {
            return Optional.of((Object)cmdline.getOptionValue(arg));
        }
        return Optional.absent();
    }

    public static Optional<Boolean> getOptionalBooleanArg(CommandLine cmdline, String arg) {
        if (cmdline.hasOption(arg)) {
            return Optional.of((Object)true);
        }
        return Optional.absent();
    }

    public static Optional<Integer> getOptionalIntegerArg(CommandLine cmdline, String arg) throws IllegalArgumentException {
        try {
            if (cmdline.hasOption(arg)) {
                return Optional.of((Object)Integer.parseInt(cmdline.getOptionValue(arg)));
            }
            return Optional.absent();
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(arg + " is not a number");
        }
    }
}

