/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.thrift.ChannelBufferToTransport;
import com.twitter.finagle.thrift.ThriftCall;
import com.twitter.finagle.thrift.ThriftCallFactory;
import com.twitter.finagle.thrift.ThriftTypes$;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014Q!\u0001\u0002\u0001\u0005)\u00111\u0003\u00165sS\u001a$8+\u001a:wKJ$UmY8eKJT!a\u0001\u0003\u0002\rQD'/\u001b4u\u0015\t)a!A\u0004gS:\fw\r\\3\u000b\u0005\u001dA\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0014\u0005\u0001Y\u0001c\u0001\u0007\u001a75\tQB\u0003\u0002\u000f\u001f\u00051!/\u001a9mCfT!\u0001E\t\u0002\u000b\r|G-Z2\u000b\u0005I\u0019\u0012a\u00025b]\u0012dWM\u001d\u0006\u0003)U\tQA\\3uifT!AF\f\u0002\u000b)\u0014wn]:\u000b\u0003a\t1a\u001c:h\u0013\tQRB\u0001\tSKBd\u0017-_5oO\u0012+7m\u001c3feB\u0011A\u0002H\u0005\u0003;5\u0011\u0001BV8jI\u0016sW/\u001c\u0005\t?\u0001\u0011\t\u0011)A\u0005C\u0005y\u0001O]8u_\u000e|GNR1di>\u0014\u0018p\u0001\u0001\u0011\u0005\tBS\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00039s_R|7m\u001c7\u000b\u0005\r1#BA\u0014\u0018\u0003\u0019\t\u0007/Y2iK&\u0011\u0011f\t\u0002\u0011)B\u0013x\u000e^8d_24\u0015m\u0019;pefDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDCA\u00170!\tq\u0003!D\u0001\u0003\u0011\u0015y\"\u00061\u0001\"\u0011\u0019\t\u0004\u0001)A\u0005e\u00051An\\4hKJ\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u000f1|wmZ5oO*\u0011q\u0007O\u0001\u0005kRLGNC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m\"$A\u0002'pO\u001e,'\u000fC\u0003>\u0001\u0011\u0005a(\u0001\teK\u000e|G-\u001a+ie&4GoQ1mYR!q(R'R!\t\u00015)D\u0001B\u0015\t\u0011\u0005(\u0001\u0003mC:<\u0017B\u0001#B\u0005\u0019y%M[3di\")a\t\u0010a\u0001\u000f\u0006\u00191\r\u001e=\u0011\u0005![U\"A%\u000b\u0005)\u001b\u0012aB2iC:tW\r\\\u0005\u0003\u0019&\u0013Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003Ky\u0001\u0007a\n\u0005\u0002I\u001f&\u0011\u0001+\u0013\u0002\b\u0007\"\fgN\\3m\u0011\u0015\u0011F\b1\u0001T\u0003\u0019\u0011WO\u001a4feB\u0011AKV\u0007\u0002+*\u0011!kE\u0005\u0003/V\u0013Qb\u00115b]:,GNQ;gM\u0016\u0014\b\"B-\u0001\t\u0003R\u0016A\u00023fG>$W\rF\u0003@7rkf\fC\u0003G1\u0002\u0007q\tC\u0003K1\u0002\u0007a\nC\u0003S1\u0002\u00071\u000bC\u0003`1\u0002\u00071$A\u0003ti\u0006$X\r")
public class ThriftServerDecoder
extends ReplayingDecoder<VoidEnum> {
    private final TProtocolFactory protocolFactory;
    private final Logger logger;

    public Object decodeThriftCall(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
        ThriftCall<?, ?> thriftCall;
        ChannelBufferToTransport transport = new ChannelBufferToTransport(buffer);
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
        TMessage message = protocol.readMessageBegin();
        byte by = message.type;
        switch (by) {
            default: {
                thriftCall = null;
                break;
            }
            case 1: {
                try {
                    ThriftCallFactory<?, ?> factory = ThriftTypes$.MODULE$.apply(message.name);
                    ThriftCall<?, ?> request = factory.newInstance(message.seqid);
                    request.readRequestArgs(protocol);
                    thriftCall = request;
                    break;
                }
                catch (TApplicationException tApplicationException) {
                    this.logger.log(Level.FINE, tApplicationException.getMessage(), tApplicationException);
                    thriftCall = null;
                }
            }
        }
        return thriftCall;
    }

    public Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) {
        return buffer.readable() ? this.decodeThriftCall(ctx, channel, buffer) : null;
    }

    public ThriftServerDecoder(TProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }
}

