/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Arg;
import com.twitter.common.args.ArgumentInfo;
import com.twitter.common.args.CmdLine;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.TypeUtil;
import com.twitter.common.args.apt.Configuration;
import com.twitter.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class OptionInfo<T>
extends ArgumentInfo<T> {
    static final String ARG_NAME_RE = "[\\w\\-\\.]+";
    static final String ARG_FILE_HELP_TEMPLATE = "%s This argument supports @argfile format. See details below.";
    private static final Pattern ARG_NAME_PATTERN = Pattern.compile("[\\w\\-\\.]+");
    private static final String NEGATE_BOOLEAN = "no_";
    private static final String ARG_FILE_INDICATOR = "@";
    private final Function<String, String> canonicalizer;

    static OptionInfo<?> createFromField(Field field) {
        return OptionInfo.createFromField(field, null);
    }

    static OptionInfo<?> createFromField(final Field field, @Nullable Object instance) {
        CmdLine cmdLine = field.getAnnotation(CmdLine.class);
        if (cmdLine == null) {
            throw new Configuration.ConfigurationException("No @CmdLine Arg annotation for field " + field, new Object[0]);
        }
        String name = cmdLine.name();
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!HELP_ARGS.contains((Object)name) ? 1 : 0) != 0, (Object)String.format("Argument name '%s' is reserved for builtin argument help", name));
        Preconditions.checkArgument((boolean)ARG_NAME_PATTERN.matcher(name).matches(), (Object)String.format("Argument name '%s' does not match required pattern %s", name, ARG_NAME_RE));
        Function<String, String> canonicalizer = new Function<String, String>(){

            public String apply(String name) {
                return field.getDeclaringClass().getCanonicalName() + "." + name;
            }
        };
        OptionInfo optionInfo = new OptionInfo(canonicalizer, name, OptionInfo.getCmdLineHelp(cmdLine), cmdLine.argFile(), ArgumentInfo.getArgForField(field, Optional.fromNullable((Object)instance)), TypeUtil.getTypeParamTypeToken(field), Arrays.asList(field.getAnnotations()), cmdLine.parser());
        return optionInfo;
    }

    private static String getCmdLineHelp(CmdLine cmdLine) {
        String help = cmdLine.help();
        if (cmdLine.argFile()) {
            help = String.format(ARG_FILE_HELP_TEMPLATE, help, cmdLine.name(), cmdLine.name());
        }
        return help;
    }

    private OptionInfo(Function<String, String> canonicalizer, String name, String help, boolean argFile, Arg<T> arg, TypeToken<T> type, List<Annotation> verifierAnnotations, @Nullable Class<? extends Parser<T>> parser) {
        super((String)canonicalizer.apply((Object)name), name, help, argFile, arg, type, verifierAnnotations, parser);
        this.canonicalizer = canonicalizer;
    }

    void load(ParserOracle parserOracle, String optionName, String value) {
        Parser parser = this.getParser(parserOracle);
        String finalValue = value;
        if (this.argFile() && !Strings.isNullOrEmpty((String)value) && value.startsWith(ARG_FILE_INDICATOR)) {
            finalValue = this.getArgFileContent(optionName, value.substring(ARG_FILE_INDICATOR.length()));
        }
        Object result = parser.parse(parserOracle, this.getType().getType(), finalValue);
        if (this.isBoolean() && Predicates.in(Arrays.asList(this.getNegatedName(), this.getCanonicalNegatedName())).apply((Object)optionName)) {
            result = (Boolean)result == false;
        }
        Object parsed = result;
        this.setValue(parsed);
    }

    boolean isBoolean() {
        return this.getType().getRawType() == Boolean.class;
    }

    String getNegatedName() {
        return NEGATE_BOOLEAN + this.getName();
    }

    String getCanonicalNegatedName() {
        return (String)this.canonicalizer.apply((Object)this.getNegatedName());
    }

    private String getArgFileContent(String optionName, String argFilePath) throws IllegalArgumentException {
        if (argFilePath.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid null/empty value for argument '%s'.", optionName));
        }
        try {
            return Files.toString((File)new File(argFilePath), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to read argument '%s' value from file '%s'.", optionName, argFilePath), e);
        }
    }
}

