/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import java.util.ArrayList;
import java.util.List;

public class ServiceAccountFluentImpl<A extends ServiceAccountFluent<A>>
extends BaseFluent<A>
implements ServiceAccountFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends LocalObjectReference, ?>> imagePullSecrets = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private List<VisitableBuilder<? extends ObjectReference, ?>> secrets = new ArrayList();

    public ServiceAccountFluentImpl() {
    }

    public ServiceAccountFluentImpl(ServiceAccount instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSecrets(instance.getSecrets());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return ServiceAccountFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this._visitables.removeAll(this.imagePullSecrets);
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(item);
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ObjectReference> getSecrets() {
        return ServiceAccountFluentImpl.build(this.secrets);
    }

    @Override
    public A withSecrets(List<ObjectReference> secrets) {
        this._visitables.removeAll(this.secrets);
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecrets(ObjectReference ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> addNewSecretLike(ObjectReference item) {
        return new SecretsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceAccountFluentImpl that = (ServiceAccountFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null);
    }

    public class SecretsNestedImpl<N>
    extends ObjectReferenceFluentImpl<ServiceAccountFluent.SecretsNested<N>>
    implements ServiceAccountFluent.SecretsNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        SecretsNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.addToSecrets(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServiceAccountFluent.MetadataNested<N>>
    implements ServiceAccountFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ServiceAccountFluent.ImagePullSecretsNested<N>>
    implements ServiceAccountFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        ImagePullSecretsNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.addToImagePullSecrets(this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }
}

