/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.LocationSummary;
import org.apache.brooklyn.rest.domain.TaskSummary;

@Path(value="/applications/{application}/entities")
@Api(value="Entities")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EntityApi {
    @GET
    @ApiOperation(value="Fetch the list of children entities directly under the root of an application", response=EntitySummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Application not found")})
    public List<EntitySummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1);

    @GET
    @Path(value="/{entity}")
    @ApiOperation(value="Fetch details of an entity", response=EntitySummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public EntitySummary get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @ApiOperation(value="Fetch the list of children of an entity", response=EntitySummary.class)
    @Path(value="/{entity}/children")
    public List<EntitySummary> getChildren(@PathParam(value="application") String var1, @PathParam(value="entity") String var2);

    @POST
    @ApiOperation(value="Add a child or children to this entity given a YAML spec", response=TaskSummary.class)
    @Consumes(value={"application/x-yaml", "text/yaml", "text/x-yaml", "application/yaml", "application/json"})
    @Path(value="/{entity}/children")
    public Response addChildren(@PathParam(value="application") String var1, @PathParam(value="entity") String var2, @ApiParam(name="start", value="Whether to automatically start this child; if omitted, true for Startable entities") @QueryParam(value="start") Boolean var3, @ApiParam(name="timeout", value="Delay before server should respond with incomplete activity task, rather than completed task: 'never' means block until complete; '0' means return task immediately; and e.g. '20ms' (the default) will wait 20ms for completed task information to be available", required=false, defaultValue="20ms") @QueryParam(value="timeout") String var4, @ApiParam(name="childrenSpec", value="Entity spec in CAMP YAML format (including 'services' root element)", required=true) String var5);

    @GET
    @Path(value="/{entity}/activities")
    @ApiOperation(value="Fetch list of tasks for this entity")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application or entity")})
    public List<TaskSummary> listTasks(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Max number of tasks, or -1 for all (default 200)", required=false) @QueryParam(value="limit") @DefaultValue(value="200") int var3, @ApiParam(value="Whether to include subtasks recursively across different entities (default false)", required=false) @QueryParam(value="recurse") @DefaultValue(value="false") Boolean var4);

    @GET
    @Path(value="/{entity}/activities/deprecated")
    @ApiOperation(value="Fetch list of tasks for this entity")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application or entity")})
    @Deprecated
    public List<TaskSummary> listTasks(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/activities/{task}")
    @ApiOperation(value="Fetch task details", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application, entity or task")})
    @Produces(value={"text/json"})
    public TaskSummary getTask(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Task ID", required=true) @PathParam(value="task") String var3);

    @GET
    @ApiOperation(value="Returns an icon for the entity, if defined")
    @Path(value="/{entity}/icon")
    public Response getIcon(@PathParam(value="application") String var1, @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/tags")
    @ApiOperation(value="Fetch list of tags on this entity")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find application or entity")})
    public List<Object> listTags(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @POST
    @ApiOperation(value="Rename an entity")
    @ApiResponses(value={@ApiResponse(code=404, message="Undefined application or entity")})
    @Path(value="/{entity}/name")
    public Response rename(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="New name for this entity", required=true) @QueryParam(value="name") String var3);

    @POST
    @ApiOperation(value="Expunge an entity", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Undefined application or entity")})
    @Path(value="/{entity}/expunge")
    public Response expunge(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Whether to gracefully release all resources", required=true) @QueryParam(value="release") boolean var3);

    @GET
    @Path(value="/{entity}/descendants")
    @ApiOperation(value="Fetch entity info for all (or filtered) descendants", response=EntitySummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public List<EntitySummary> getDescendants(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Regular expression for an entity type which must be matched", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var3);

    @GET
    @Path(value="/{entity}/descendants/sensor/{sensor}")
    @ApiOperation(value="Fetch values of a given sensor for all (or filtered) descendants")
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public Map<String, Object> getDescendantsSensor(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Regular expression applied to filter descendant entities based on their type", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var4);

    @GET
    @Path(value="/{entity}/locations")
    @ApiOperation(value="List the locations set on the entity")
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public List<LocationSummary> getLocations(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/{entity}/spec")
    @ApiOperation(value="Get the YAML spec used to create the entity, if available")
    @Produces(value={"text/x-yaml", "application/x-yaml", "text/yaml", "text/plain", "application/yaml", "text/plain"})
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public String getSpec(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);
}

