/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.chef.ChefConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.internal.ssh.process.ProcessTool;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.task.system.internal.SystemProcessTaskFactory;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;

public class KnifeTaskFactory<RET>
extends SystemProcessTaskFactory<KnifeTaskFactory<RET>, RET> {
    private static String KNIFE_PLACEHOLDER = "<knife command goes here 1234>";
    public final String taskName;
    protected String knifeExecutable;
    protected List<String> knifeParameters = new ArrayList<String>();
    protected String knifeConfigFile;
    protected String knifeSetupCommands;
    protected Boolean throwOnCommonKnifeErrors;

    public KnifeTaskFactory(String taskName) {
        super(new String[0]);
        this.taskName = taskName;
        this.summary(taskName);
        this.config.put(ProcessTool.PROP_LOGIN_SHELL, (Object)true);
    }

    public List<Function<ProcessTaskWrapper<?>, Void>> getCompletionListeners() {
        MutableList result = MutableList.copyOf((Iterable)super.getCompletionListeners());
        if (this.throwOnCommonKnifeErrors != Boolean.FALSE) {
            this.insertKnifeCompletionListenerIntoCompletionListenersList((List<Function<ProcessTaskWrapper<?>, Void>>)result);
        }
        return result.asUnmodifiable();
    }

    public KnifeTaskFactory<RET> notThrowingOnCommonKnifeErrors() {
        this.throwOnCommonKnifeErrors = false;
        return (KnifeTaskFactory)this.self();
    }

    protected void insertKnifeCompletionListenerIntoCompletionListenersList(List<Function<ProcessTaskWrapper<?>, Void>> listeners) {
        Function propagateIfKnifeConfigFileMissing = new Function<ProcessTaskWrapper<?>, Void>(){

            public Void apply(@Nullable ProcessTaskWrapper<?> input) {
                if (input.getExitCode() != 0 && input.getStderr().indexOf("WARNING: No knife configuration file found") >= 0) {
                    String myConfig = KnifeTaskFactory.this.knifeConfigFileOption();
                    if (Strings.isEmpty((CharSequence)myConfig)) {
                        throw new IllegalStateException("Config file for Chef knife must be specified in " + ChefConfig.KNIFE_CONFIG_FILE + " (or valid knife default set up)");
                    }
                    throw new IllegalStateException("Error reading config file for Chef knife (" + myConfig + ") -- does it exist?");
                }
                return null;
            }
        };
        listeners.add(propagateIfKnifeConfigFileMissing);
    }

    public ProcessTaskWrapper<RET> newTask() {
        return new SystemProcessTaskFactory.SystemProcessTaskWrapper((SystemProcessTaskFactory)this, "Knife");
    }

    public KnifeTaskFactory<RET> addKnifeCommandToScript() {
        this.add(new String[]{KNIFE_PLACEHOLDER});
        return (KnifeTaskFactory)this.self();
    }

    public List<String> getCommands() {
        MutableList result = new MutableList();
        String setupCommands = this.knifeSetupCommands();
        if (setupCommands != null && Strings.isNonBlank((CharSequence)setupCommands)) {
            result.add((Object)setupCommands);
        }
        int numKnifes = 0;
        for (String c : super.getCommands()) {
            if (c == KNIFE_PLACEHOLDER) {
                result.add((Object)this.buildKnifeCommand(numKnifes++));
                continue;
            }
            result.add((Object)c);
        }
        if (numKnifes == 0) {
            result.add((Object)this.buildKnifeCommand(numKnifes++));
        }
        return result.asUnmodifiable();
    }

    protected String buildKnifeCommand(int knifeCommandIndex) {
        MutableList words = new MutableList();
        words.add((Object)this.knifeExecutable());
        words.addAll(this.initialKnifeParameters());
        words.addAll(this.knifeParameters());
        String x = this.knifeConfigFileOption();
        if (Strings.isNonBlank((CharSequence)x)) {
            words.add((Object)this.knifeConfigFileOption());
        }
        return Strings.join((Iterable)words, (String)" ");
    }

    protected List<String> initialKnifeParameters() {
        return new MutableList();
    }

    @Nullable
    protected Entity entity() {
        return BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
    }

    protected <T> T entityConfig(ConfigKey<T> key) {
        Entity entity = this.entity();
        if (entity != null) {
            return (T)entity.getConfig(key);
        }
        return null;
    }

    public KnifeTaskFactory<RET> knifeExecutable(String knifeExecutable) {
        this.knifeExecutable = knifeExecutable;
        return this;
    }

    protected String knifeExecutable() {
        if (this.knifeExecutable != null) {
            return this.knifeExecutable;
        }
        String knifeExecFromConfig = this.entityConfig(ChefConfig.KNIFE_EXECUTABLE);
        if (knifeExecFromConfig != null) {
            return StringEscapes.BashStringEscapes.wrapBash((String)knifeExecFromConfig);
        }
        return "knife";
    }

    protected List<String> knifeParameters() {
        return this.knifeParameters;
    }

    public KnifeTaskFactory<RET> knifeAddParameters(String word1, String ... words) {
        this.knifeParameters.add(word1);
        for (String w : words) {
            this.knifeParameters.add(w);
        }
        return (KnifeTaskFactory)this.self();
    }

    public KnifeTaskFactory<RET> knifeConfigFile(String knifeConfigFile) {
        this.knifeConfigFile = knifeConfigFile;
        return (KnifeTaskFactory)this.self();
    }

    @Nullable
    protected String knifeConfigFileOption() {
        if (this.knifeConfigFile != null) {
            return "-c " + this.knifeConfigFile;
        }
        String knifeConfigFileFromConfig = this.entityConfig(ChefConfig.KNIFE_CONFIG_FILE);
        if (knifeConfigFileFromConfig != null) {
            return "-c " + StringEscapes.BashStringEscapes.wrapBash((String)knifeConfigFileFromConfig);
        }
        return null;
    }

    public KnifeTaskFactory<RET> knifeSetupCommands(String knifeSetupCommands) {
        this.knifeSetupCommands = knifeSetupCommands;
        return (KnifeTaskFactory)this.self();
    }

    @Nullable
    protected String knifeSetupCommands() {
        if (this.knifeSetupCommands != null) {
            return this.knifeSetupCommands;
        }
        String knifeSetupCommandsFromConfig = this.entityConfig(ChefConfig.KNIFE_SETUP_COMMANDS);
        if (knifeSetupCommandsFromConfig != null) {
            return knifeSetupCommandsFromConfig;
        }
        return null;
    }

    public <T2> KnifeTaskFactory<T2> returning(ProcessTaskStub.ScriptReturnType type) {
        return (KnifeTaskFactory)super.returning(type);
    }

    public <RET2> KnifeTaskFactory<RET2> returning(Function<ProcessTaskWrapper<?>, RET2> resultTransformation) {
        return (KnifeTaskFactory)super.returning(resultTransformation);
    }

    public KnifeTaskFactory<Boolean> returningIsExitCodeZero() {
        return (KnifeTaskFactory)super.returningIsExitCodeZero();
    }

    public KnifeTaskFactory<String> requiringZeroAndReturningStdout() {
        return (KnifeTaskFactory)super.requiringZeroAndReturningStdout();
    }
}

