/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent;
import java.util.ArrayList;
import java.util.List;

public class LoadBalancerStatusFluentImpl<A extends LoadBalancerStatusFluent<A>>
extends BaseFluent<A>
implements LoadBalancerStatusFluent<A> {
    private List<VisitableBuilder<? extends LoadBalancerIngress, ?>> ingress = new ArrayList();

    public LoadBalancerStatusFluentImpl() {
    }

    public LoadBalancerStatusFluentImpl(LoadBalancerStatus instance) {
        this.withIngress(instance.getIngress());
    }

    @Override
    public A addToIngress(LoadBalancerIngress ... items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(LoadBalancerIngress ... items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<LoadBalancerIngress> getIngress() {
        return LoadBalancerStatusFluentImpl.build(this.ingress);
    }

    @Override
    public A withIngress(List<LoadBalancerIngress> ingress) {
        this._visitables.removeAll(this.ingress);
        this.ingress.clear();
        if (ingress != null) {
            for (LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIngress(LoadBalancerIngress ... ingress) {
        this.ingress.clear();
        if (ingress != null) {
            for (LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(LoadBalancerIngress item) {
        return new IngressNestedImpl(item);
    }

    @Override
    public A addNewIngress(String hostname, String ip) {
        return this.addToIngress(new LoadBalancerIngress(hostname, ip));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerStatusFluentImpl that = (LoadBalancerStatusFluentImpl)o;
        return !(this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null);
    }

    public class IngressNestedImpl<N>
    extends LoadBalancerIngressFluentImpl<LoadBalancerStatusFluent.IngressNested<N>>
    implements LoadBalancerStatusFluent.IngressNested<N>,
    Nested<N> {
        private final LoadBalancerIngressBuilder builder;

        IngressNestedImpl(LoadBalancerIngress item) {
            this.builder = new LoadBalancerIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.builder = new LoadBalancerIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)LoadBalancerStatusFluentImpl.this.addToIngress(this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

