/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.brooklyn.rest.domain.ConfigSummary;

@Path(value="/applications/{application}/entities/{entity}/config")
@Api(value="Entity Config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EntityConfigApi {
    @GET
    @ApiOperation(value="Fetch the config keys for a specific application entity", response=ConfigSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or config key"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<ConfigSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch config key values in batch", notes="Returns a map of config name to value")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or config key"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, Object> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Whether to format/annotate values with hints for for display", required=false) @QueryParam(value="useDisplayHint") @DefaultValue(value="true") Boolean var3, @ApiParam(value="Whether to skip resolution of all values", required=false) @QueryParam(value="skipResolution") @DefaultValue(value="false") Boolean var4, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") @DefaultValue(value="false") Boolean var5, @ApiParam(value="Return raw config data instead of display values (deprecated, see useDisplayHints)", required=false) @Deprecated @QueryParam(value="raw") @DefaultValue(value="false") Boolean var6);

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value (json)", response=Object.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or config key"), @ApiResponse(code=500, message="Internal Server Error")})
    @Produces(value={"application/json"})
    public Object get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var3, @ApiParam(value="Whether to format/annotate values with hints for for display", required=false) @QueryParam(value="useDisplayHint") @DefaultValue(value="true") Boolean var4, @ApiParam(value="Whether to skip resolution of all values", required=false) @QueryParam(value="skipResolution") @DefaultValue(value="false") Boolean var5, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") @DefaultValue(value="false") Boolean var6, @ApiParam(value="Return raw config data instead of display values (deprecated, see useDisplayHints)", required=false) @Deprecated @QueryParam(value="raw") @DefaultValue(value="false") Boolean var7);

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value (text/plain)", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or config key"), @ApiResponse(code=500, message="Internal Server Error")})
    @Produces(value={"text/plain;qs=0.9"})
    public String getPlain(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String var3, @ApiParam(value="Whether to format/annotate values with hints for for display", required=false) @QueryParam(value="useDisplayHints") @DefaultValue(value="true") Boolean var4, @ApiParam(value="Whether to skip resolution of all values", required=false) @QueryParam(value="skipResolution") @DefaultValue(value="false") Boolean var5, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") @DefaultValue(value="false") Boolean var6, @ApiParam(value="Return raw config data instead of display values (deprecated, see useDisplayHints)", required=false) @Deprecated @QueryParam(value="raw") @DefaultValue(value="false") Boolean var7);

    @POST
    @ApiOperation(value="Manually set multiple config values")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application or entity"), @ApiResponse(code=500, message="Internal Server Error")})
    public void setFromMap(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Apply the config to all pre-existing descendants", required=false) @QueryParam(value="recurse") @DefaultValue(value="false") Boolean var3, @ApiParam(value="Map of config key names to values", required=true) Map var4);

    @POST
    @Path(value="/{config}")
    @ApiOperation(value="Manually set a config value")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or config key"), @ApiResponse(code=500, message="Internal Server Error")})
    public void set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Config key name", required=true) @PathParam(value="config") String var3, @ApiParam(value="Apply the config to all pre-existing descendants", required=false) @QueryParam(value="recurse") @DefaultValue(value="false") Boolean var4, @ApiParam(value="Value to set") Object var5);
}

