/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.objs.HighlightTuple;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.domain.HasName;
import org.apache.brooklyn.rest.domain.Status;

public class AdjunctSummary
implements HasName,
Serializable,
Identifiable {
    private static final long serialVersionUID = -8106551648118942612L;
    private String id;
    private String name;
    private BrooklynObjectType adjunctType;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String catalogItemId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String iconUrl;
    private Status state;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, HighlightTuple> highlights;
    private Map<String, URI> links;

    protected AdjunctSummary() {
    }

    public AdjunctSummary(EntityAdjunct a) {
        RegisteredType type;
        this.id = a.getId();
        this.name = a.getDisplayName();
        this.adjunctType = BrooklynObjectType.of((BrooklynObject)a);
        this.catalogItemId = a.getCatalogItemId();
        this.highlights = a.getHighlights();
        if (a instanceof AbstractEntityAdjunct && this.catalogItemId != null && this.notObviouslyInvalidForAdjunct(a, type = ((AbstractEntityAdjunct)a).getManagementContext().getTypeRegistry().get(this.catalogItemId))) {
            this.iconUrl = RegisteredTypes.getIconUrl((BrooklynObject)a);
            this.description = type.getDescription();
        }
    }

    private boolean notObviouslyInvalidForAdjunct(EntityAdjunct a, RegisteredType type) {
        if (type == null) {
            return false;
        }
        if (type.getSuperTypes().isEmpty()) {
            return true;
        }
        for (Object t : type.getSuperTypes()) {
            if (t instanceof Class && EntityAdjunct.class.isAssignableFrom((Class)t)) {
                return true;
            }
            if (!(t instanceof Class) || !Entity.class.isAssignableFrom((Class)t)) continue;
            return false;
        }
        return true;
    }

    protected AdjunctSummary(String id, String name, BrooklynObjectType adjunctType, String catalogItemId, Status state, Map<String, HighlightTuple> highlights, Map<String, URI> links) {
        this.id = id;
        this.name = name;
        this.adjunctType = adjunctType;
        this.catalogItemId = catalogItemId;
        this.state = state;
        this.highlights = highlights == null ? ImmutableMap.of() : ImmutableMap.copyOf(highlights);
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BrooklynObjectType getAdjunctType() {
        return this.adjunctType;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Status getState() {
        return this.state;
    }

    public Map<String, HighlightTuple> getHighlights() {
        return this.highlights;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public AdjunctSummary iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public AdjunctSummary state(Status state) {
        this.state = state;
        return this;
    }

    public AdjunctSummary links(Map<String, URI> links) {
        this.links = links;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdjunctSummary)) {
            return false;
        }
        AdjunctSummary that = (AdjunctSummary)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.adjunctType, that.adjunctType) && Objects.equals(this.catalogItemId, that.catalogItemId) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.highlights, that.highlights) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.adjunctType, this.catalogItemId, this.state, this.highlights, this.links});
    }

    public String toString() {
        return (this.adjunctType != null ? this.adjunctType.name() : "AdjunctSummary") + "{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", catalogItemId='" + this.catalogItemId + '\'' + ", state='" + (Object)((Object)this.state) + '\'' + ", highlights=" + this.highlights + ", links=" + this.links + '}';
    }
}

