/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.ThreadLocalStack;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.predicates.ResolutionFailureTreatedAsAbsent;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExpressionResolution {
    public static ConfigKey<BiFunction<String, WorkflowExpressionResolution, Object>> WORKFLOW_CUSTOM_INTERPOLATION_FUNCTION = ConfigKeys.newConfigKey(new TypeToken<BiFunction<String, WorkflowExpressionResolution, Object>>(){}, "workflow.custom_interpolation_function");
    private static final Logger log = LoggerFactory.getLogger(WorkflowExpressionResolution.class);
    private final WorkflowExecutionContext context;
    private final boolean allowWaiting;
    private final WorkflowExpressionStage stage;
    private final TemplateProcessor.InterpolationErrorMode errorMode;
    private final WrappingMode wrappingMode;
    AllowBrooklynDslMode defaultAllowBrooklynDsl = AllowBrooklynDslMode.ALL;
    static ThreadLocalStack<WorkflowVariableResolutionStackEntry> RESOLVE_STACK = new ThreadLocalStack(false);
    private static ThreadLocal<Boolean> interruptSetIfNeededToPreventWaiting = new ThreadLocal();

    public WorkflowExpressionResolution(WorkflowExecutionContext context, WorkflowExpressionStage stage, boolean allowWaiting, WrappingMode wrapExpressionValues) {
        this(context, stage, allowWaiting, wrapExpressionValues, TemplateProcessor.InterpolationErrorMode.FAIL);
    }

    public WorkflowExpressionResolution(WorkflowExecutionContext context, WorkflowExpressionStage stage, boolean allowWaiting, WrappingMode wrapExpressionValues, TemplateProcessor.InterpolationErrorMode errorMode) {
        this.context = context;
        this.stage = stage;
        this.allowWaiting = allowWaiting;
        this.wrappingMode = wrapExpressionValues == null ? WrappingMode.NONE : wrapExpressionValues;
        this.errorMode = errorMode;
    }

    TemplateModel ifNoMatches() {
        return null;
    }

    TemplateModel newWorkflowStepModelForStepIndex(Integer step) {
        WorkflowExecutionContext.OldStepRecord stepI = this.context.oldStepInfo.get(step);
        if (stepI == null || stepI.context == null) {
            return this.ifNoMatches();
        }
        return new WorkflowStepModel(stepI.context);
    }

    TemplateModel newWorkflowStepModelForStepId(String id) {
        for (WorkflowExecutionContext.OldStepRecord s : this.context.oldStepInfo.values()) {
            if (s.context == null || !id.equals(s.context.stepDefinitionDeclaredId)) continue;
            return new WorkflowStepModel(s.context);
        }
        return this.ifNoMatches();
    }

    public void setDefaultAllowBrooklynDsl(AllowBrooklynDslMode defaultAllowBrooklynDsl) {
        this.defaultAllowBrooklynDsl = defaultAllowBrooklynDsl;
    }

    public AllowBrooklynDslMode getDefaultAllowBrooklynDsl() {
        return this.defaultAllowBrooklynDsl;
    }

    public <T> T resolveWithTemplates(Object expression, TypeToken<T> type) {
        expression = this.processTemplateExpression(expression, this.getDefaultAllowBrooklynDsl());
        return this.resolveCoercingOnly(expression, type);
    }

    public <T> T resolveCoercingOnly(Object expression, TypeToken<T> type) {
        if (expression == null) {
            return null;
        }
        boolean triedCoercion = false;
        MutableList exceptions = MutableList.of();
        if (expression instanceof String) {
            try {
                return TypeCoercions.coerce(expression, type);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                exceptions.add(e);
                triedCoercion = true;
            }
        }
        if (Jsonya.isJsonPrimitiveDeep((Object)expression) && !(expression instanceof Set)) {
            try {
                return BeanWithTypeUtils.convert(this.context.getManagementContext(), expression, type, true, RegisteredTypes.getClassLoadingContext(this.context.getEntity()), true);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                exceptions.add(e);
            }
        }
        if (!triedCoercion) {
            try {
                return TypeCoercions.coerce(expression, type);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                exceptions.add(e);
                triedCoercion = true;
            }
        }
        throw Exceptions.propagate((Throwable)((Throwable)exceptions.iterator().next()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T allowingRecursionWhenSetting(WorkflowExecutionContext context, WorkflowExpressionStage stage, String variable, Supplier<T> callable) {
        WorkflowVariableResolutionStackEntry entry = null;
        try {
            entry = WorkflowVariableResolutionStackEntry.setting(context, stage, variable);
            if (!RESOLVE_STACK.push((Object)entry)) {
                entry = null;
                throw new WorkflowVariableRecursiveReference("Recursive reference setting " + variable + ": " + RESOLVE_STACK.getAll(false).stream().map(p -> p.object != null ? p.object.toString() : p.settingVariable).collect(Collectors.joining("->")));
            }
            T t = callable.get();
            return t;
        }
        finally {
            if (entry != null) {
                RESOLVE_STACK.pop((Object)entry);
            }
        }
    }

    WorkflowExpressionStage previousStage() {
        return (WorkflowExpressionStage)RESOLVE_STACK.peekPenultimate().map(s -> s.stage).orNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processTemplateExpression(Object expression, AllowBrooklynDslMode allowBrooklynDsl) {
        WorkflowVariableResolutionStackEntry entry = null;
        try {
            entry = WorkflowVariableResolutionStackEntry.of(this.context, this.stage, expression);
            if (!RESOLVE_STACK.push((Object)entry)) {
                entry = null;
                throw new WorkflowVariableRecursiveReference("Recursive reference: " + RESOLVE_STACK.getAll(false).stream().map(p -> "" + p.object).collect(Collectors.joining("->")));
            }
            if (RESOLVE_STACK.size() > 100) {
                throw new WorkflowVariableRecursiveReference("Reference exceeded max depth 100: " + RESOLVE_STACK.getAll(false).stream().map(p -> "" + p.object).collect(Collectors.joining("->")));
            }
            if (expression instanceof String) {
                Object object = this.processTemplateExpressionString((String)expression, allowBrooklynDsl);
                return object;
            }
            if (expression instanceof Map) {
                Object object = this.processTemplateExpressionMap((Map)expression, allowBrooklynDsl);
                return object;
            }
            if (expression instanceof Collection) {
                Collection<?> collection = this.processTemplateExpressionCollection((Collection)expression, allowBrooklynDsl);
                return collection;
            }
            if (expression == null || Boxing.isPrimitiveOrBoxedObject((Object)expression)) {
                Object object = expression;
                return object;
            }
            Object object = allowBrooklynDsl.isAllowedHere() ? this.resolveDsl(expression) : expression;
            return object;
        }
        finally {
            if (entry != null) {
                RESOLVE_STACK.pop((Object)entry);
            }
        }
    }

    private Object resolveDsl(Object expression) {
        boolean DEFINITELY_DSL = false;
        if (expression instanceof String || expression instanceof Map || expression instanceof Collection) {
            if (expression instanceof String) {
                if (!((String)expression).startsWith("$brooklyn:")) {
                    return expression;
                }
                DEFINITELY_DSL = true;
            }
            if (BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings.BROOKLYN_PARSE_DSL_FUNCTION == null) {
                if (DEFINITELY_DSL) {
                    log.warn("BROOKLYN_PARSE_DSL_FUNCTION not set when processing DSL expression " + expression + "; will not be resolved");
                }
            } else {
                expression = BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings.BROOKLYN_PARSE_DSL_FUNCTION.apply(this.context.getManagementContext(), expression);
            }
        }
        return this.processDslComponents(expression);
    }

    private Object processDslComponents(Object expression) {
        return Tasks.resolving(expression).as(Object.class).deep().context(this.context.getEntity()).get();
    }

    public WorkflowFreemarkerModel newWorkflowFreemarkerModel() {
        return new WorkflowFreemarkerModel();
    }

    public WorkflowExecutionContext getWorkflowExecutionContext() {
        return this.context;
    }

    public TemplateProcessor.InterpolationErrorMode getErrorMode() {
        return this.errorMode;
    }

    public Object processTemplateExpressionString(String expression, AllowBrooklynDslMode allowBrooklynDsl) {
        Object result;
        if (expression == null) {
            return null;
        }
        if (expression.startsWith("$brooklyn:") && allowBrooklynDsl.isAllowedHere()) {
            if (this.wrappingMode.deferBrooklynDsl) {
                return WrappedUnresolvedExpression.ofExpression(expression, this, allowBrooklynDsl);
            }
            Object expressionTemplateResolved = this.processTemplateExpressionString(expression, AllowBrooklynDslMode.NONE);
            Object expressionTemplateAndDslResolved = this.resolveDsl(expressionTemplateResolved);
            return expressionTemplateAndDslResolved;
        }
        boolean ourWait = this.interruptSetIfNeededToPreventWaiting();
        try {
            BiFunction fn = (BiFunction)this.context.getManagementContext().getScratchpad().get(WORKFLOW_CUSTOM_INTERPOLATION_FUNCTION);
            result = fn != null ? fn.apply(expression, this) : TemplateProcessor.processTemplateContentsForWorkflow("workflow", expression, this.newWorkflowFreemarkerModel(), true, false, this.errorMode);
        }
        catch (Exception e) {
            Exception e2 = e;
            if (this.wrappingMode.deferAndRetryErroneousExpressions) {
                WrappedUnresolvedExpression wrappedUnresolvedExpression = WrappedUnresolvedExpression.ofExpression(expression, this, allowBrooklynDsl);
                return wrappedUnresolvedExpression;
            }
            if (!this.allowWaiting && Exceptions.isCausedByInterruptInAnyThread((Throwable)e)) {
                e2 = new IllegalArgumentException("Expression value '" + expression + "' unavailable and not permitted to wait: " + Exceptions.collapseText((Throwable)e), e);
            }
            if (this.wrappingMode.deferThrowingError) {
                WrappedResolvedExpression wrappedResolvedExpression = WrappedResolvedExpression.ofError(expression, new ResolutionFailureTreatedAsAbsent.ResolutionFailureTreatedAsAbsentDefaultException(e2));
                return wrappedResolvedExpression;
            }
            throw Exceptions.propagate((Throwable)e2);
        }
        finally {
            if (ourWait) {
                this.interruptClear();
            }
        }
        if (!expression.equals(result)) {
            if (this.wrappingMode.deferInterpolation) {
                return WrappedUnresolvedExpression.ofExpression(expression, this, allowBrooklynDsl);
            }
            if (this.wrappingMode.deferBrooklynDsl) {
                return new WrappedResolvedExpression(expression, result);
            }
            result = this.processDslComponents(result);
            if (this.wrappingMode.wrapResolvedStrings) {
                return new WrappedResolvedExpression(expression, result);
            }
        }
        return result;
    }

    public static boolean isInterruptSetToPreventWaiting() {
        Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
        if (entity != null && Entities.isUnmanagingOrNoLongerManaged(entity)) {
            return false;
        }
        return Boolean.TRUE.equals(interruptSetIfNeededToPreventWaiting.get());
    }

    private boolean interruptSetIfNeededToPreventWaiting() {
        if (!(this.allowWaiting || Thread.currentThread().isInterrupted() || WorkflowExpressionResolution.isInterruptSetToPreventWaiting())) {
            interruptSetIfNeededToPreventWaiting.set(true);
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    private void interruptClear() {
        Thread.interrupted();
        interruptSetIfNeededToPreventWaiting.remove();
    }

    public Object processTemplateExpressionMap(Map<?, ?> object, AllowBrooklynDslMode allowBrooklynDsl) {
        Object key;
        if (allowBrooklynDsl.isAllowedHere() && object.size() == 1 && (key = object.keySet().iterator().next()) instanceof String && ((String)key).startsWith("$brooklyn:")) {
            Object expressionTemplateValueResolved = this.processTemplateExpression(object.values().iterator().next(), allowBrooklynDsl.next());
            Object expressionTemplateAndDslResolved = this.resolveDsl(MutableMap.of(key, (Object)expressionTemplateValueResolved));
            return expressionTemplateAndDslResolved;
        }
        MutableMap result = MutableMap.of();
        object.forEach((arg_0, arg_1) -> this.lambda$processTemplateExpressionMap$4((Map)result, allowBrooklynDsl, arg_0, arg_1));
        return result;
    }

    protected Collection<?> processTemplateExpressionCollection(Collection<?> object, AllowBrooklynDslMode allowBrooklynDsl) {
        return object.stream().map(x -> this.processTemplateExpression(x, allowBrooklynDsl.next())).collect(Collectors.toList());
    }

    private /* synthetic */ void lambda$processTemplateExpressionMap$4(Map result, AllowBrooklynDslMode allowBrooklynDsl, Object k, Object v) {
        result.put(this.processTemplateExpression(k, allowBrooklynDsl.next()), this.processTemplateExpression(v, allowBrooklynDsl.next()));
    }

    public static class WrappedUnresolvedExpression
    implements DeferredSupplier<Object> {
        String expression;
        WorkflowExpressionResolution resolver;
        AllowBrooklynDslMode dslMode;

        @Deprecated
        @Beta
        public static WrappedUnresolvedExpression ofExpression(String expression, WorkflowExpressionResolution resolver, AllowBrooklynDslMode dslMode) {
            return new WrappedUnresolvedExpression(expression, resolver, dslMode);
        }

        protected WrappedUnresolvedExpression(String expression, WorkflowExpressionResolution resolver, AllowBrooklynDslMode dslMode) {
            this.expression = expression;
            this.resolver = resolver;
            this.dslMode = dslMode;
        }

        @Override
        public Object get() {
            WorkflowExpressionResolution resolverNow = new WorkflowExpressionResolution(this.resolver.context, this.resolver.stage, this.resolver.allowWaiting, this.resolver.wrappingMode.wrappingModeWhenResolving(), this.resolver.errorMode);
            return resolverNow.processTemplateExpression(this.expression, this.dslMode);
        }
    }

    public static class WrappedResolvedExpression<T>
    implements DeferredSupplier<T> {
        String expression;
        T value;
        Throwable error;

        public WrappedResolvedExpression() {
        }

        public WrappedResolvedExpression(String expression, T value) {
            this.expression = expression;
            this.value = value;
        }

        public static WrappedResolvedExpression ofError(String expression, Throwable error) {
            WrappedResolvedExpression<Object> result = new WrappedResolvedExpression<Object>(expression, null);
            result.error = error;
            return result;
        }

        @Override
        public T get() {
            if (this.error != null) {
                throw Exceptions.propagate((Throwable)this.error);
            }
            return this.value;
        }

        public String getExpression() {
            return this.expression;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class AllowBrooklynDslMode {
        public static AllowBrooklynDslMode ALL = new AllowBrooklynDslMode(true, null);
        public static AllowBrooklynDslMode NONE;
        public static AllowBrooklynDslMode CHILDREN_BUT_NOT_HERE;
        private Supplier<AllowBrooklynDslMode> next;
        private boolean allowedHere;

        public AllowBrooklynDslMode(boolean allowedHere, Supplier<AllowBrooklynDslMode> next) {
            this.allowedHere = allowedHere;
            this.next = next;
        }

        public boolean isAllowedHere() {
            return this.allowedHere;
        }

        public AllowBrooklynDslMode next() {
            return this.next.get();
        }

        static {
            AllowBrooklynDslMode.ALL.next = Maybe.of((Object)ALL);
            NONE = new AllowBrooklynDslMode(false, null);
            AllowBrooklynDslMode.NONE.next = Maybe.of((Object)NONE);
            CHILDREN_BUT_NOT_HERE = new AllowBrooklynDslMode(false, (Supplier<AllowBrooklynDslMode>)Maybe.of((Object)ALL));
        }
    }

    public static class WorkflowVariableRecursiveReference
    extends IllegalArgumentException {
        public WorkflowVariableRecursiveReference(String msg) {
            super(msg);
        }
    }

    static class WorkflowVariableResolutionStackEntry {
        WorkflowExecutionContext context;
        WorkflowExpressionStage stage;
        Object object;
        String settingVariable;

        WorkflowVariableResolutionStackEntry() {
        }

        public static WorkflowVariableResolutionStackEntry of(WorkflowExecutionContext context, WorkflowExpressionStage stage, Object expression) {
            WorkflowVariableResolutionStackEntry result = new WorkflowVariableResolutionStackEntry();
            result.context = context;
            result.stage = stage;
            result.object = expression;
            return result;
        }

        public static WorkflowVariableResolutionStackEntry setting(WorkflowExecutionContext context, WorkflowExpressionStage stage, String settingVariable) {
            WorkflowVariableResolutionStackEntry result = new WorkflowVariableResolutionStackEntry();
            result.context = context;
            result.stage = stage;
            result.settingVariable = settingVariable;
            return result;
        }

        public static boolean isStackForSettingVariable(Collection<WorkflowVariableResolutionStackEntry> stack, String key) {
            if (stack == null) {
                return true;
            }
            MutableList s2 = MutableList.copyOf(stack);
            Collections.reverse(s2);
            Optional<WorkflowVariableResolutionStackEntry> s = s2.stream().filter(si -> si.settingVariable != null).findFirst();
            if (!s.isPresent()) {
                return false;
            }
            return s.get().settingVariable.equals(key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowVariableResolutionStackEntry that = (WorkflowVariableResolutionStackEntry)o;
            if (this.context != null && that.context != null ? !Objects.equals(this.context.getWorkflowId(), that.context.getWorkflowId()) : !Objects.equals(this.context, that.context)) {
                return false;
            }
            if (this.stage != that.stage) {
                return false;
            }
            if (this.object != null ? !this.object.equals(that.object) : that.object != null) {
                return false;
            }
            return !(this.settingVariable != null ? !this.settingVariable.equals(that.settingVariable) : that.settingVariable != null);
        }

        public int hashCode() {
            int result = this.context != null && this.context.getWorkflowId() != null ? this.context.getWorkflowId().hashCode() : 0;
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
            result = 31 * result + (this.settingVariable != null ? this.settingVariable.hashCode() : 0);
            return result;
        }
    }

    class WorkflowUtilModel
    implements TemplateHashModel {
        WorkflowUtilModel() {
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if ("now".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(System.currentTimeMillis());
            }
            if ("now_utc".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(System.currentTimeMillis());
            }
            if ("now_instant".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(Instant.now());
            }
            if ("now_iso".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(Time.makeIso8601DateStringZ((Instant)Instant.now()));
            }
            if ("now_stamp".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(Time.makeDateStampString());
            }
            if ("now_nice".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(Time.makeDateString((Instant)Instant.now()));
            }
            if ("random".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(Math.random());
            }
            return WorkflowExpressionResolution.this.ifNoMatches();
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }

    class WorkflowStepModel
    implements TemplateHashModel {
        private WorkflowStepInstanceExecutionContext step;

        WorkflowStepModel() {
        }

        WorkflowStepModel(WorkflowStepInstanceExecutionContext step) {
            this.step = step;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if (this.step == null) {
                return WorkflowExpressionResolution.this.newWorkflowStepModelForStepId(key);
            }
            if ("name".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.step.name != null ? this.step.name : this.step.getWorkflowStepReference());
            }
            if ("task_id".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.step.taskId);
            }
            if ("step_id".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.step.stepDefinitionDeclaredId);
            }
            if ("step_index".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.step.stepIndex);
            }
            if ("input".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.step.input);
            }
            if ("output".equals(key)) {
                Pair<Object, Set<Integer>> outputOfStep = WorkflowExpressionResolution.this.context.getStepOutputAndBacktrackedSteps(this.step.stepIndex);
                MutableMap output = outputOfStep != null && outputOfStep.getLeft() != null ? outputOfStep.getLeft() : MutableMap.of();
                return TemplateProcessor.wrapAsTemplateModel(output);
            }
            return WorkflowExpressionResolution.this.ifNoMatches();
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }

    class WorkflowExplicitModel
    implements TemplateHashModel,
    TemplateProcessor.UnwrappableTemplateModel {
        WorkflowExplicitModel() {
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of((Object)WorkflowExpressionResolution.this.context);
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if ("name".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(WorkflowExpressionResolution.this.context.getName());
            }
            if ("id".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(WorkflowExpressionResolution.this.context.getWorkflowId());
            }
            if ("task_id".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(WorkflowExpressionResolution.this.context.getTaskId());
            }
            WorkflowStepInstanceExecutionContext currentStepInstance = ((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.currentStepInstance;
            WorkflowStepInstanceExecutionContext errorHandlerContext = ((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.errorHandlerContext;
            if ("error".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(errorHandlerContext != null ? errorHandlerContext.getError() : null);
            }
            if ("input".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.input);
            }
            if ("output".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(WorkflowExpressionResolution.this.context.getOutput());
            }
            if ("error_handler".equals(key)) {
                return new WorkflowStepModel(errorHandlerContext);
            }
            if ("current_step".equals(key)) {
                return new WorkflowStepModel(currentStepInstance);
            }
            if ("previous_step".equals(key)) {
                return WorkflowExpressionResolution.this.newWorkflowStepModelForStepIndex(((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.previousStepIndex);
            }
            if ("step".equals(key)) {
                return new WorkflowStepModel();
            }
            if ("util".equals(key)) {
                return new WorkflowUtilModel();
            }
            if ("var".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(WorkflowExpressionResolution.this.context.getWorkflowScratchVariables());
            }
            return WorkflowExpressionResolution.this.ifNoMatches();
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }

    public class WorkflowFreemarkerModel
    implements TemplateHashModel,
    TemplateProcessor.UnwrappableTemplateModel {
        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of((Object)WorkflowExpressionResolution.this.context);
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object prevStepOutput;
            Entity entity;
            MutableList errors = MutableList.of();
            if ("workflow".equals(key)) {
                return new WorkflowExplicitModel();
            }
            if ("entity".equals(key) && (entity = WorkflowExpressionResolution.this.context.getEntity()) != null) {
                return TemplateProcessor.EntityAndMapTemplateModel.forEntity(entity, null);
            }
            if ("output".equals(key)) {
                if (WorkflowExpressionResolution.this.context.getOutput() != null) {
                    return TemplateProcessor.wrapAsTemplateModel(WorkflowExpressionResolution.this.context.getOutput());
                }
                if (((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.currentStepInstance != null && ((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.currentStepInstance.getOutput() != null) {
                    return TemplateProcessor.wrapAsTemplateModel(((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.currentStepInstance.getOutput());
                }
                Object previousStepOutput = WorkflowExpressionResolution.this.context.getPreviousStepOutput();
                if (previousStepOutput != null) {
                    return TemplateProcessor.wrapAsTemplateModel(previousStepOutput);
                }
                return WorkflowExpressionResolution.this.ifNoMatches();
            }
            Object candidate = null;
            if (WorkflowExpressionResolution.this.stage.after(WorkflowExpressionStage.STEP_PRE_INPUT)) {
                WorkflowStepInstanceExecutionContext currentStep = ((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.currentStepInstance;
                if (currentStep != null && WorkflowExpressionResolution.this.stage.after(WorkflowExpressionStage.STEP_OUTPUT) && currentStep.getOutput() instanceof Map && (candidate = ((Map)currentStep.getOutput()).get(key)) != null) {
                    return TemplateProcessor.wrapAsTemplateModel(candidate);
                }
                try {
                    if (currentStep != null) {
                        candidate = currentStep.getInput(key, Object.class);
                    }
                }
                catch (Throwable t) {
                    Exceptions.propagateIfFatal((Throwable)t);
                    if (WorkflowExpressionResolution.this.stage == WorkflowExpressionStage.STEP_INPUT && WorkflowVariableResolutionStackEntry.isStackForSettingVariable(RESOLVE_STACK.getAll(true), key) && Exceptions.getFirstThrowableOfType((Throwable)t, WorkflowVariableRecursiveReference.class) != null) {
                        candidate = null;
                        errors.add(t);
                    }
                    throw Exceptions.propagate((Throwable)t);
                }
                if (candidate != null) {
                    return TemplateProcessor.wrapAsTemplateModel(candidate);
                }
            }
            if (WorkflowExpressionResolution.this.stage.after(WorkflowExpressionStage.WORKFLOW_INPUT) && (prevStepOutput = WorkflowExpressionResolution.this.context.getPreviousStepOutput()) instanceof Map && (candidate = ((Map)prevStepOutput).get(key)) != null) {
                return TemplateProcessor.wrapAsTemplateModel(candidate);
            }
            if (WorkflowExpressionResolution.this.stage.after(WorkflowExpressionStage.WORKFLOW_INPUT) && (candidate = WorkflowExpressionResolution.this.context.getWorkflowScratchVariables().get(key)) != null) {
                return TemplateProcessor.wrapAsTemplateModel(candidate);
            }
            if (((WorkflowExpressionResolution)WorkflowExpressionResolution.this).context.input.containsKey(key) && (candidate = WorkflowExpressionResolution.this.context.getInput(key)) != null) {
                return TemplateProcessor.wrapAsTemplateModel(candidate);
            }
            if (!errors.isEmpty()) {
                Exceptions.propagate((String)("Errors resolving " + key), (Iterable)errors);
            }
            return WorkflowExpressionResolution.this.ifNoMatches();
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }

    public static class WrappingMode {
        public final boolean wrapResolvedStrings;
        public final boolean deferThrowingError;
        public final boolean deferAndRetryErroneousExpressions;
        public final boolean deferBrooklynDsl;
        public final boolean deferInterpolation;
        public static final WrappingMode WRAPPED_RESULT_DEFER_THROWING_ERROR_BUT_NO_RETRY = new WrappingMode(true, true, false, false, false);
        public static final WrappingMode NONE = new WrappingMode(false, false, false, false, false);
        @Deprecated
        @Beta
        static final WrappingMode OLD_DEFAULT_DEFER_THROWING_ERROR_AND_DSL = new WrappingMode(true, true, false, true, false);
        @Deprecated
        @Beta
        public static final WrappingMode DEFER_RETRY_ON_ERROR_ONLY = new WrappingMode(false, false, true, false, false);
        @Deprecated
        @Beta
        public static final WrappingMode ALL_NON_STATIC = new WrappingMode(true, true, true, true, true);

        protected WrappingMode(boolean wrapResolvedStrings, boolean deferThrowingError, boolean deferAndRetryErroneousExpressions, boolean deferBrooklynDsl, boolean deferInterpolation) {
            this.wrapResolvedStrings = wrapResolvedStrings;
            this.deferThrowingError = deferThrowingError;
            this.deferAndRetryErroneousExpressions = deferAndRetryErroneousExpressions;
            this.deferBrooklynDsl = deferBrooklynDsl;
            this.deferInterpolation = deferInterpolation;
        }

        public WrappingMode wrappingModeWhenResolving() {
            return WRAPPED_RESULT_DEFER_THROWING_ERROR_BUT_NO_RETRY;
        }
    }

    public static enum WorkflowExpressionStage implements Comparable<WorkflowExpressionStage>
    {
        WORKFLOW_INPUT,
        WORKFLOW_STARTING_POST_INPUT,
        STEP_PRE_INPUT,
        STEP_INPUT,
        STEP_RUNNING,
        STEP_OUTPUT,
        STEP_FINISHING_POST_OUTPUT,
        WORKFLOW_OUTPUT;


        public boolean after(WorkflowExpressionStage other) {
            return this.compareTo(other) > 0;
        }
    }
}

