/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.javalang;

import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpExecutor;
import org.apache.brooklyn.util.http.executor.apacheclient.HttpExecutorImpl;

public class BrooklynHttpConfig {
    public static final String HTTPS_CONFIG = "brooklyn.https.config.";
    public static final ConfigKey<Boolean> TRUST_ALL = ConfigKeys.newBooleanConfigKey("brooklyn.https.config.trustAll", "Whether HTTPS and TLS connections should trust all certificates");
    public static final ConfigKey<Boolean> TRUST_SELF_SIGNED = ConfigKeys.newBooleanConfigKey("brooklyn.https.config.trustSelfSigned", "Whether HTTPS and TLS connections should trust self-signed certificates");
    public static final ConfigKey<Boolean> LAX_REDIRECT = ConfigKeys.newBooleanConfigKey("brooklyn.https.config.laxRedirect", "Whether HTTPS and TLS connections should be lax about redirecting");
    private static final boolean DEFAULT_FOR_MGMT_LAX_AND_TRUSTING = true;

    public static HttpConfig.Builder httpConfigBuilder(ManagementContext mgmt, boolean lookForContextEntity) {
        return BrooklynHttpConfig.httpConfigBuilder(mgmt, true, lookForContextEntity);
    }

    public static HttpConfig.Builder httpConfigBuilder(ManagementContext mgmt, boolean defaultLaxAndTrusting, boolean lookForContextEntity) {
        HttpConfig.Builder hcb = BrooklynHttpConfig.httpConfigBuilderDefault(defaultLaxAndTrusting, false);
        BrooklynHttpConfig.apply(hcb, arg_0 -> ((StringConfigMap)mgmt.getConfig()).getConfig(arg_0));
        if (lookForContextEntity) {
            BrooklynHttpConfig.applyContextEntity(hcb);
        }
        return hcb;
    }

    private static void apply(HttpConfig.Builder hcb, Function<ConfigKey<Boolean>, Boolean> getter) {
        BrooklynHttpConfig.applyIfNonNull(getter.apply(TRUST_ALL), arg_0 -> ((HttpConfig.Builder)hcb).trustAll(arg_0));
        BrooklynHttpConfig.applyIfNonNull(getter.apply(TRUST_SELF_SIGNED), arg_0 -> ((HttpConfig.Builder)hcb).trustSelfSigned(arg_0));
        BrooklynHttpConfig.applyIfNonNull(getter.apply(LAX_REDIRECT), arg_0 -> ((HttpConfig.Builder)hcb).laxRedirect(arg_0));
    }

    private static void applyContextEntity(HttpConfig.Builder hcb) {
        Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
        if (entity != null) {
            BrooklynHttpConfig.apply(hcb, arg_0 -> ((Configurable.ConfigurationSupport)entity.config()).get(arg_0));
        }
    }

    private static void applyIfNonNull(Boolean v, Consumer<Boolean> target) {
        if (v != null) {
            target.accept(v);
        }
    }

    public static HttpConfig.Builder httpConfigBuilder(BrooklynObject entity) {
        return BrooklynHttpConfig.httpConfigBuilder(entity, true);
    }

    public static HttpConfig.Builder httpConfigBuilder(BrooklynObject entity, boolean defaultLaxAndTrusting) {
        HttpConfig.Builder hcb = BrooklynHttpConfig.httpConfigBuilder(((BrooklynObjectInternal)entity).getManagementContext(), defaultLaxAndTrusting, false);
        BrooklynHttpConfig.apply(hcb, arg_0 -> ((Configurable.ConfigurationSupport)entity.config()).get(arg_0));
        return hcb;
    }

    private static HttpConfig.Builder httpConfigBuilderDefault(boolean laxAndTrusting, boolean lookForContextEntities) {
        HttpConfig.Builder hcb = HttpConfig.builder().laxRedirect(laxAndTrusting).trustAll(laxAndTrusting).trustSelfSigned(laxAndTrusting);
        if (lookForContextEntities) {
            BrooklynHttpConfig.applyContextEntity(hcb);
        }
        return hcb;
    }

    public static HttpTool.HttpClientBuilder httpClientBuilder(ManagementContext mgmt, boolean lookForContextEntity) {
        return BrooklynHttpConfig.httpClientBuilder(mgmt, true, lookForContextEntity);
    }

    public static HttpTool.HttpClientBuilder httpClientBuilder(ManagementContext mgmt, boolean defaultLaxAndTrusting, boolean lookForContextEntity) {
        HttpTool.HttpClientBuilder hcb = BrooklynHttpConfig.httpClientBuilderDefault(defaultLaxAndTrusting, false);
        BrooklynHttpConfig.apply(hcb, arg_0 -> ((StringConfigMap)mgmt.getConfig()).getConfig(arg_0));
        if (lookForContextEntity) {
            BrooklynHttpConfig.applyContextEntity(hcb);
        }
        return hcb;
    }

    private static void apply(HttpTool.HttpClientBuilder hcb, Function<ConfigKey<Boolean>, Boolean> getter) {
        BrooklynHttpConfig.applyIfNonNull(getter.apply(TRUST_ALL), arg_0 -> ((HttpTool.HttpClientBuilder)hcb).trustAll(arg_0));
        BrooklynHttpConfig.applyIfNonNull(getter.apply(TRUST_SELF_SIGNED), arg_0 -> ((HttpTool.HttpClientBuilder)hcb).trustSelfSigned(arg_0));
        BrooklynHttpConfig.applyIfNonNull(getter.apply(LAX_REDIRECT), arg_0 -> ((HttpTool.HttpClientBuilder)hcb).laxRedirect(arg_0));
    }

    private static void applyContextEntity(HttpTool.HttpClientBuilder hcb) {
        Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
        if (entity != null) {
            BrooklynHttpConfig.apply(hcb, arg_0 -> ((Configurable.ConfigurationSupport)entity.config()).get(arg_0));
        }
    }

    public static HttpTool.HttpClientBuilder httpClientBuilderDefaultStrict() {
        return BrooklynHttpConfig.httpClientBuilderDefault(false, false);
    }

    private static HttpTool.HttpClientBuilder httpClientBuilderDefault(boolean defaultLaxAndTrusting, boolean lookForContextEntity) {
        HttpTool.HttpClientBuilder hcb = HttpTool.httpClientBuilder();
        if (defaultLaxAndTrusting) {
            hcb.trustAll(true);
            hcb.laxRedirect(true);
        }
        if (lookForContextEntity) {
            BrooklynHttpConfig.applyContextEntity(hcb);
        }
        return hcb;
    }

    public static HttpTool.HttpClientBuilder httpClientBuilder(BrooklynObject entity) {
        return BrooklynHttpConfig.httpClientBuilder(entity, true);
    }

    public static HttpTool.HttpClientBuilder httpClientBuilder(BrooklynObject entity, boolean defaultLaxAndTrusting) {
        HttpTool.HttpClientBuilder hcb = BrooklynHttpConfig.httpClientBuilder(((BrooklynObjectInternal)entity).getManagementContext(), defaultLaxAndTrusting, false);
        BrooklynHttpConfig.apply(hcb, arg_0 -> ((Configurable.ConfigurationSupport)entity.config()).get(arg_0));
        return hcb;
    }

    public static HttpExecutor newHttpExecutor(BrooklynObject entity) {
        return HttpExecutorImpl.newInstance().withConfig(BrooklynHttpConfig.httpConfigBuilder(entity, false).build());
    }

    public static HttpExecutor newHttpExecutorDefault() {
        return HttpExecutorImpl.newInstance().withConfig(BrooklynHttpConfig.httpConfigBuilderDefault(false, true).build());
    }
}

