/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.software.base.SameServerDriverLifecycleEffectorTasks;
import org.apache.brooklyn.entity.software.base.SameServerEntity;
import org.apache.brooklyn.entity.software.base.lifecycle.MachineLifecycleEffectorTasks;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;

public class SameServerEntityImpl
extends AbstractEntity
implements SameServerEntity {
    private static final MachineLifecycleEffectorTasks LIFECYCLE_TASKS = new SameServerDriverLifecycleEffectorTasks();

    protected void initEnrichers() {
        super.initEnrichers();
        this.enrichers().add((EnricherSpec)ServiceStateLogic.newEnricherFromChildren().suppressDuplicates(true).configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.all()));
    }

    public final void restart() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doRestart(ConfigBag.EMPTY);
        } else {
            Task task = Tasks.builder().displayName("restart").body(new Runnable(){

                @Override
                public void run() {
                    SameServerEntityImpl.this.doRestart(ConfigBag.EMPTY);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void start(Collection<? extends Location> locsO) {
        this.addLocations(locsO);
        final Collection locations = Locations.getLocationsCheckingAncestors(locsO, (Entity)this);
        Preconditions.checkNotNull((Object)locations, (Object)"locations");
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doStart(locations);
        } else {
            Task task = Tasks.builder().displayName("start").body(new Runnable(){

                @Override
                public void run() {
                    SameServerEntityImpl.this.doStart(locations);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void stop() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doStop();
        } else {
            Task task = Tasks.builder().displayName("stop").body(new Runnable(){

                @Override
                public void run() {
                    SameServerEntityImpl.this.doStop();
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    protected void doStart(Collection<? extends Location> locations) {
        LIFECYCLE_TASKS.start(locations);
    }

    protected void doStop() {
        LIFECYCLE_TASKS.stop(ConfigBag.EMPTY);
    }

    protected void doRestart(ConfigBag parameters) {
        LIFECYCLE_TASKS.restart(parameters);
    }
}

