/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp;

import com.google.common.base.Preconditions;
import org.apache.brooklyn.camp.spi.ApplicationComponent;
import org.apache.brooklyn.camp.spi.ApplicationComponentTemplate;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.PlatformComponent;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;
import org.apache.brooklyn.camp.spi.PlatformTransaction;
import org.apache.brooklyn.camp.spi.collection.ResourceLookup;
import org.apache.brooklyn.camp.spi.resolve.PdpProcessor;

public abstract class CampPlatform {
    private final PlatformRootSummary root;
    private final PdpProcessor pdp;

    public CampPlatform(PlatformRootSummary root) {
        this.root = (PlatformRootSummary)Preconditions.checkNotNull((Object)root, (Object)"root");
        this.pdp = this.createPdpProcessor();
    }

    public PlatformRootSummary root() {
        return this.root;
    }

    public PdpProcessor pdp() {
        return this.pdp;
    }

    public abstract ResourceLookup<PlatformComponentTemplate> platformComponentTemplates();

    public abstract ResourceLookup<ApplicationComponentTemplate> applicationComponentTemplates();

    public abstract ResourceLookup<AssemblyTemplate> assemblyTemplates();

    public abstract ResourceLookup<PlatformComponent> platformComponents();

    public abstract ResourceLookup<ApplicationComponent> applicationComponents();

    public abstract ResourceLookup<Assembly> assemblies();

    public abstract PlatformTransaction transaction();

    protected PdpProcessor createPdpProcessor() {
        return new PdpProcessor(this);
    }
}

