/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.UiModuleAction;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.brooklyn.ui.external.module"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
public class ExternalUiModule
implements UiModule {
    static final String PID = "org.apache.brooklyn.ui.external.module";
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.brooklyn.ui.external.module");
    private static final Dictionary<String, ?> EMPTY_DICTIONARY = new Hashtable();
    private final String MODULE_TYPE = "external-ui-module";
    private final String KEY_ID = "service.pid";
    private final String KEY_NAME = "name";
    private final String KEY_URL = "url";
    private final String KEY_ICON = "icon";
    private final String KEY_TYPES = "types";
    private final String[] REQUIRED_KEYS = new String[]{"service.pid", "name", "url", "icon"};
    private final String KEY_SUPERSEDES = "supersedes";
    private final String KEY_STOP_EXISTING = "stopExisting";
    private String id;
    private String name;
    private String icon;
    private String url;
    private Set<String> types;
    private Set<String> supersedes;
    private boolean stopExisting;

    @Activate
    public void activate(Map<String, String> properties) {
        LOG.debug("Activating module " + this + ": " + properties);
        if (!properties.containsKey("url") && properties.containsKey("component.id")) {
            LOG.debug("Not setting module properties for activation properties " + properties);
        } else {
            this.setModuleProperties(properties);
        }
    }

    @Modified
    public void modified(Map<String, String> properties) {
        LOG.debug("Modified module " + this + ": " + properties);
        this.setModuleProperties(properties);
    }

    private void setModuleProperties(Map<String, String> properties) {
        MutableList issues = MutableList.of();
        for (String requiredKey : this.REQUIRED_KEYS) {
            if (properties.containsKey(requiredKey)) continue;
            issues.add("Key [" + requiredKey + "] is required");
        }
        if (issues.size() > 0) {
            LOG.error("Invalid UI module (ignoring) [" + properties.get("service.pid") + "] ... " + issues.toString() + "; properties: " + properties, new Throwable("source of error"));
            return;
        }
        this.id = properties.get("service.pid");
        this.name = properties.get("name");
        this.icon = properties.get("icon");
        this.url = properties.get("url");
        this.types = MutableSet.of((Object)"external-ui-module");
        String userTypes = properties.get("types");
        if (userTypes != null) {
            this.types.addAll(Arrays.asList(userTypes.split(",")));
        }
        this.supersedes = MutableSet.of((Object)"external-ui-module");
        String userSupersedes = properties.get("supersedes");
        if (userSupersedes != null) {
            this.supersedes.addAll(Arrays.asList(userSupersedes.split(",")));
        }
        this.stopExisting = properties.get("stopExisting") != null ? Boolean.parseBoolean(properties.get("stopExisting")) : true;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.id;
    }

    public String getDescription() {
        return null;
    }

    public String getIcon() {
        return this.icon;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public Set<String> getSupersedesBundles() {
        return this.supersedes;
    }

    public boolean getStopExisting() {
        return this.stopExisting;
    }

    public String getPath() {
        return this.url;
    }

    public List<UiModuleAction> getActions() {
        return ImmutableList.of();
    }
}

