/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.winrm.winrm4j;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.winrm.WinRmTool;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmException;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class Winrm4jTool
implements WinRmTool,
ManagementContextInjectable {
    private static final Logger LOG = LoggerFactory.getLogger(Winrm4jTool.class);
    private static final ConfigKey<WinRmClientContext> CONTEXT = ConfigKeys.newConfigKey(WinRmClientContext.class, (String)"winrm.context");
    @Beta
    public static final ConfigKey<Boolean> LOG_CREDENTIALS = ConfigKeys.newBooleanConfigKey((String)"logCredentials", (String)"Whether to log the WinRM credentials used - strongly recommended never be used in production, as it is a big security hole!", (Boolean)false);
    private final ConfigBag bag;
    private final String host;
    private final Integer port;
    private final String computerName;
    private final String user;
    private final String password;
    private final int execTries;
    private final Duration execRetryDelay;
    private final boolean logCredentials;
    private final Boolean useSecureWinrm;
    private final String authenticationScheme;
    private final String operationTimeout;
    private final Integer retriesOfNetworkFailures;
    private final Map<String, String> environment;
    private ManagementContext mgmt;

    public Winrm4jTool(Map<String, ?> config) {
        this(ConfigBag.newInstance(config));
    }

    public Winrm4jTool(ConfigBag config) {
        this.bag = (ConfigBag)Preconditions.checkNotNull((Object)config, (Object)"config bag");
        this.host = (String)this.getRequiredConfig(config, PROP_HOST);
        this.port = (Integer)config.get(PROP_PORT);
        this.useSecureWinrm = (Boolean)config.get(USE_HTTPS_WINRM);
        this.authenticationScheme = (Boolean)config.get(USE_NTLM) != false ? "NTLM" : null;
        this.computerName = Strings.isNonBlank((CharSequence)((CharSequence)config.get(COMPUTER_NAME))) ? (String)config.get(COMPUTER_NAME) : null;
        this.user = (String)this.getRequiredConfig(config, PROP_USER);
        this.password = (String)this.getRequiredConfig(config, PROP_PASSWORD);
        this.execTries = (Integer)this.getRequiredConfig(config, PROP_EXEC_TRIES);
        this.execRetryDelay = (Duration)this.getRequiredConfig(config, PROP_EXEC_RETRY_DELAY);
        this.logCredentials = this.getRequiredConfig(config, LOG_CREDENTIALS);
        this.operationTimeout = (String)config.get(OPERATION_TIMEOUT);
        this.retriesOfNetworkFailures = (Integer)config.get(RETRIES_OF_NETWORK_FAILURES);
        this.environment = (Map)config.get(ENVIRONMENT);
    }

    public void setManagementContext(ManagementContext managementContext) {
        this.mgmt = managementContext;
    }

    @Override
    public WinRmToolResponse executeCommand(List<String> commands) {
        return this.exec((Function<io.cloudsoft.winrm4j.winrm.WinRmTool, io.cloudsoft.winrm4j.winrm.WinRmToolResponse>)((Function)tool -> {
            OutputStream outputStream = (OutputStream)this.bag.get(ShellTool.PROP_OUT_STREAM);
            OutputStream errorStream = (OutputStream)this.bag.get(ShellTool.PROP_ERR_STREAM);
            Writer out = outputStream != null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : new StringWriter();
            Writer err = errorStream != null ? new BufferedWriter(new OutputStreamWriter(errorStream)) : new StringWriter();
            return tool.executeCommand(commands, out, err);
        }));
    }

    @Override
    @Deprecated
    public WinRmToolResponse executeScript(List<String> commands) {
        return this.executeCommand(commands);
    }

    @Override
    public WinRmToolResponse executePs(List<String> commands) {
        return this.exec((Function<io.cloudsoft.winrm4j.winrm.WinRmTool, io.cloudsoft.winrm4j.winrm.WinRmToolResponse>)((Function)tool -> {
            OutputStream outputStream = (OutputStream)this.bag.get(ShellTool.PROP_OUT_STREAM);
            OutputStream errorStream = (OutputStream)this.bag.get(ShellTool.PROP_ERR_STREAM);
            Writer out = outputStream != null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : new StringWriter();
            Writer err = errorStream != null ? new BufferedWriter(new OutputStreamWriter(errorStream)) : new StringWriter();
            return tool.executePs(commands, out, err);
        }));
    }

    @Override
    public WinRmToolResponse copyToServer(InputStream source, String destination) {
        this.executePs((List<String>)ImmutableList.of((Object)("rm -ErrorAction SilentlyContinue " + destination)));
        try {
            int bytesRead;
            int chunkSize = (Integer)this.getRequiredConfig(this.bag, COPY_FILE_CHUNK_SIZE_BYTES);
            byte[] inputData = new byte[chunkSize];
            int expectedFileSize = 0;
            int i = 0;
            while ((bytesRead = source.read(inputData)) > 0) {
                LOG.debug("Copying chunk " + ++i + " to " + destination + " on " + this.host);
                byte[] chunk = bytesRead == chunkSize ? inputData : Arrays.copyOf(inputData, bytesRead);
                this.executePs((List<String>)ImmutableList.of((Object)("If ((!(Test-Path " + destination + ")) -or ((Get-Item '" + destination + "').length -eq " + expectedFileSize + ")) {Add-Content -Encoding Byte -path " + destination + " -value ([System.Convert]::FromBase64String(\"" + new String(Base64.encodeBase64((byte[])chunk)) + "\"))}")));
                expectedFileSize += bytesRead;
            }
            LOG.debug("Finished copying to " + destination + " on " + this.host);
            return new WinRmToolResponse("", "", 0);
        }
        catch (IOException e) {
            throw this.propagate(e, "Failed copying to server at " + destination);
        }
    }

    private WinRmToolResponse exec(Function<io.cloudsoft.winrm4j.winrm.WinRmTool, io.cloudsoft.winrm4j.winrm.WinRmToolResponse> task) {
        ArrayList exceptions = Lists.newArrayList();
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        for (int i = 0; i < this.execTries; ++i) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Duration connectTimestamp = null;
            Duration execTimestamp = null;
            try {
                io.cloudsoft.winrm4j.winrm.WinRmTool tool = this.connect();
                tool.setRetriesForConnectionFailures(this.retriesOfNetworkFailures);
                tool.setOperationTimeout(Long.valueOf(Duration.of((Object)this.operationTimeout).toMilliseconds()));
                connectTimestamp = Duration.of((Object)stopwatch);
                io.cloudsoft.winrm4j.winrm.WinRmToolResponse result = (io.cloudsoft.winrm4j.winrm.WinRmToolResponse)task.apply((Object)tool);
                execTimestamp = Duration.of((Object)stopwatch);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished WinRM exec on " + this.user + "@" + this.host + ":" + this.port + " " + (this.logCredentials ? "password=" + this.password : "") + " done after " + Duration.of((Object)execTimestamp).toStringRounded() + " (connected in " + Duration.of((Object)connectTimestamp).toStringRounded() + ")");
                }
                return this.wrap(result);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                Duration sleep = Duration.millis((Number)Math.min(Math.pow(2.0, i) * 1000.0, (double)this.execRetryDelay.toMilliseconds()));
                Duration failTimestamp = Duration.of((Object)stopwatch);
                String timeMsg = "total time " + Duration.of((Object)totalStopwatch).toStringRounded() + ", this attempt failed after " + Duration.of((Object)failTimestamp).toStringRounded() + (connectTimestamp != null ? ", connected in " + Duration.of((Object)connectTimestamp).toStringRounded() : "");
                if (i + 1 == this.execTries) {
                    LOG.info("Propagating exception - WinRM failed on " + this.user + "@" + this.host + ":" + this.port + " " + (this.logCredentials ? "password=" + this.password : "") + "; (attempt " + (i + 1) + " of " + this.execTries + "; " + timeMsg + ")", (Throwable)e);
                } else if (i == 0) {
                    LOG.warn("Ignoring WinRM exception on " + this.user + "@" + this.host + ":" + this.port + " " + (this.logCredentials ? "password=" + this.password : "") + " and will retry after " + sleep + " (attempt " + (i + 1) + " of " + this.execTries + "; " + timeMsg + ")", (Throwable)e);
                    Time.sleep((Duration)sleep);
                } else {
                    LOG.debug("Ignoring WinRM exception on " + this.user + "@" + this.host + ":" + this.port + " " + (this.logCredentials ? "password=" + this.password : "") + " and will retry after " + sleep + " (attempt " + (i + 1) + " of " + this.execTries + "; " + timeMsg + ")", (Throwable)e);
                    Time.sleep((Duration)sleep);
                }
                exceptions.add(e);
                continue;
            }
        }
        throw this.propagate(Exceptions.create((String)"failed to execute command", (Iterable)exceptions), "");
    }

    private io.cloudsoft.winrm4j.winrm.WinRmTool connect() {
        WinRmTool.Builder builder = WinRmTool.Builder.builder((String)this.host, (String)this.computerName, (String)this.user, (String)this.password).setAuthenticationScheme(this.authenticationScheme).useHttps(this.useSecureWinrm.booleanValue()).port(this.port.intValue());
        if (this.environment != null) {
            builder.environment(this.environment);
        }
        if (this.useSecureWinrm.booleanValue()) {
            builder.disableCertificateChecks(true);
        }
        return builder.build();
    }

    private <T> T getRequiredConfig(ConfigBag bag, ConfigKey<T> key) {
        Object result = bag.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Missing config " + key + " in " + Sanitizer.sanitize((ConfigBag)bag));
        }
        return (T)result;
    }

    private WinRmToolResponse wrap(io.cloudsoft.winrm4j.winrm.WinRmToolResponse resp) {
        return new WinRmToolResponse(resp.getStdOut(), resp.getStdErr(), resp.getStatusCode());
    }

    public String toString() {
        return String.format("%s@%s:%d", this.user, this.host, this.port);
    }

    protected WinRmException propagate(Exception e, String message) throws WinRmException {
        Exceptions.propagateIfFatal((Throwable)e);
        throw new WinRmException("(" + this.toString() + ") " + message + ": " + e.getMessage(), e);
    }
}

