/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.Spec;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSource;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSourceBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSourceFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSourceRef;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSourceRefBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSourceRefFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.Resources;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.ResourcesBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.ResourcesFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.Selector;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.SelectorBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.SelectorFluent;

public class SpecFluent<A extends SpecFluent<A>>
extends BaseFluent<A> {
    private List<String> accessModes;
    private DataSourceBuilder dataSource;
    private DataSourceRefBuilder dataSourceRef;
    private ResourcesBuilder resources;
    private SelectorBuilder selector;
    private String storageClassName;
    private String volumeAttributesClassName;
    private String volumeMode;
    private String volumeName;

    public SpecFluent() {
    }

    public SpecFluent(Spec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Spec instance) {
        Spec spec = instance = instance != null ? instance : new Spec();
        if (instance != null) {
            this.withAccessModes(instance.getAccessModes());
            this.withDataSource(instance.getDataSource());
            this.withDataSourceRef(instance.getDataSourceRef());
            this.withResources(instance.getResources());
            this.withSelector(instance.getSelector());
            this.withStorageClassName(instance.getStorageClassName());
            this.withVolumeAttributesClassName(instance.getVolumeAttributesClassName());
            this.withVolumeMode(instance.getVolumeMode());
            this.withVolumeName(instance.getVolumeName());
        }
    }

    public A addToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)((Object)this);
    }

    public A setToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.set(index, item);
        return (A)((Object)this);
    }

    public A addToAccessModes(String ... items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAccessModes(String ... items) {
        if (this.accessModes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAccessModes(List<String> accessModes) {
        if (accessModes != null) {
            this.accessModes = new ArrayList<String>();
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        } else {
            this.accessModes = null;
        }
        return (A)((Object)this);
    }

    public A withAccessModes(String ... accessModes) {
        if (this.accessModes != null) {
            this.accessModes.clear();
            this._visitables.remove((Object)"accessModes");
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    public DataSource buildDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    public A withDataSource(DataSource dataSource) {
        this._visitables.remove((Object)"dataSource");
        if (dataSource != null) {
            this.dataSource = new DataSourceBuilder(dataSource);
            this._visitables.get((Object)"dataSource").add(this.dataSource);
        } else {
            this.dataSource = null;
            this._visitables.get((Object)"dataSource").remove((Object)this.dataSource);
        }
        return (A)((Object)this);
    }

    public boolean hasDataSource() {
        return this.dataSource != null;
    }

    public DataSourceNested<A> withNewDataSource() {
        return new DataSourceNested(null);
    }

    public DataSourceNested<A> withNewDataSourceLike(DataSource item) {
        return new DataSourceNested(item);
    }

    public DataSourceNested<A> editIntegrationDataSource() {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(null));
    }

    public DataSourceNested<A> editOrNewDataSource() {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(new DataSourceBuilder().build()));
    }

    public DataSourceNested<A> editOrNewDataSourceLike(DataSource item) {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(item));
    }

    public DataSourceRef buildDataSourceRef() {
        return this.dataSourceRef != null ? this.dataSourceRef.build() : null;
    }

    public A withDataSourceRef(DataSourceRef dataSourceRef) {
        this._visitables.remove((Object)"dataSourceRef");
        if (dataSourceRef != null) {
            this.dataSourceRef = new DataSourceRefBuilder(dataSourceRef);
            this._visitables.get((Object)"dataSourceRef").add(this.dataSourceRef);
        } else {
            this.dataSourceRef = null;
            this._visitables.get((Object)"dataSourceRef").remove((Object)this.dataSourceRef);
        }
        return (A)((Object)this);
    }

    public boolean hasDataSourceRef() {
        return this.dataSourceRef != null;
    }

    public DataSourceRefNested<A> withNewDataSourceRef() {
        return new DataSourceRefNested(null);
    }

    public DataSourceRefNested<A> withNewDataSourceRefLike(DataSourceRef item) {
        return new DataSourceRefNested(item);
    }

    public DataSourceRefNested<A> editIntegrationDataSourceRef() {
        return this.withNewDataSourceRefLike(Optional.ofNullable(this.buildDataSourceRef()).orElse(null));
    }

    public DataSourceRefNested<A> editOrNewDataSourceRef() {
        return this.withNewDataSourceRefLike(Optional.ofNullable(this.buildDataSourceRef()).orElse(new DataSourceRefBuilder().build()));
    }

    public DataSourceRefNested<A> editOrNewDataSourceRefLike(DataSourceRef item) {
        return this.withNewDataSourceRefLike(Optional.ofNullable(this.buildDataSourceRef()).orElse(item));
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editSpecResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Selector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(Selector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new SelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove((Object)this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(Selector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editIntegrationSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new SelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(Selector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)((Object)this);
    }

    public boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    public String getVolumeAttributesClassName() {
        return this.volumeAttributesClassName;
    }

    public A withVolumeAttributesClassName(String volumeAttributesClassName) {
        this.volumeAttributesClassName = volumeAttributesClassName;
        return (A)((Object)this);
    }

    public boolean hasVolumeAttributesClassName() {
        return this.volumeAttributesClassName != null;
    }

    public String getVolumeMode() {
        return this.volumeMode;
    }

    public A withVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return (A)((Object)this);
    }

    public boolean hasVolumeMode() {
        return this.volumeMode != null;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)((Object)this);
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecFluent that = (SpecFluent)((Object)o);
        if (!Objects.equals(this.accessModes, that.accessModes)) {
            return false;
        }
        if (!Objects.equals((Object)this.dataSource, (Object)that.dataSource)) {
            return false;
        }
        if (!Objects.equals((Object)this.dataSourceRef, (Object)that.dataSourceRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.selector, (Object)that.selector)) {
            return false;
        }
        if (!Objects.equals(this.storageClassName, that.storageClassName)) {
            return false;
        }
        if (!Objects.equals(this.volumeAttributesClassName, that.volumeAttributesClassName)) {
            return false;
        }
        if (!Objects.equals(this.volumeMode, that.volumeMode)) {
            return false;
        }
        return Objects.equals(this.volumeName, that.volumeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessModes, this.dataSource, this.dataSourceRef, this.resources, this.selector, this.storageClassName, this.volumeAttributesClassName, this.volumeMode, this.volumeName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessModes != null && !this.accessModes.isEmpty()) {
            sb.append("accessModes:");
            sb.append(this.accessModes + ",");
        }
        if (this.dataSource != null) {
            sb.append("dataSource:");
            sb.append(this.dataSource + ",");
        }
        if (this.dataSourceRef != null) {
            sb.append("dataSourceRef:");
            sb.append(this.dataSourceRef + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.storageClassName != null) {
            sb.append("storageClassName:");
            sb.append(this.storageClassName + ",");
        }
        if (this.volumeAttributesClassName != null) {
            sb.append("volumeAttributesClassName:");
            sb.append(this.volumeAttributesClassName + ",");
        }
        if (this.volumeMode != null) {
            sb.append("volumeMode:");
            sb.append(this.volumeMode + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DataSourceNested<N>
    extends DataSourceFluent<DataSourceNested<N>>
    implements Nested<N> {
        DataSourceBuilder builder;

        DataSourceNested(DataSource item) {
            this.builder = new DataSourceBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.withDataSource(this.builder.build());
        }

        public N endIntegrationDataSource() {
            return this.and();
        }
    }

    public class DataSourceRefNested<N>
    extends DataSourceRefFluent<DataSourceRefNested<N>>
    implements Nested<N> {
        DataSourceRefBuilder builder;

        DataSourceRefNested(DataSourceRef item) {
            this.builder = new DataSourceRefBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.withDataSourceRef(this.builder.build());
        }

        public N endIntegrationDataSourceRef() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.withResources(this.builder.build());
        }

        public N endSpecResources() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends SelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        SelectorBuilder builder;

        SelectorNested(Selector item) {
            this.builder = new SelectorBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.withSelector(this.builder.build());
        }

        public N endIntegrationSelector() {
            return this.and();
        }
    }
}

