/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.wrapper.BootstrapMainStarter;
import org.apache.maven.wrapper.DefaultDownloader;
import org.apache.maven.wrapper.HashAlgorithmVerifier;
import org.apache.maven.wrapper.Installer;
import org.apache.maven.wrapper.Logger;
import org.apache.maven.wrapper.PathAssembler;
import org.apache.maven.wrapper.SystemPropertiesHandler;
import org.apache.maven.wrapper.WrapperExecutor;
import org.apache.maven.wrapper.cli.CommandLineParser;
import org.apache.maven.wrapper.cli.SystemPropertiesCommandLineConverter;

public class MavenWrapperMain {
    private static final String POM_PROPERTIES = "/META-INF/maven/org.apache.maven.wrapper/maven-wrapper/pom.properties";
    private static final Path DEFAULT_MAVEN_USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2");
    public static final String MAVEN_USER_HOME_PROPERTY_KEY = "maven.user.home";
    public static final String MAVEN_USER_HOME_ENV_KEY = "MAVEN_USER_HOME";
    public static final String MVNW_VERBOSE = "MVNW_VERBOSE";
    public static final String MVNW_USERNAME = "MVNW_USERNAME";
    public static final String MVNW_PASSWORD = "MVNW_PASSWORD";
    public static final String MVNW_REPOURL = "MVNW_REPOURL";

    public static void main(String[] args) throws Exception {
        Path wrapperJar = MavenWrapperMain.wrapperJar();
        Path propertiesFile = MavenWrapperMain.wrapperProperties(wrapperJar);
        Path rootDir = MavenWrapperMain.rootDir(wrapperJar);
        String wrapperVersion = MavenWrapperMain.wrapperVersion();
        Logger.info("Apache Maven Wrapper " + wrapperVersion);
        Properties systemProperties = System.getProperties();
        systemProperties.putAll(MavenWrapperMain.parseSystemPropertiesFromArgs(args));
        MavenWrapperMain.addSystemProperties(rootDir);
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile(propertiesFile);
        wrapperExecutor.execute(args, new Installer(new DefaultDownloader("mvnw", wrapperVersion), new HashAlgorithmVerifier(), new PathAssembler(MavenWrapperMain.mavenUserHome())), new BootstrapMainStarter());
    }

    private static Map<String, String> parseSystemPropertiesFromArgs(String[] args) {
        SystemPropertiesCommandLineConverter converter = new SystemPropertiesCommandLineConverter();
        CommandLineParser commandLineParser = new CommandLineParser();
        converter.configure(commandLineParser);
        commandLineParser.allowUnknownOptions();
        return (Map)converter.convert(commandLineParser.parse(args));
    }

    private static void addSystemProperties(Path rootDir) {
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(MavenWrapperMain.mavenUserHome().resolve("maven.properties")));
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(rootDir.resolve("maven.properties")));
    }

    private static Path rootDir(Path wrapperJar) {
        return wrapperJar.getParent().getParent().getParent();
    }

    private static Path wrapperProperties(Path wrapperJar) {
        return wrapperJar.resolveSibling(wrapperJar.getFileName().toString().replaceFirst("\\.jar$", ".properties"));
    }

    private static Path wrapperJar() {
        URI location;
        try {
            location = MavenWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!"file".equals(location.getScheme())) {
            throw new RuntimeException(String.format(Locale.ROOT, "Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        return Paths.get(location);
    }

    static String wrapperVersion() {
        String string;
        block9: {
            InputStream resourceAsStream = MavenWrapperMain.class.getResourceAsStream(POM_PROPERTIES);
            try {
                if (resourceAsStream == null) {
                    throw new IllegalStateException("/META-INF/maven/org.apache.maven.wrapper/maven-wrapper/pom.properties not found.");
                }
                Properties mavenProperties = new Properties();
                mavenProperties.load(resourceAsStream);
                String version = mavenProperties.getProperty("version");
                Objects.requireNonNull(version, "No version specified in /META-INF/maven/org.apache.maven.wrapper/maven-wrapper/pom.properties");
                string = version;
                if (resourceAsStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not determine wrapper version.", e);
                }
            }
            resourceAsStream.close();
        }
        return string;
    }

    private static Path mavenUserHome() {
        String mavenUserHome = System.getProperty(MAVEN_USER_HOME_PROPERTY_KEY);
        if (mavenUserHome == null) {
            mavenUserHome = System.getenv(MAVEN_USER_HOME_ENV_KEY);
        }
        return mavenUserHome == null ? DEFAULT_MAVEN_USER_HOME : Paths.get(mavenUserHome, new String[0]);
    }
}

