/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import org.apache.cassandra.sidecar.config.CacheConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.utils.SSTableImporter;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheFactory.class);
    private final Cache<SSTableImporter.ImportOptions, Future<Void>> ssTableImportCache;

    @Inject
    public CacheFactory(ServiceConfiguration configuration, SSTableImporter ssTableImporter) {
        this(configuration, ssTableImporter, Ticker.systemTicker());
    }

    @VisibleForTesting
    CacheFactory(ServiceConfiguration configuration, SSTableImporter ssTableImporter, Ticker ticker) {
        this.ssTableImportCache = this.initSSTableImportCache(configuration.sstableImportConfiguration().cacheConfiguration(), ssTableImporter, ticker);
    }

    public Cache<SSTableImporter.ImportOptions, Future<Void>> ssTableImportCache() {
        return this.ssTableImportCache;
    }

    protected Cache<SSTableImporter.ImportOptions, Future<Void>> initSSTableImportCache(CacheConfiguration configuration, SSTableImporter ssTableImporter, Ticker ticker) {
        long maximumSize = configuration.maximumSize();
        LOGGER.info("Building SSTable Import Cache with expireAfterAccess={}, maxSize={}", (Object)configuration.expireAfterAccess(), (Object)maximumSize);
        return Caffeine.newBuilder().ticker(ticker).executor(MoreExecutors.directExecutor()).expireAfterAccess(configuration.expireAfterAccess().quantity(), configuration.expireAfterAccess().unit()).maximumSize(maximumSize).recordStats().removalListener((options, result, cause) -> {
            LOGGER.debug("Removed entry '{}' with options '{}' from SSTable Import Cache and cause {}", new Object[]{result, options, cause});
            ssTableImporter.cancelImport((SSTableImporter.ImportOptions)options);
        }).build();
    }
}

