/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.IncludeTableFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;

public final class FiltersConfigBuilder {
    private final ReverseEngineering engineering;

    public FiltersConfigBuilder(ReverseEngineering engineering) {
        this.engineering = engineering;
    }

    public FiltersConfig build() {
        this.compact();
        return new FiltersConfig(this.transformCatalogs(this.engineering.getCatalogs()));
    }

    private CatalogFilter[] transformCatalogs(Collection<Catalog> catalogs) {
        CatalogFilter[] catalogFilters = new CatalogFilter[catalogs.size()];
        int i = 0;
        for (Catalog catalog : catalogs) {
            catalogFilters[i] = new CatalogFilter(catalog.getName(), this.transformSchemas(catalog.getSchemas()));
            ++i;
        }
        return catalogFilters;
    }

    private SchemaFilter[] transformSchemas(Collection<Schema> schemas) {
        SchemaFilter[] schemaFilters = new SchemaFilter[schemas.size()];
        int i = 0;
        for (Schema schema : schemas) {
            schemaFilters[i] = new SchemaFilter(schema.getName(), new TableFilter(this.transformIncludeTable(schema.getIncludeTables()), this.transformExcludeTable(schema.getExcludeTables())), this.transform(schema.getIncludeProcedures(), schema.getExcludeProcedures()));
            ++i;
        }
        return schemaFilters;
    }

    private SortedSet<Pattern> transformExcludeTable(Collection<ExcludeTable> excludeTables) {
        TreeSet<Pattern> res = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        for (ExcludeTable exclude : excludeTables) {
            res.add(PatternFilter.pattern(exclude.getPattern()));
        }
        return res;
    }

    private SortedSet<IncludeTableFilter> transformIncludeTable(Collection<IncludeTable> includeTables) {
        TreeSet<IncludeTableFilter> includeTableFilters = new TreeSet<IncludeTableFilter>();
        for (IncludeTable includeTable : includeTables) {
            includeTableFilters.add(new IncludeTableFilter(includeTable.getPattern(), this.transform(includeTable.getIncludeColumns(), includeTable.getExcludeColumns())));
        }
        return includeTableFilters;
    }

    private PatternFilter transform(Collection<? extends PatternParam> include, Collection<? extends PatternParam> exclude) {
        PatternFilter filter = new PatternFilter();
        for (PatternParam patternParam : include) {
            filter.include(patternParam.getPattern());
        }
        for (PatternParam patternParam : exclude) {
            filter.exclude(patternParam.getPattern());
        }
        return filter;
    }

    void compact() {
        this.addEmptyElements();
        this.compactColumnFilters();
        this.compactTableFilter();
        this.compactProcedureFilter();
        this.compactSchemas();
        this.clearGlobalFilters();
    }

    private void compactSchemas() {
        for (Catalog catalog : this.engineering.getCatalogs()) {
            catalog.getSchemas().addAll(this.engineering.getSchemas());
        }
    }

    private void compactProcedureFilter() {
        Collection<IncludeProcedure> engIncludeProcedures = this.engineering.getIncludeProcedures();
        Collection<ExcludeProcedure> engExcludeProcedures = this.engineering.getExcludeProcedures();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            Collection<IncludeProcedure> catalogIncludeProcedures = catalog.getIncludeProcedures();
            Collection<ExcludeProcedure> catalogExcludeProcedures = catalog.getExcludeProcedures();
            for (Schema schema : catalog.getSchemas()) {
                schema.getIncludeProcedures().addAll(engIncludeProcedures);
                schema.getIncludeProcedures().addAll(catalogIncludeProcedures);
                schema.getExcludeProcedures().addAll(engExcludeProcedures);
                schema.getExcludeProcedures().addAll(catalogExcludeProcedures);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            schema.getIncludeProcedures().addAll(engIncludeProcedures);
            schema.getExcludeProcedures().addAll(engExcludeProcedures);
        }
    }

    private void compactTableFilter() {
        Collection<IncludeTable> engIncludeTables = this.engineering.getIncludeTables();
        Collection<ExcludeTable> engExcludeTables = this.engineering.getExcludeTables();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            Collection<IncludeTable> catalogIncludeTables = catalog.getIncludeTables();
            Collection<ExcludeTable> catalogExcludeTables = catalog.getExcludeTables();
            for (Schema schema : catalog.getSchemas()) {
                schema.getIncludeTables().addAll(engIncludeTables);
                schema.getIncludeTables().addAll(catalogIncludeTables);
                schema.getExcludeTables().addAll(engExcludeTables);
                schema.getExcludeTables().addAll(catalogExcludeTables);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            schema.getIncludeTables().addAll(engIncludeTables);
            schema.getExcludeTables().addAll(engExcludeTables);
        }
    }

    private void compactColumnFilters() {
        Collection<IncludeColumn> engIncludeColumns = this.engineering.getIncludeColumns();
        Collection<ExcludeColumn> engExcludeColumns = this.engineering.getExcludeColumns();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            Collection<IncludeColumn> catalogIncludeColumns = catalog.getIncludeColumns();
            Collection<ExcludeColumn> catalogExcludeColumns = catalog.getExcludeColumns();
            for (Schema schema : catalog.getSchemas()) {
                Collection<IncludeColumn> schemaIncludeColumns = schema.getIncludeColumns();
                Collection<ExcludeColumn> schemaExcludeColumns = schema.getExcludeColumns();
                for (IncludeTable includeTable : schema.getIncludeTables()) {
                    includeTable.getIncludeColumns().addAll(engIncludeColumns);
                    includeTable.getIncludeColumns().addAll(catalogIncludeColumns);
                    includeTable.getIncludeColumns().addAll(schemaIncludeColumns);
                    includeTable.getExcludeColumns().addAll(engExcludeColumns);
                    includeTable.getExcludeColumns().addAll(catalogExcludeColumns);
                    includeTable.getExcludeColumns().addAll(schemaExcludeColumns);
                }
            }
            for (IncludeTable includeTable : catalog.getIncludeTables()) {
                includeTable.getIncludeColumns().addAll(engIncludeColumns);
                includeTable.getIncludeColumns().addAll(catalogIncludeColumns);
                includeTable.getExcludeColumns().addAll(engExcludeColumns);
                includeTable.getExcludeColumns().addAll(catalogExcludeColumns);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            Collection<IncludeColumn> schemaIncludeColumns = schema.getIncludeColumns();
            Collection<ExcludeColumn> schemaExcludeColumns = schema.getExcludeColumns();
            for (IncludeTable includeTable : schema.getIncludeTables()) {
                includeTable.getIncludeColumns().addAll(engIncludeColumns);
                includeTable.getIncludeColumns().addAll(schemaIncludeColumns);
                includeTable.getExcludeColumns().addAll(engExcludeColumns);
                includeTable.getExcludeColumns().addAll(schemaExcludeColumns);
            }
        }
        for (IncludeTable includeTable : this.engineering.getIncludeTables()) {
            includeTable.getIncludeColumns().addAll(engIncludeColumns);
            includeTable.getExcludeColumns().addAll(engExcludeColumns);
        }
    }

    private void clearGlobalFilters() {
        for (Catalog catalog : this.engineering.getCatalogs()) {
            catalog.clearIncludeTables();
            catalog.clearExcludeTables();
            catalog.clearIncludeProcedures();
            catalog.clearExcludeProcedures();
            catalog.clearIncludeColumns();
            catalog.clearExcludeColumns();
            for (Schema schema : catalog.getSchemas()) {
                schema.clearIncludeColumns();
                schema.clearExcludeColumns();
            }
        }
        this.engineering.clearIncludeTables();
        this.engineering.clearExcludeTables();
        this.engineering.clearIncludeProcedures();
        this.engineering.clearExcludeProcedures();
        this.engineering.clearIncludeColumns();
        this.engineering.clearExcludeColumns();
        this.engineering.getSchemas().clear();
    }

    private void addEmptyElements() {
        if (this.engineering.getCatalogs().isEmpty()) {
            this.engineering.addCatalog(new Catalog());
        }
        for (Catalog catalog : this.engineering.getCatalogs()) {
            if (catalog.getSchemas().isEmpty() && this.engineering.getSchemas().isEmpty()) {
                catalog.addSchema(new Schema());
            }
            for (Schema schema : catalog.getSchemas()) {
                if (!schema.getIncludeTables().isEmpty() || !catalog.getIncludeTables().isEmpty() || !this.engineering.getIncludeTables().isEmpty()) continue;
                schema.addIncludeTable(new IncludeTable());
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            if (!schema.getIncludeTables().isEmpty() || !this.engineering.getIncludeTables().isEmpty()) continue;
            schema.addIncludeTable(new IncludeTable());
        }
    }
}

