/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.cayenne.modeler.util.CayenneDialog;

public class DbActionOptionsDialog
extends CayenneDialog {
    protected static final String WILDCARD_PATTERN = ".*";
    public static final int CANCEL = 0;
    public static final int SELECT = 1;
    private int choice;
    private JLabel schemaLabel;
    private JLabel catalogLabel;
    private JComboBox<String> catalogSelector;
    private JComboBox<String> schemaSelector;
    private JButton selectButton;
    private JButton cancelButton;

    public DbActionOptionsDialog(Frame owner, String title, Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema) throws HeadlessException {
        super(owner, title);
        this.init();
        this.initController();
        this.initFromModel(catalogs, schemas, currentCatalog, currentSchema);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.centerWindow();
    }

    protected void init() {
        this.selectButton = new JButton("Continue");
        this.cancelButton = new JButton("Cancel");
        this.catalogSelector = new JComboBox();
        this.schemaSelector = new JComboBox();
        this.getRootPane().setDefaultButton(this.selectButton);
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:max(170dlu;pref):grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.initForm(builder);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.cancelButton);
        buttons.add(this.selectButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
    }

    protected void initController() {
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbActionOptionsDialog.this.processSelect();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbActionOptionsDialog.this.processCancel();
            }
        });
    }

    protected void initFromModel(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema) {
        this.choice = 0;
        boolean showSchemaSelector = schemas != null && !schemas.isEmpty();
        this.schemaSelector.setVisible(showSchemaSelector);
        this.schemaLabel.setVisible(showSchemaSelector);
        if (showSchemaSelector) {
            this.schemaSelector.setModel(new DefaultComboBoxModel<String>(schemas.toArray(new String[0])));
            if (currentSchema != null) {
                for (String schema : schemas) {
                    if (!currentSchema.equalsIgnoreCase(schema)) continue;
                    this.schemaSelector.setSelectedItem(schema);
                    break;
                }
            }
        }
        boolean showCatalogSelector = catalogs != null && !catalogs.isEmpty();
        this.catalogSelector.setVisible(showCatalogSelector);
        this.catalogLabel.setVisible(showCatalogSelector);
        if (showCatalogSelector) {
            this.catalogSelector.setModel(new DefaultComboBoxModel<String>(catalogs.toArray(new String[0])));
            if (currentCatalog != null && !currentCatalog.isEmpty()) {
                for (String catalog : catalogs) {
                    if (!currentCatalog.equalsIgnoreCase(catalog)) continue;
                    this.catalogSelector.setSelectedItem(catalog);
                    break;
                }
            }
        }
    }

    protected void initForm(DefaultFormBuilder builder) {
        this.catalogLabel = builder.append("Select Catalog:", this.catalogSelector, true);
        this.schemaLabel = builder.append("Select Schema:", this.schemaSelector);
    }

    public int getChoice() {
        return this.choice;
    }

    private void processSelect() {
        this.choice = 1;
        this.setVisible(false);
    }

    private void processCancel() {
        this.choice = 0;
        this.setVisible(false);
    }

    public String getSelectedCatalog() {
        String catalog = (String)this.catalogSelector.getSelectedItem();
        return "".equals(catalog) ? null : catalog;
    }

    public String getSelectedSchema() {
        String schema = (String)this.schemaSelector.getSelectedItem();
        return "".equals(schema) ? null : schema;
    }
}

