/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.List;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;

class OracleSelectTranslator
extends DefaultSelectTranslator {
    public OracleSelectTranslator(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    @Override
    protected void appendLimitAndOffsetClauses(StringBuilder buffer) {
        int offset = this.queryMetadata.getFetchOffset();
        int limit = this.queryMetadata.getFetchLimit();
        if (limit > 0 || offset > 0) {
            int max = limit <= 0 ? Integer.MAX_VALUE : limit + offset;
            buffer.insert(0, "select * from ( select tid.*, ROWNUM rnum from (");
            buffer.append(") tid where ROWNUM <=").append(max).append(") where rnum  > ").append(offset);
        }
    }

    @Override
    protected void appendSelectColumns(StringBuilder buffer, List<String> selectColumnExpList) {
        int columnCount = selectColumnExpList.size();
        buffer.append(selectColumnExpList.get(0));
        if (!selectColumnExpList.get(0).contains(" AS ")) {
            buffer.append(" AS c0");
        }
        for (int i = 1; i < columnCount; ++i) {
            buffer.append(", ");
            buffer.append(selectColumnExpList.get(i));
            if (selectColumnExpList.get(i).contains(" AS ")) continue;
            buffer.append(" AS c").append(i);
        }
    }
}

