/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;

public class DbLoadResultDialog
extends JDialog {
    private static final int TABLE_ROW_HIGH = 24;
    private static final int TABLE_ROW_MARGIN = 3;
    private JButton okButton;
    private JButton revertButton;
    private String title;
    private ConcurrentMap<DataMap, JTable> tableForMap;
    private JPanel tablePanel;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;

    public DbLoadResultDialog(String title) {
        this.title = title;
        this.tableForMap = new ConcurrentHashMap<DataMap, JTable>();
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.scrollPane = new JScrollPane(this.tablePanel, 22, 30);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.initElements();
        this.buildElements();
        this.configureDialog();
    }

    private void configureDialog() {
        this.setResizable(true);
        this.setTitle(this.title);
        this.setModal(false);
        this.setPreferredSize(new Dimension(400, 400));
        this.pack();
        this.setLocationRelativeTo(Application.getFrame().getView());
    }

    private void initElements() {
        this.revertButton = new JButton("Revert");
        this.okButton = new JButton("OK");
    }

    public void buildElements() {
        this.buttonPanel.add(this.revertButton);
        this.buttonPanel.add(this.okButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.scrollPane, "Center");
        mainPanel.add((Component)this.buttonPanel, "South");
        this.add(mainPanel);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private DefaultTableModel prepareTable(DataMap dataMap) {
        if (this.tableForMap.containsKey(dataMap)) {
            return (DefaultTableModel)((JTable)this.tableForMap.get(dataMap)).getModel();
        }
        DefaultTableModel tokensTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        JPanel tablePane = new JPanel(new BorderLayout());
        JLabel dataMapLabel = new JLabel(String.format("    %-20s", dataMap.getName()));
        dataMapLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
        tablePane.add((Component)dataMapLabel, "North");
        JTable tokensTable = new JTable(tokensTableModel);
        tokensTable.setSelectionMode(0);
        tokensTable.setRowHeight(24);
        tokensTable.setRowMargin(3);
        tokensTableModel.addColumn("");
        tablePane.add((Component)tokensTable, "Center");
        this.tableForMap.put(dataMap, tokensTable);
        this.tablePanel.add(tablePane);
        return tokensTableModel;
    }

    public void removeListenersFromButtons() {
        for (ActionListener actionListener : this.okButton.getActionListeners()) {
            this.okButton.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.revertButton.getActionListeners()) {
            this.revertButton.removeActionListener(actionListener);
        }
    }

    public synchronized void addRowToOutput(String output, DataMap dataMap) {
        this.prepareTable(dataMap).addRow(new Object[]{output});
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getRevertButton() {
        return this.revertButton;
    }

    public ConcurrentMap<DataMap, JTable> getTableForMap() {
        return this.tableForMap;
    }

    public JPanel getTablePanel() {
        return this.tablePanel;
    }
}

