/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.reflect.Type;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.DIUtil;
import org.apache.cayenne.di.spi.DecoratorProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.InjectionStack;

public class ConstructorInjectingDecoratorProvider<T>
implements DecoratorProvider<T> {
    private Class<? extends T> implementation;
    private DefaultInjector injector;

    public ConstructorInjectingDecoratorProvider(Class<? extends T> implementation, DefaultInjector injector) {
        this.implementation = implementation;
        this.injector = injector;
    }

    @Override
    public Provider<T> get(final Provider<T> undecorated) throws DIRuntimeException {
        return new ConstructorInjectingProvider<T>(this.implementation, this.injector){

            @Override
            protected Object value(Class<?> parameter, Type genericType, String bindingName, InjectionStack stack) {
                if (Provider.class.equals(parameter)) {
                    Class objectClass = DIUtil.parameterClass(genericType);
                    if (objectClass == null) {
                        throw new DIRuntimeException("Constructor provider parameter %s must be parameterized to be usable for injection", parameter.getName());
                    }
                    if (objectClass.isAssignableFrom(ConstructorInjectingDecoratorProvider.this.implementation)) {
                        return undecorated;
                    }
                } else if (parameter.isAssignableFrom(ConstructorInjectingDecoratorProvider.this.implementation)) {
                    return undecorated.get();
                }
                return super.value(parameter, genericType, bindingName, stack);
            }
        };
    }
}

